/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.util.Timer;
import java.util.TimerTask;

class TimeoutTimer
extends Timer {
    private TimeoutTimerTask task;
    private boolean result;
    private long timeout;
    private long startTime;
    private long endTime;

    TimeoutTimer() {
    }

    public void schedule(long timeout) {
        this.task = new TimeoutTimerTask();
        this.result = false;
        this.timeout = timeout;
        this.startTime = System.currentTimeMillis();
        this.schedule((TimerTask)this.task, timeout);
    }

    public long stop() {
        this.task.cancel();
        this.task = null;
        this.endTime = System.currentTimeMillis();
        long timeSpent = this.endTime - this.startTime;
        if (timeSpent >= this.timeout) {
            return 0L;
        }
        return (this.timeout - timeSpent) / 1000L * 1000L;
    }

    public boolean isTimeout() {
        if (this.task != null) {
            this.result = this.task.isFinished();
        }
        return this.result;
    }

    static class TimeoutTimerTask
    extends TimerTask {
        private boolean finished;

        TimeoutTimerTask() {
        }

        @Override
        public void run() {
            this.finished = true;
        }

        private boolean isFinished() {
            return this.finished;
        }
    }
}

