/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.CMPragmaHandler;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.IVarArgsHandler;
import ro.amiq.dvt.buildconfig.PrecompilePragmaHandler;
import ro.amiq.dvt.buildconfig.VarArgsHandlerStatus;
import ro.amiq.dvt.buildconfig.XLRMHandler;

public class VarArgsCompatibilityUtils
implements IBuildConfigParserConstants {
    private static final Map<String, IVarArgsHandler> ARGS_MAP = ImmutableMap.of((Object)"-xlrm", (Object)new XLRMHandler(), (Object)"-cm_pragma", (Object)new CMPragmaHandler(), (Object)"-precompile", (Object)new PrecompilePragmaHandler());

    public static boolean contains(String directive) {
        return ARGS_MAP.containsKey(directive);
    }

    private static IVarArgsHandler getHandler(String directive) {
        return ARGS_MAP.get(directive);
    }

    public static VarArgsHandlerStatus handle(String directive, BuildConfigParser parser) {
        if (VarArgsCompatibilityUtils.contains(directive)) {
            return VarArgsCompatibilityUtils.getHandler(directive).handle(directive, parser);
        }
        return new VarArgsHandlerStatus(directive, true);
    }
}

