/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.buildconfig.AutoConfigResult;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.XilinxISEParser;
import ro.amiq.dvt.buildconfig.XilinxProjectConfigParser;
import ro.amiq.dvt.buildconfig.XilinxVivadoParser;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public class XilinxAutoconfigUtils {
    public static final String XILINX_DEBUG_PREFIX = "Autoconfig - Xilinx: ";

    public static AutoConfigResult getXilinxAutoConfigResult(IProject project, String compilationRootPath, XilinxProjectInfo xilinxProjectInfo, BuildConfigParser.AutoConfigParameters parameters, DVTBuildConsole buildConsole, IProgressMonitor buildConfigMonitor) {
        try {
            String activeSimulationFileset;
            String activeXISEFile;
            File[] projectFiles = xilinxProjectInfo.projectFiles;
            if (projectFiles.length == 0) {
                throw new Exception("No Xilinx " + xilinxProjectInfo.projectType.toolName + " project files found!");
            }
            File projectConfigFile = null;
            if (xilinxProjectInfo.projectType == XilinxProjectType.ISE_PROJECT && !(activeXISEFile = (String)BuildConfigManager.getDVTConfig(project, parameters.invocation, IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_ISE_XISE_FILE)).isEmpty()) {
                File[] fileArray = projectFiles;
                int n = projectFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File projectFile = fileArray[n2];
                    if (activeXISEFile.equals(FilenameUtils.getName((String)projectFile.getCanonicalPath()))) {
                        projectConfigFile = projectFile;
                    }
                    ++n2;
                }
                if (projectConfigFile == null) {
                    buildConsole.print("File specified using +dvt_autoconfig_ise_xise not found: " + activeXISEFile + ".\nConfigure using existing " + xilinxProjectInfo.projectType.projectFileSuffix + " files.");
                }
            }
            if (projectConfigFile == null && projectFiles.length > 1) {
                buildConsole.print("Found multiple " + xilinxProjectInfo.projectType.projectFileSuffix + " files:\n    " + DVTStringUtil.join(projectFiles, "\n    "));
            }
            if (projectConfigFile == null) {
                projectConfigFile = projectFiles[0];
            }
            if (projectConfigFile == null) {
                throw new Exception("Null project file!");
            }
            buildConsole.print("Using:\n    " + projectConfigFile.getCanonicalPath());
            if (!projectConfigFile.canRead()) {
                throw new Exception("Project file " + projectConfigFile.getCanonicalPath() + " not readable!");
            }
            XilinxProjectConfigParser configFileParser = xilinxProjectInfo.projectType.getConfigParser(project.getName(), projectConfigFile, compilationRootPath, parameters, buildConsole, buildConfigMonitor);
            if (configFileParser == null) {
                return AutoConfigResult.EMPTY;
            }
            if (configFileParser instanceof XilinxVivadoParser && !(activeSimulationFileset = (String)BuildConfigManager.getDVTConfig(project, parameters.invocation, IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_VIVADO_SIM_FILESET)).isEmpty()) {
                ((XilinxVivadoParser)configFileParser).setActiveSimulationFileSet(activeSimulationFileset);
            }
            return configFileParser.getAutoconfigResult();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(XILINX_DEBUG_PREFIX, (Throwable)e);
            buildConsole.print(XILINX_DEBUG_PREFIX + e.getMessage());
            return new AutoConfigResult(AutoConfigResult.Status.ERROR, AutoConfigResult.AlgorithmKind.XILINX).addErrorMessage(e.getMessage());
        }
    }

    public static class XilinxProjectInfo {
        public String[] dvtNatures;
        public String projectName;
        public XilinxProjectType projectType;
        public File[] projectFiles;

        public XilinxProjectInfo(File[] xilinxProjectFiles, XilinxProjectType projectType) {
            this.projectName = FilenameUtils.getBaseName((String)xilinxProjectFiles[0].getName());
            this.projectType = projectType;
            this.projectFiles = xilinxProjectFiles;
        }

        public void setProjectNatures(String[] dvtNatureIds) {
            this.dvtNatures = dvtNatureIds;
        }
    }

    public static enum XilinxProjectType {
        ISE_PROJECT(".xise", "ISE"),
        VIVADO_PROJECT(".xpr", "Vivado");

        public String projectFileSuffix;
        public String toolName;

        private XilinxProjectType(String projectFileSuffix, String toolName) {
            this.projectFileSuffix = projectFileSuffix;
            this.toolName = toolName;
        }

        public XilinxProjectConfigParser getConfigParser(String projectName, File xmlFile, String projectRoot, BuildConfigParser.AutoConfigParameters parameters, DVTBuildConsole buildConsole, IProgressMonitor buildConfigMonitor) throws Exception {
            if (this.equals((Object)ISE_PROJECT)) {
                return new XilinxISEParser(xmlFile, projectRoot, parameters, buildConsole, buildConfigMonitor);
            }
            if (this.equals((Object)VIVADO_PROJECT)) {
                return new XilinxVivadoParser(xmlFile, projectRoot, parameters, buildConsole, buildConfigMonitor);
            }
            return null;
        }

        public String getXilinxTool() {
            return this.toolName;
        }
    }
}

