/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.buildconfig.XilinxConfigParser;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.startup.core.DVTLogger;

public class XilinxBXMLParser
extends XilinxConfigParser {
    public static final String SOURCE_FILES = "//Root/CompositeFile/FileCollection[@Name='SOURCES']/File";
    private Map<String, String> includedFilesToLib;
    private Set<String> BXMLFileTypes = new HashSet<String>(Arrays.asList("IP", "VHDL", "Verilog"));

    public XilinxBXMLParser(File xmlFile, String projectRoot, DVTBuildConsole logConsole, IProgressMonitor buildConfigMonitor) throws Exception {
        super(xmlFile, projectRoot, logConsole, buildConfigMonitor);
        this.includedFilesToLib = new LinkedHashMap<String, String>();
    }

    @Override
    protected void parse() throws Exception {
        NodeList sourceFilesNodes = (NodeList)this.makeXPathQuery(SOURCE_FILES, this.xmlDocument, XPathConstants.NODESET);
        if (sourceFilesNodes == null) {
            return;
        }
        int i = 0;
        while (i < sourceFilesNodes.getLength()) {
            try {
                String fileType;
                Element sourceFileElement;
                String fileName;
                File file;
                if (this.buildConfigMonitor.isCanceled()) {
                    return;
                }
                Node sourceFileNode = sourceFilesNodes.item(i);
                if (sourceFileNode instanceof Element && (file = this.projectRoot.resolve(FilenameUtils.separatorsToSystem((String)(fileName = (sourceFileElement = (Element)sourceFileNode).getAttribute("Name")))).toFile()).exists() && this.BXMLFileTypes.contains(fileType = sourceFileElement.getAttribute("Type"))) {
                    String fileLibrary = (String)this.makeXPathQuery("Library/@Name", sourceFileElement, XPathConstants.STRING);
                    if (fileLibrary == null) {
                        fileLibrary = "";
                    }
                    this.includedFilesToLib.put(file.getCanonicalPath(), fileLibrary);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError("Exception while parsing files: ", (Throwable)e);
            }
            ++i;
        }
    }

    public Map<String, String> getParseResult() throws Exception {
        this.parse();
        return this.includedFilesToLib;
    }
}

