/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.XMLErrorHandler;

public abstract class XilinxConfigParser {
    protected static final String SYNTAX_PREFIX = "+dvt_ext_unmap_all\n+dvt_ext_unmapped_syntax+";
    protected File xmlFile;
    protected XPath xpath;
    protected Document xmlDocument;
    protected Path projectRoot;
    protected DVTBuildConsole logConsole;
    protected static final String NEW_LINE = System.lineSeparator();
    protected IProgressMonitor buildConfigMonitor;
    protected String parsedFilePath;

    public XilinxConfigParser(File xmlFile, String projectRoot, DVTBuildConsole logConsole, IProgressMonitor buildConfigMonitor) throws Exception {
        this.xmlFile = xmlFile;
        this.logConsole = logConsole;
        this.buildConfigMonitor = buildConfigMonitor;
        this.projectRoot = Paths.get(projectRoot, new String[0]);
        this.parsedFilePath = xmlFile.getCanonicalPath();
        this.xpath = XPathFactory.newInstance().newXPath();
        this.setDocumentToParse();
    }

    private void setDocumentToParse() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        this.xmlDocument = builder.parse(this.xmlFile);
        if (this.xmlDocument == null) {
            throw new Exception("XML Document could not be created by parser!");
        }
    }

    public Object makeXPathQuery(String queryXPath, Object queryRoot, QName queryType) throws XPathExpressionException {
        return this.xpath.compile(queryXPath).evaluate(queryRoot, queryType);
    }

    protected void addFileToLibrary(Map<String, XilinxFilesContainer> container, String filePath, String fileLibrary, String fileSyntax) {
        this.logConsole.print("Adding to library " + fileLibrary + " file: " + filePath, DVTBuildConsoleCommon.MessageSink.FILE);
        XilinxFilesContainer filesContainer = this.getFilesContainerForLibrary(container, fileLibrary);
        filesContainer.addFile(filePath, fileSyntax);
    }

    protected void addFilesToLibrary(Map<String, XilinxFilesContainer> container, Collection<String> filePaths, String fileLibrary, String fileSyntax) {
        this.logConsole.print("Adding to library " + fileLibrary + " file: " + DVTStringUtil.join(filePaths, "\n"), DVTBuildConsoleCommon.MessageSink.FILE);
        XilinxFilesContainer filesContainer = this.getFilesContainerForLibrary(container, fileLibrary);
        filesContainer.addFiles(filePaths, fileSyntax);
    }

    private XilinxFilesContainer getFilesContainerForLibrary(Map<String, XilinxFilesContainer> container, String fileLibrary) {
        XilinxFilesContainer filesContainer = container.get(fileLibrary);
        if (filesContainer == null) {
            filesContainer = new XilinxFilesContainer();
            container.put(fileLibrary, filesContainer);
        }
        return filesContainer;
    }

    protected abstract void parse() throws Exception;

    protected static class XilinxFilesContainer {
        Map<String, Collection<String>> syntaxToFilePaths = new LinkedHashMap<String, Collection<String>>();

        public void addFile(String filePath, String fileSyntax) {
            Collection<String> filesForSyntax = this.getFilePathsContainerForSyntax(fileSyntax);
            filesForSyntax.add(filePath);
        }

        public void addFiles(Collection<String> filePaths, String fileSyntax) {
            Collection<String> filesForSyntax = this.getFilePathsContainerForSyntax(fileSyntax);
            filesForSyntax.addAll(filePaths);
        }

        private Collection<String> getFilePathsContainerForSyntax(String fileSyntax) {
            Collection<String> filesForSyntax = this.syntaxToFilePaths.get(fileSyntax);
            if (filesForSyntax == null) {
                filesForSyntax = new LinkedHashSet<String>();
                this.syntaxToFilePaths.put(fileSyntax, filesForSyntax);
            }
            return filesForSyntax;
        }
    }
}

