/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.buildconfig.XilinxConfigParser;
import ro.amiq.dvt.buildconfig.XilinxVivadoParser;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.startup.core.DVTLogger;

public class XilinxIPParser
extends XilinxConfigParser {
    private static final String TRUE = "true";
    private static final String FILESET_PEFIX = "component/fileSets/fileSet[name = '";
    private static final String FILESET_SUFFIX = "']/file";
    private static final String FILE_TYPE_XPATH = "fileType/text()";
    private static final String USER_FILE_TYPE_XPATH = "userFileType/text()";
    private static final String FILE_NAME_XPATH = "name/text()";
    private static final String FILE_LIBRARY_XPATH = "logicalName/text()";
    private static final String IS_INCLUDE_FILE_XPATH = "isIncludeFile/text()";
    private static final String SUBCORE_ELAB_FILESET_REFS_NAME = "xilinx_elaboratesubcores";
    private static final String VERILOG_SIM_FILESET_REFS_NAME = "xilinx_verilogbehavioralsimulation";
    private static final String VERILOG_SIM_WRAPPER_FILESET_REFS_NAME = "xilinx_verilogsimulationwrapper";
    private static final String VHDL_SIM_FILESET_REFS_NAME = "xilinx_vhdlbehavioralsimulation";
    private static final String VHDL_SIM_WRAPPER_FILESET_REFS_NAME = "xilinx_vhdlsimulationwrapper";
    private static final String ANYLANG_SIM_FILESET_REFS_NAME = "xilinx_anylanguagebehavioralsimulation";
    private static final String ANYLANG_SIM_WRAPPER_FILESET_REFS_NAME = "xilinx_anylanguagesimulationwrapper";
    private static final String SUBCORE_ELAB_SET_REF_NAMES_XPATH = "component/model/views/view[name = 'xilinx_elaboratesubcores']/fileSetRef/localName/text()";
    private static final String VLOG_FILE_SET_REF_NAMES_XPATH = "component/model/views/view[name = 'xilinx_verilogbehavioralsimulation']/fileSetRef/localName/text()";
    private static final String VLOG_WRAPPER_FILE_SET_REF_NAMES_XPATH = "component/model/views/view[name = 'xilinx_verilogsimulationwrapper']/fileSetRef/localName/text()";
    private static final String VHDL_FILE_SET_REF_NAMES_XPATH = "component/model/views/view[name = 'xilinx_vhdlbehavioralsimulation']/fileSetRef/localName/text()";
    private static final String VHDL_WRAPPER_FILE_SET_REF_NAMES_XPATH = "component/model/views/view[name = 'xilinx_vhdlsimulationwrapper']/fileSetRef/localName/text()";
    private static final String ANYLANG_FILE_SET_REF_NAMES_XPATH = "component/model/views/view[name = 'xilinx_anylanguagebehavioralsimulation']/fileSetRef/localName/text()";
    private static final String ANYLANG_WRAPPER_FILE_SET_REF_NAMES_XPATH = "component/model/views/view[name = 'xilinx_anylanguagesimulationwrapper']/fileSetRef/localName/text()";
    private File IPRootDir;
    private String defaultLibrary;
    private Set<String> incdirs;
    private Map<String, XilinxConfigParser.XilinxFilesContainer> librariesToFiles;

    public XilinxIPParser(File xmlFile, String projectRoot, String defaultLibrary, DVTBuildConsole logConsole, IProgressMonitor buildConfigMonitor) throws Exception {
        super(xmlFile, projectRoot, logConsole, buildConfigMonitor);
        this.defaultLibrary = defaultLibrary;
        this.IPRootDir = xmlFile.getParentFile();
        this.incdirs = new HashSet<String>();
        this.librariesToFiles = new LinkedHashMap<String, XilinxConfigParser.XilinxFilesContainer>();
    }

    @Override
    protected void parse() throws Exception {
        this.parseFileIPSourceFiles(VLOG_FILE_SET_REF_NAMES_XPATH);
        this.parseFileIPSourceFiles(VLOG_WRAPPER_FILE_SET_REF_NAMES_XPATH);
        this.parseFileIPSourceFiles(VHDL_FILE_SET_REF_NAMES_XPATH);
        this.parseFileIPSourceFiles(VHDL_WRAPPER_FILE_SET_REF_NAMES_XPATH);
        this.parseFileIPSourceFiles(ANYLANG_FILE_SET_REF_NAMES_XPATH);
        this.parseFileIPSourceFiles(ANYLANG_WRAPPER_FILE_SET_REF_NAMES_XPATH);
        this.parseFileIPSourceFiles(SUBCORE_ELAB_SET_REF_NAMES_XPATH);
    }

    private void parseFileIPSourceFiles(String fileSetTypeXPath) throws Exception, XPathExpressionException, IOException {
        List<String> fileSetRefs = this.getFileSetReferences(fileSetTypeXPath);
        if (fileSetRefs == null) {
            return;
        }
        for (String fileSetName : fileSetRefs) {
            try {
                if (this.buildConfigMonitor.isCanceled()) {
                    return;
                }
                NodeList fileNodes = (NodeList)this.makeXPathQuery(FILESET_PEFIX + fileSetName + FILESET_SUFFIX, this.xmlDocument, XPathConstants.NODESET);
                if (fileNodes == null || fileNodes.getLength() == 0) continue;
                int i = 0;
                while (i < fileNodes.getLength()) {
                    String fileName;
                    if (this.buildConfigMonitor.isCanceled()) {
                        return;
                    }
                    Node fileNode = fileNodes.item(i);
                    Node fileNameNode = (Node)this.makeXPathQuery(FILE_NAME_XPATH, fileNode, XPathConstants.NODE);
                    if (fileNameNode.getNodeType() == 3 && (fileName = fileNameNode.getNodeValue()) != null && !fileName.isEmpty()) {
                        String fileType;
                        XilinxVivadoParser.VivadoFileTypes vivadoFileType;
                        Node fileTypeNode = (Node)this.makeXPathQuery(FILE_TYPE_XPATH, fileNode, XPathConstants.NODE);
                        if (fileTypeNode == null) {
                            fileTypeNode = (Node)this.makeXPathQuery(USER_FILE_TYPE_XPATH, fileNode, XPathConstants.NODE);
                        }
                        if (fileTypeNode != null && fileTypeNode.getNodeType() == 3 && (vivadoFileType = XilinxVivadoParser.VivadoFileTypes.getFileTypeFromIPFileType(fileType = fileTypeNode.getNodeValue())) != null) {
                            fileName = FilenameUtils.separatorsToSystem((String)fileName);
                            Path filePath = this.IPRootDir.toPath().resolve(fileName);
                            if (filePath.toFile().exists()) {
                                if (vivadoFileType.equals((Object)XilinxVivadoParser.VivadoFileTypes.IP_INCLUDE)) {
                                    XilinxIPParser includedIPParser = new XilinxIPParser(filePath.toFile(), filePath.getParent().toAbsolutePath().toString(), this.defaultLibrary, this.logConsole, this.buildConfigMonitor);
                                    this.addFilesFromParseResult(includedIPParser.getParseResult());
                                } else {
                                    Node isIncludeNode = (Node)this.makeXPathQuery(IS_INCLUDE_FILE_XPATH, fileNode, XPathConstants.NODE);
                                    if (isIncludeNode != null && isIncludeNode.getNodeType() == 3 && TRUE.equals(isIncludeNode.getNodeValue())) {
                                        this.incdirs.add(filePath.getParent().toFile().getCanonicalPath());
                                    } else {
                                        String fileLibraryValue;
                                        String fileLibrary = this.defaultLibrary;
                                        Node fileLibraryNode = (Node)this.makeXPathQuery(FILE_LIBRARY_XPATH, fileNode, XPathConstants.NODE);
                                        if (fileLibraryNode != null && fileLibraryNode.getNodeType() == 3 && (fileLibraryValue = fileLibraryNode.getNodeValue()) != null && !fileLibraryValue.isEmpty()) {
                                            fileLibrary = fileLibraryValue;
                                        }
                                        this.addFileToLibrary(this.librariesToFiles, filePath.toFile().getCanonicalPath(), fileLibrary, vivadoFileType.dvtSyntaxName);
                                    }
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError("Exception while parsing fileset: " + fileSetName, (Throwable)e);
            }
        }
    }

    public ParseResult getParseResult() throws Exception {
        this.parse();
        return new ParseResult(this.librariesToFiles, this.incdirs);
    }

    private List<String> getFileSetReferences(String fileSetXPath) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(fileSetXPath);
        NodeList fileSetsRefNodes = (NodeList)expr.evaluate(this.xmlDocument, XPathConstants.NODESET);
        int i = 0;
        while (i < fileSetsRefNodes.getLength()) {
            String nodeValue;
            if (this.buildConfigMonitor.isCanceled()) {
                return result;
            }
            Node fileSetsRefNode = fileSetsRefNodes.item(i);
            if (fileSetsRefNode.getNodeType() == 3 && (nodeValue = fileSetsRefNode.getNodeValue()) != null && !nodeValue.isEmpty()) {
                result.add(nodeValue);
            }
            ++i;
        }
        return result;
    }

    public void addFilesFromParseResult(ParseResult result) {
        this.incdirs.addAll(result.incdirs);
        for (Map.Entry<String, XilinxConfigParser.XilinxFilesContainer> librariesToFileContainers : result.librariesToFileContainers.entrySet()) {
            String fileLibrary = librariesToFileContainers.getKey();
            XilinxConfigParser.XilinxFilesContainer fileContainer = librariesToFileContainers.getValue();
            for (Map.Entry<String, Collection<String>> syntaxToFilePaths : fileContainer.syntaxToFilePaths.entrySet()) {
                this.addFilesToLibrary(this.librariesToFiles, syntaxToFilePaths.getValue(), fileLibrary, syntaxToFilePaths.getKey());
            }
        }
    }

    static class ParseResult {
        Map<String, XilinxConfigParser.XilinxFilesContainer> librariesToFileContainers;
        Set<String> incdirs;

        public ParseResult(Map<String, XilinxConfigParser.XilinxFilesContainer> libsToFiles, Set<String> incdirs) {
            this.incdirs = incdirs;
            this.librariesToFileContainers = libsToFiles;
        }
    }
}

