/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.buildconfig.AutoConfig;
import ro.amiq.dvt.buildconfig.AutoConfigResult;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.XilinxConfigParser;
import ro.amiq.dvt.buildconfig.XilinxProjectConfigParser;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.startup.core.DVTLogger;

public class XilinxISEParser
extends XilinxProjectConfigParser {
    private static final String PROJECT_PROPERTY_PREFIX = "/project/properties/property[@name = '";
    private static final String PROJECT_PROPERTY_SUFFIX = "']";
    private static final String FILE_NODES_XPATH = "/project/files/file";
    private static final String INCDIR_FILE_NODES_XPATH = "/project/autoManagedFiles/file";
    private static final String LIBRARY_NODES_XPATH = "/project/libraries/library";
    private static final String NO_SOURCE_FILES_MESSAGE = "No source files found in project configuration!";
    private static final String NO_LIBRARIES_MESSAGE = "No library definitions found.";
    private static final String INCLUDED_IP_FILE_PREFIX = "Found included ip core file:\n    ";
    private static final char SLASH = '/';
    private static final String WORK = "work";
    private static final String LIBRARY_TAG = "library";
    private static final String TYPE_ATTR = "xil_pn:type";
    private static final String NAME_ATTR = "xil_pn:name";
    private static final String VALUE_ATTR = "xil_pn:value";
    private static final String TRUE = "true";
    private static final String TOP_INST_PATH_PROPERTY = "Implementation Top Instance Path";
    private Map<String, String> XILINX_LIBS_VHDL = new ImmutableMap.Builder().put((Object)"Compile CPLD Simulation Library", (Object)"CPLD").put((Object)"Compile UNISIM (Functional) Simulation Library", (Object)"UNISIM").put((Object)"Compile SIMPRIM (Timing) Simulation Library", (Object)"SIMPRIM").put((Object)"Compile uni9000 (Functional) Simulation Library", (Object)"UNI9000_VER").put((Object)"Compile XilinxCoreLib (CORE Generator) Simulation Library", (Object)"XILINXCORELIB").build();
    private Map<String, String> XILINX_LIBS_VLOG = new ImmutableMap.Builder().put((Object)"Compile CPLD Simulation Library", (Object)"CPLD_VER").put((Object)"Compile UNISIM (Functional) Simulation Library", (Object)"UNISIMS_VER").put((Object)"Compile SIMPRIM (Timing) Simulation Library", (Object)"SIMPRIMS_VER").put((Object)"Compile uni9000 (Functional) Simulation Library", (Object)"UNI9000_VER").put((Object)"Compile XilinxCoreLib (CORE Generator) Simulation Library", (Object)"XILINXCORELIB_VER").build();
    private static final String LANGUAGE_PROPERTY = "Simulation Model Target";
    private static final String LANGUAGE_PROPERTY_NAME = "Language";
    private static final String LANGUAGE_PROPERTY_VLOG_VALUE = "Verilog";
    private static final String LANGUAGE_PROPERTY_VHDL_VALUE = "VHDL";
    private static final String LANGUAGE_PROPERTY_ALL_VALUE = "All";
    private static final String SYNTAX_VERSION_VHDL_PROPERTY = "VHDL Source Analysis Standard";
    private static final String SYNTAX_VERSION_VLOG_PROPERTY = "Verilog Standard";
    private static final Object NodeList = null;
    private Map<String, String> SYNTAX_VERSION_PROPERTY_VALUES = ImmutableMap.of((Object)"VHDL-200X", (Object)"VHDL_2008", (Object)"VHDL-93", (Object)"VHDL_93", (Object)"Verilog 2001", (Object)"Verilog_2001");
    private Map<String, XilinxConfigParser.XilinxFilesContainer> librariesToFileContainers;
    private Set<String> xilinxLibsToCompile;
    private Set<String> incdirs;
    private Invocation invocation;

    public XilinxISEParser(File xmlFile, String projectRoot, BuildConfigParser.AutoConfigParameters parameters, DVTBuildConsole logConsole, IProgressMonitor buildConfigMonitor) throws Exception {
        super(xmlFile, projectRoot, parameters, logConsole, buildConfigMonitor);
        this.invocation = parameters == null ? null : parameters.invocation;
        this.librariesToFileContainers = new LinkedHashMap<String, XilinxConfigParser.XilinxFilesContainer>();
        this.xilinxLibsToCompile = new HashSet<String>();
        this.incdirs = new HashSet<String>();
    }

    @Override
    public void parseProjectConfiguration() throws Exception {
        String topInstancePath;
        int leafStartIndex;
        Object topInstanceProperty = this.makeXPathQuery("/project/properties/property[@name = 'Implementation Top Instance Path']", this.xmlDocument, XPathConstants.NODE);
        if (topInstanceProperty instanceof Element && (leafStartIndex = (topInstancePath = ((Element)topInstanceProperty).getAttribute(VALUE_ATTR)).lastIndexOf(47) + 1) > 0) {
            String topInstanceName = topInstancePath.substring(leafStartIndex);
            this.globalHeader = "-top " + topInstanceName + NEW_LINE + this.globalHeader;
        }
        for (Map.Entry<String, String> entry : this.XILINX_LIBS_VHDL.entrySet()) {
            String value;
            String xilinxLibProperty = entry.getKey();
            Object propertyNode = this.makeXPathQuery(PROJECT_PROPERTY_PREFIX + xilinxLibProperty + PROJECT_PROPERTY_SUFFIX, this.xmlDocument, XPathConstants.NODE);
            if (!(propertyNode instanceof Element) || !TRUE.equals(value = ((Element)propertyNode).getAttribute(VALUE_ATTR))) continue;
            if (this.hasVHDLNature) {
                this.xilinxLibsToCompile.add(entry.getValue());
                continue;
            }
            if (!this.hasVlogNature) continue;
            this.xilinxLibsToCompile.add(this.XILINX_LIBS_VLOG.get(xilinxLibProperty));
        }
    }

    @Override
    public void parseSourceFiles() throws Exception {
        this.gatherISEProjectLibraries();
        this.gatherXISEProjectFiles();
        this.gatherProjectIncdirs();
    }

    private void gatherProjectIncdirs() throws Exception {
        try {
            Object queryResult = this.makeXPathQuery(INCDIR_FILE_NODES_XPATH, this.xmlDocument, XPathConstants.NODESET);
            if (!(queryResult instanceof NodeList)) {
                return;
            }
            NodeList includedFileNodes = (NodeList)queryResult;
            int i = 0;
            while (i < includedFileNodes.getLength()) {
                ISEFileTypes fileType;
                if (this.buildConfigMonitor.isCanceled()) {
                    return;
                }
                Element file = (Element)includedFileNodes.item(i);
                String relativeFilePath = file.getAttribute(NAME_ATTR);
                String fileTypeValue = file.getAttribute(TYPE_ATTR);
                if (!(relativeFilePath = FilenameUtils.separatorsToSystem((String)relativeFilePath)).isEmpty() && !fileTypeValue.isEmpty() && (fileType = ISEFileTypes.from(fileTypeValue)) != null) {
                    Path parentDirOfFile;
                    Path filePath = Paths.get(relativeFilePath, new String[0]);
                    if (!filePath.isAbsolute()) {
                        filePath = this.projectRoot.resolve(filePath);
                    }
                    if ((parentDirOfFile = filePath.getParent()).toFile().exists() && !this.projectRoot.equals(parentDirOfFile)) {
                        this.incdirs.add(parentDirOfFile.toFile().getCanonicalPath());
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Exception while parsing incdirs: ", (Throwable)e);
        }
    }

    private void gatherXISEProjectFiles() throws Exception {
        try {
            Object queryResult = this.makeXPathQuery(FILE_NODES_XPATH, this.xmlDocument, XPathConstants.NODESET);
            if (!(queryResult instanceof NodeList)) {
                this.logConsole.print(NO_SOURCE_FILES_MESSAGE);
                return;
            }
            NodeList fileElements = (NodeList)queryResult;
            int i = 0;
            while (i < fileElements.getLength()) {
                try {
                    ISEFileTypes fileType;
                    if (this.buildConfigMonitor.isCanceled()) {
                        return;
                    }
                    Element fileElement = (Element)fileElements.item(i);
                    String fileTypeValue = fileElement.getAttribute(TYPE_ATTR);
                    String relativeFilePath = fileElement.getAttribute(NAME_ATTR);
                    if (!(relativeFilePath = FilenameUtils.separatorsToSystem((String)relativeFilePath)).isEmpty() && !fileTypeValue.isEmpty() && (fileType = ISEFileTypes.from(fileTypeValue)) != null) {
                        if (fileType == ISEFileTypes.FILE_IP_INCLUDE) {
                            this.addIncludedFilesForIP(relativeFilePath);
                        } else {
                            File file;
                            Node fileLibraryNode;
                            String libraryName = "";
                            NodeList fileLibrary = fileElement.getElementsByTagName(LIBRARY_TAG);
                            if (fileLibrary != null && fileLibrary.getLength() > 0 && (fileLibraryNode = fileLibrary.item(0)) instanceof Element) {
                                libraryName = ((Element)fileLibraryNode).getAttribute(NAME_ATTR);
                            }
                            if (!(file = Paths.get(relativeFilePath, new String[0]).toFile()).isAbsolute()) {
                                file = this.projectRoot.resolve(file.getPath()).toFile();
                            }
                            this.addFileToLibrary(this.librariesToFileContainers, file.getCanonicalPath(), libraryName.isEmpty() ? WORK : libraryName, fileType.dvtSyntaxName);
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError("Exception while parsing file: ", (Throwable)e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Exception while parsing project files: ", (Throwable)e);
        }
    }

    private void addIncludedFilesForIP(String relativeFilePath) {
        try {
            if (this.buildConfigMonitor.isCanceled()) {
                return;
            }
            File IPConfigFile = this.projectRoot.resolve(relativeFilePath).toFile();
            if (!IPConfigFile.exists()) {
                return;
            }
            this.logConsole.print(INCLUDED_IP_FILE_PREFIX + IPConfigFile.getCanonicalPath());
            XilinxISEParser includeFileParser = new XilinxISEParser(IPConfigFile, IPConfigFile.getParentFile().getCanonicalPath(), null, this.logConsole, this.buildConfigMonitor);
            Map<String, XilinxConfigParser.XilinxFilesContainer> includedFiles = includeFileParser.getIncludedFiles();
            for (Map.Entry<String, XilinxConfigParser.XilinxFilesContainer> libToFileContainer : includedFiles.entrySet()) {
                if (this.buildConfigMonitor.isCanceled()) {
                    return;
                }
                String fileLibrary = libToFileContainer.getKey();
                XilinxConfigParser.XilinxFilesContainer filesContainer = libToFileContainer.getValue();
                for (Map.Entry<String, Collection<String>> syntaxToFilePaths : filesContainer.syntaxToFilePaths.entrySet()) {
                    String fileSyntax = syntaxToFilePaths.getKey();
                    Collection<String> filePaths = syntaxToFilePaths.getValue();
                    this.addFilesToLibrary(this.librariesToFileContainers, filePaths, fileLibrary, fileSyntax);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Exception while parsing ip core file: " + relativeFilePath, (Throwable)e);
        }
    }

    private void gatherISEProjectLibraries() throws Exception {
        try {
            Object queryResult = this.makeXPathQuery(LIBRARY_NODES_XPATH, this.xmlDocument, XPathConstants.NODESET);
            if (!(queryResult instanceof NodeList)) {
                this.logConsole.print(NO_LIBRARIES_MESSAGE);
                return;
            }
            NodeList libraryElements = (NodeList)queryResult;
            int j = 0;
            while (j < libraryElements.getLength()) {
                Element library = (Element)libraryElements.item(j);
                String libraryName = library.getAttribute(NAME_ATTR);
                if (!libraryName.isEmpty() && this.librariesToFileContainers.get(libraryName) == null) {
                    this.librariesToFileContainers.put(libraryName, new XilinxConfigParser.XilinxFilesContainer());
                }
                ++j;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Exception while parsing project libraries: ", (Throwable)e);
        }
    }

    @Override
    protected AutoConfigResult internalGetAutoconfigResult() {
        String xilinxDirectives;
        if (this.buildConfigMonitor.isCanceled()) {
            return new AutoConfigResult(AutoConfigResult.Status.CANCELED);
        }
        AutoConfigResult result = new AutoConfigResult(AutoConfigResult.Status.EMPTY);
        if (!this.hasPreviousInitXilinxInvocation && !(xilinxDirectives = AutoConfig.getXilinxDirectives(this.xilinxLibsToCompile, this.invocation)).isEmpty()) {
            this.globalHeader = String.valueOf(this.globalHeader) + NEW_LINE + xilinxDirectives + NEW_LINE;
        }
        if (!this.globalHeader.isEmpty()) {
            result.append(this.globalHeader);
        }
        result.merge(this.getPartialAutoConfigResultFor(this.incdirs, Collections.emptyMap(), this.librariesToFileContainers));
        return result;
    }

    @Override
    public String[] getProjectNatures() throws Exception {
        this.hasVHDLNature = true;
        this.hasVlogNature = true;
        return new String[]{"ro.amiq.vhdldt.VhdlNature", "ro.amiq.vlogdt.VlogNature"};
    }

    private Map<String, XilinxConfigParser.XilinxFilesContainer> getIncludedFiles() throws Exception {
        this.parseSourceFiles();
        return this.librariesToFileContainers;
    }

    @Override
    protected String getCompatModeForSyntax(String syntaxName) {
        return ISEFileTypes.getCompatModeForSyntax(syntaxName);
    }

    static enum ISEFileTypes {
        FILE_VHDL("FILE_VHDL", "vcom", "VHDL_93"),
        FILE_VHDL_2008("VHDL-200X", "vcom", "VHDL_2008"),
        FILE_VERILOG("FILE_VERILOG", "vlog", "Verilog_2001"),
        FILE_IP_INCLUDE("FILE_COREGENISE", "", "");

        private String typeName;
        private String questaCompatMode;
        public String dvtSyntaxName;

        private ISEFileTypes(String typeName, String questaCompatMode, String dvtSyntaxName) {
            this.typeName = typeName;
            this.questaCompatMode = questaCompatMode;
            this.dvtSyntaxName = dvtSyntaxName;
        }

        private static ISEFileTypes from(String name) {
            ISEFileTypes[] iSEFileTypesArray = ISEFileTypes.values();
            int n = iSEFileTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISEFileTypes fileType = iSEFileTypesArray[n2];
                if (fileType.typeName.equals(name)) {
                    return fileType;
                }
                ++n2;
            }
            return null;
        }

        public static String getCompatModeForSyntax(String syntaxName) {
            if (syntaxName == null || syntaxName.isEmpty()) {
                return " ";
            }
            ISEFileTypes[] iSEFileTypesArray = ISEFileTypes.values();
            int n = iSEFileTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISEFileTypes fileType = iSEFileTypesArray[n2];
                if (fileType.dvtSyntaxName.equals(syntaxName)) {
                    return "+questa." + fileType.questaCompatMode + " ";
                }
                ++n2;
            }
            return " ";
        }
    }
}

