/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.buildconfig.AutoConfigResult;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.XilinxConfigParser;
import ro.amiq.dvt.buildconfig.XilinxISEParser;
import ro.amiq.dvt.buildconfig.XilinxVivadoParser;
import ro.amiq.dvt.builders.DVTBuildConsole;

public abstract class XilinxProjectConfigParser
extends XilinxConfigParser {
    protected static final String INCDIR_DIRECTIVE = "+incdir+";
    protected static final String TOP_DIRECTIVE = "-top ";
    protected static final String DEFINE_DIRECTIVE = "+define+";
    protected static final String DVT_PREPEND_INIT = "+dvt_prepend_init";
    protected static final String DVT_INIT = "+dvt_init";
    protected static final String WORK = "-work ";
    protected static final String QUESTA_PREFIX = "+questa.";
    protected boolean hasVHDLNature = false;
    protected boolean hasVlogNature = false;
    protected String globalHeader = "";
    protected boolean hasPreviousInitXilinxInvocation;
    private static Set<String> vlogSyntaxNames = new HashSet<String>();

    static {
        vlogSyntaxNames.add(XilinxVivadoParser.VivadoFileTypes.SYSTEM_VERILOG_FILE.dvtSyntaxName);
        vlogSyntaxNames.add(XilinxVivadoParser.VivadoFileTypes.VERILOG_FILE.dvtSyntaxName);
        vlogSyntaxNames.add(XilinxVivadoParser.VivadoFileTypes.VERILOG_HEADER_FILE.dvtSyntaxName);
        vlogSyntaxNames.add(XilinxISEParser.ISEFileTypes.FILE_VERILOG.dvtSyntaxName);
    }

    public XilinxProjectConfigParser(File xmlFile, String projectRoot, BuildConfigParser.AutoConfigParameters parameters, DVTBuildConsole logConsole, IProgressMonitor buildConfigMonitor) throws Exception {
        super(xmlFile, projectRoot, logConsole, buildConfigMonitor);
        if (parameters != null) {
            if (parameters.reuseText != null && !parameters.reuseText.trim().isEmpty()) {
                this.globalHeader = String.valueOf(this.globalHeader) + DVT_INIT + parameters.reuseText + NEW_LINE;
            }
            this.hasPreviousInitXilinxInvocation = parameters.hasPreviousInitXilinxInvocation;
        }
    }

    public AutoConfigResult getAutoconfigResult() throws Exception {
        this.getProjectNatures();
        this.parse();
        return this.internalGetAutoconfigResult();
    }

    @Override
    public void parse() throws Exception {
        this.parseProjectConfiguration();
        this.parseSourceFiles();
    }

    protected AutoConfigResult getPartialAutoConfigResultFor(Set<String> incdirs, Map<String, String> defines, Map<String, XilinxConfigParser.XilinxFilesContainer> librariesToFileContainers) {
        if (this.buildConfigMonitor.isCanceled()) {
            return new AutoConfigResult(AutoConfigResult.Status.CANCELED);
        }
        AutoConfigResult result = new AutoConfigResult(AutoConfigResult.Status.OK, AutoConfigResult.AlgorithmKind.XILINX);
        String incdirsString = "";
        for (String incdirValue : incdirs) {
            incdirsString = String.valueOf(incdirsString) + INCDIR_DIRECTIVE + incdirValue + NEW_LINE;
        }
        String definesString = "";
        for (Map.Entry<String, String> entry : defines.entrySet()) {
            definesString = String.valueOf(definesString) + DEFINE_DIRECTIVE + entry.getKey() + "=" + entry.getValue() + NEW_LINE;
        }
        for (Map.Entry<String, Object> entry : librariesToFileContainers.entrySet()) {
            if (this.buildConfigMonitor.isCanceled()) {
                return new AutoConfigResult(AutoConfigResult.Status.CANCELED);
            }
            String libraryName = entry.getKey();
            XilinxConfigParser.XilinxFilesContainer filesContainer = (XilinxConfigParser.XilinxFilesContainer)entry.getValue();
            for (Map.Entry<String, Collection<String>> syntaxToFiles : filesContainer.syntaxToFilePaths.entrySet()) {
                String syntaxName = syntaxToFiles.getKey();
                String libraryInit = DVT_INIT + this.getCompatModeForSyntax(syntaxName) + WORK + libraryName + NEW_LINE;
                result.append(libraryInit).append("+dvt_ext_unmap_all\n+dvt_ext_unmapped_syntax+" + syntaxName + NEW_LINE);
                if (vlogSyntaxNames.contains(syntaxName)) {
                    if (!definesString.isEmpty()) {
                        result.append(String.valueOf(definesString) + NEW_LINE);
                    }
                    if (!incdirsString.isEmpty()) {
                        result.append(String.valueOf(incdirsString) + NEW_LINE);
                    }
                }
                Collection<String> filePaths = syntaxToFiles.getValue();
                for (String filePath : filePaths) {
                    result.append(String.valueOf(filePath) + NEW_LINE);
                }
                result.append(NEW_LINE);
            }
        }
        return result;
    }

    public abstract void parseProjectConfiguration() throws Exception;

    public abstract void parseSourceFiles() throws Exception;

    protected abstract AutoConfigResult internalGetAutoconfigResult() throws Exception;

    public abstract String[] getProjectNatures() throws Exception;

    protected abstract String getCompatModeForSyntax(String var1);
}

