/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.buildconfig.AutoConfigResult;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.XilinxBXMLParser;
import ro.amiq.dvt.buildconfig.XilinxConfigParser;
import ro.amiq.dvt.buildconfig.XilinxIPParser;
import ro.amiq.dvt.buildconfig.XilinxProjectConfigParser;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.startup.core.DVTLogger;

public class XilinxVivadoParser
extends XilinxProjectConfigParser {
    private static final String NON_EXISTING_INCDIR_PREFIX = "Found non existing verilog include directory: ";
    private static final String INCDIR_PREFIX = "Found verilog include directory: ";
    private static final String ANALYZING_FILESET_PREFIX = "Analyzing fileset: ";
    private static final String FILESET_CONFIG_OPTIONS_MSG = "Reading fileset config options";
    private static final String DEFINES_MSG = "Reading fileset defines";
    private static final String GENERICS_AND_PARAMETERS_MSG = "Reading fileset generics and parameters";
    private static final String BLOCK_DESIGN_FILE_PREFIX = "Found block design file:\n    ";
    private static final String BLOCKSRC_FILE_PREFIX = "Found included blocksrc file:\n    ";
    private static final String GLOBAL_INCLUDE_PREFIX = "Global include file:\n    ";
    private static final String VERILOG_HEADER_FILE_PREFIX = "Verilog header file:\n    ";
    private static final String READING_FILES_MSG = "Reading files in fileset";
    private static final String NO_FILE_NODES_MSG = "No file nodes found in fileset";
    private static final String WRITING_FILES_FOR_FILESET_PREFIX = "Writing files for fileset: ";
    private static final String FILE_DOES_NOT_EXIST_PREFIX = "File does not exist: ";
    private static final String FOUND_NO_FILESET_OF_TYPE_PREFIX = "Found no fileset of type ";
    private static final String ANALYZING_BLOCK_FILESET_PREFIX = "Analyzing block fileset: ";
    private static final String ANALYZING_INCLUDED_SOURCE_FILES_MSG = "Analyzing included source files";
    private static final String NULL_PROJECT_ELEMENT = "Null project element.";
    private static final String SOURCES_DIR_NOT_FOUND = "Sources directory inside project not found...";
    private static final String PROJECT_DIR_NOT_FOUND = "Project directory not found!";
    private static final String NO_PROJECT_CONFIG_OPTIONS_MSG = "No project configuration options found.";
    private static final String PROJECT_PATH_PREFIX = "Found project path : ";
    private static final String NO_PROJECT_ELEMENT = "No Project element found in project file";
    private static final String DEFAULT_LIBRARY_PREFIX = "Found default library: ";
    private static final String TOP_ENTITY_PREFIX = "Found top entity: ";
    private static final String ACTIVE_SIM_FILESET_PREFIX = "Found active simulation fileset : ";
    private static final String ACTIVE_DESIGN_FILESET_PREFIX = "Found active design fileset : ";
    private static final String READING_PROJECT_CONFIGURATION = "Reading project configuration";
    private static final String XML_SUFFIX = ".xml";
    private static final String BD_SUFFIX = ".bd";
    private static final String BXML_SUFFIX = ".bxml";
    private static final String XCI_SUFFIX = ".xci";
    private static final String PROJECT = "Project";
    private static final String PATH = "Path";
    private static final String FILE = "File";
    private static final String FILE_INFO = "FileInfo";
    private static final String OPTION = "Option";
    private static final String ATTRIBUTE = "Attr";
    private static final String DEFINE = "Define";
    private static final String GENERIC = "Generic";
    private static final String NAME_ATTR = "Name";
    private static final String VALUE_ATTR = "Val";
    private static final String TYPE_ATTR = "Type";
    private static final String USER_DISABLED_ATTR = "UserDisabled";
    private static final String GLOBAL_INCLUDE_ATTR = "IsGlobalInclude";
    private static final String TRUE_VALUE = "1";
    private static final String FILE_TYPE = "SFType";
    private static final String LIBRARY = "Library";
    private static final String CONFIG = "Config";
    private static final String RELATIVE_PATH_ROOT = "RelSrcDir";
    private static final String INCDIR_OPTION = "VerilogDir";
    private static final String DESIGN_SRC_SET_OPTION = "SrcSet";
    private static final String DEFAULT_DESIGN_FILESET = "sources_1";
    private static final String DESIGN_FILESET_TYPE = "DesignSrcs";
    private static final String SIM_FILESET_TYPE = "SimulationSrcs";
    private static final String IP_FILESET_TYPE = "BlockSrcs";
    private static final String DEFAULT_LIB_OPTION = "DefaultLib";
    private static final String TOP_MODULE_OPTION = "TopModule";
    private static final String TOP_LIBRARY_OPTION = "TopLib";
    private static final String ACTIVE_SIM_SET_OPTION = "ActiveSimSet";
    private static final String SIMULATOR_LANG_OPTION_XPATH = "/Project/Configuration/Option[@Name = 'SimulatorLanguage']/@Val";
    private static final String SIMULATOR_LANG_VHDL = "VHDL";
    private static final String SIMULATOR_LANG_VLOG = "Verilog";
    private static final String SRC_DIR_SUFFIX = ".srcs";
    private static final String PROJECT_DIR_VAR = "$PPRDIR";
    private static final String SOURCE_DIR_VAR = "$PSRCDIR";
    private static final String WORK_LIB = "work";
    private static final String PROJECT_CONFIGURATION_OPTION_PATH = "Configuration/Option";
    public String defaultLibrary = "work";
    private String activeSimFileSet = null;
    private String activeDesignFilesSet = null;
    private File projectDirectory = null;
    private File sourcesDirectory = null;
    private Set<String> incdirs;
    private Element projectNode;
    private Map<String, FileSetInfo> fileSetInfos;

    public XilinxVivadoParser(File xmlFile, String projectRoot, BuildConfigParser.AutoConfigParameters parameters, DVTBuildConsole logConsole, IProgressMonitor buildConfigMonitor) throws Exception {
        super(xmlFile, projectRoot, parameters, logConsole, buildConfigMonitor);
        this.projectDirectory = xmlFile.getParentFile();
        if (!(parameters == null || this.projectDirectory.exists() && this.projectDirectory.isDirectory())) {
            throw new Exception(PROJECT_DIR_NOT_FOUND);
        }
        this.sourcesDirectory = new File(this.projectDirectory, String.valueOf(FilenameUtils.getBaseName((String)xmlFile.getAbsolutePath())) + SRC_DIR_SUFFIX);
        if (!(parameters == null || this.sourcesDirectory.exists() && this.sourcesDirectory.isDirectory())) {
            logConsole.print(SOURCES_DIR_NOT_FOUND);
        }
        this.fileSetInfos = new HashMap<String, FileSetInfo>();
        this.incdirs = new LinkedHashSet<String>();
    }

    @Override
    public void parseProjectConfiguration() throws Exception {
        File projectDirectoryFile;
        this.logConsole.printSection(READING_PROJECT_CONFIGURATION);
        Object projectQueryResult = this.makeXPathQuery(PROJECT, this.xmlDocument, XPathConstants.NODE);
        if (!(projectQueryResult instanceof Element)) {
            this.logConsole.print(NO_PROJECT_ELEMENT);
            throw new Exception(NO_PROJECT_ELEMENT);
        }
        this.projectNode = (Element)projectQueryResult;
        String projectPath = this.projectNode.getAttribute(PATH);
        if (projectPath != null && !projectPath.isEmpty() && (projectDirectoryFile = new File(projectPath)).exists() && projectDirectoryFile.isDirectory()) {
            this.logConsole.print(PROJECT_PATH_PREFIX + projectDirectoryFile.getCanonicalPath());
            this.projectDirectory = projectDirectoryFile;
        }
        try {
            NodeList projectConfigOptionElements = (NodeList)this.makeXPathQuery(PROJECT_CONFIGURATION_OPTION_PATH, this.projectNode, XPathConstants.NODESET);
            if (projectConfigOptionElements == null) {
                this.logConsole.print(NO_PROJECT_CONFIG_OPTIONS_MSG);
                return;
            }
            int j = 0;
            while (j < projectConfigOptionElements.getLength()) {
                if (this.buildConfigMonitor.isCanceled()) {
                    return;
                }
                Element option = (Element)projectConfigOptionElements.item(j);
                String optionName = option.getAttribute(NAME_ATTR);
                String optionValue = option.getAttribute(VALUE_ATTR);
                if (!optionName.isEmpty() && !optionValue.isEmpty()) {
                    if (DEFAULT_LIB_OPTION.equals(optionName)) {
                        this.defaultLibrary = optionValue;
                        this.logConsole.print(DEFAULT_LIBRARY_PREFIX + this.defaultLibrary);
                    } else if (ACTIVE_SIM_SET_OPTION.equals(optionName) && (this.activeSimFileSet == null || this.activeSimFileSet.isEmpty())) {
                        this.activeSimFileSet = optionValue;
                        this.logConsole.print(ACTIVE_SIM_FILESET_PREFIX + this.activeSimFileSet);
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Exception while parsing project configuration: ", (Throwable)e);
        }
    }

    @Override
    public void parseSourceFiles() throws Exception {
        if (this.projectNode == null) {
            throw new Exception(NULL_PROJECT_ELEMENT);
        }
        this.logConsole.printSection(ANALYZING_INCLUDED_SOURCE_FILES_MSG);
        FileSetInfo simulationFileSetInfo = this.parseFileset(this.activeSimFileSet, SIM_FILESET_TYPE);
        if (simulationFileSetInfo != null && !simulationFileSetInfo.isEmpty()) {
            this.fileSetInfos.put(this.activeSimFileSet, simulationFileSetInfo);
        }
        this.activeDesignFilesSet = this.activeDesignFilesSet != null ? this.activeDesignFilesSet : DEFAULT_DESIGN_FILESET;
        FileSetInfo designFileSetInfo = this.parseFileset(this.activeDesignFilesSet, DESIGN_FILESET_TYPE);
        if (designFileSetInfo != null && !designFileSetInfo.isEmpty()) {
            this.fileSetInfos.put(this.activeDesignFilesSet, designFileSetInfo);
        }
        this.parseBlockSrcFilsesets();
    }

    private void parseBlockSrcFilsesets() throws Exception {
        Object fileSetResult = this.makeXPathQuery("FileSets/FileSet[ @Type = 'BlockSrcs']", this.projectNode, XPathConstants.NODESET);
        if (!(fileSetResult instanceof NodeList)) {
            this.logConsole.print("Found no fileset of type BlockSrcs");
            return;
        }
        NodeList blkFilesets = (NodeList)fileSetResult;
        int i = 0;
        while (i < blkFilesets.getLength()) {
            try {
                Node fileSetNode = blkFilesets.item(i);
                if (fileSetNode instanceof Element) {
                    Element fileSet = (Element)fileSetNode;
                    String fileSetName = fileSet.getAttribute(NAME_ATTR);
                    this.logConsole.print(ANALYZING_BLOCK_FILESET_PREFIX + fileSetName);
                    FileSetInfo fileSetInfo = new FileSetInfo();
                    String relativePathRoot = fileSet.getAttribute(RELATIVE_PATH_ROOT);
                    fileSetInfo.relativePathRoot = !relativePathRoot.isEmpty() ? this.getAbsolutePathFrom(relativePathRoot, "") : "";
                    this.parseFileSetConfig(fileSet, fileSetInfo, relativePathRoot);
                    this.parseFilesInFileSet(fileSet, fileSetInfo, relativePathRoot);
                    this.fileSetInfos.put(fileSetName, fileSetInfo);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError("Exception while parsing block fileset: ", (Throwable)e);
            }
            ++i;
        }
    }

    private FileSetInfo parseFileset(String fileSetName, String fileSetType) throws Exception {
        try {
            FileSetInfo fileSetInfo = new FileSetInfo();
            Object fileSetResult = this.makeXPathQuery("FileSets/FileSet[@Name = '" + fileSetName + "' and @Type = '" + fileSetType + "']", this.projectNode, XPathConstants.NODE);
            if (!(fileSetResult instanceof Element)) {
                this.logConsole.print("Found no fileset with name '" + fileSetName + "' and of type " + fileSetType);
                return fileSetInfo;
            }
            this.logConsole.print(ANALYZING_FILESET_PREFIX + fileSetName);
            Element fileSet = (Element)fileSetResult;
            String relativePathRoot = fileSet.getAttribute(RELATIVE_PATH_ROOT);
            fileSetInfo.relativePathRoot = !relativePathRoot.isEmpty() ? this.getAbsolutePathFrom(relativePathRoot, "") : "";
            this.parseFileSetConfig(fileSet, fileSetInfo, relativePathRoot);
            this.parseFilesInFileSet(fileSet, fileSetInfo, relativePathRoot);
            return fileSetInfo;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Exception while parsing fileset: " + fileSetName, (Throwable)e);
            return null;
        }
    }

    private void parseFilesInFileSet(Element fileSet, FileSetInfo fileSetInfo, String relativePathRoot) throws Exception {
        NodeList fileElements = fileSet.getElementsByTagName(FILE);
        if (fileElements == null) {
            this.logConsole.print(NO_FILE_NODES_MSG);
            return;
        }
        this.logConsole.print(READING_FILES_MSG);
        int i = 0;
        while (i < fileElements.getLength()) {
            block14: {
                try {
                    Element fileInfoElement;
                    String fileType;
                    VivadoFileTypes vivadoFileType;
                    if (this.buildConfigMonitor.isCanceled()) {
                        return;
                    }
                    Element fileElement = (Element)fileElements.item(i);
                    String filePath = fileElement.getAttribute(PATH);
                    if (filePath.isEmpty()) break block14;
                    filePath = FilenameUtils.separatorsToSystem((String)filePath);
                    if ((filePath = this.getAbsolutePathFrom(filePath, relativePathRoot)) == null) break block14;
                    File file = new File(filePath);
                    if (!file.exists()) {
                        DVTLogger.INSTANCE.logError(FILE_DOES_NOT_EXIST_PREFIX + filePath);
                        break block14;
                    }
                    Node fileInfoNode = (Node)this.makeXPathQuery(FILE_INFO, fileElement, XPathConstants.NODE);
                    if (!(fileInfoNode instanceof Element) || (vivadoFileType = VivadoFileTypes.from(fileType = (fileInfoElement = (Element)fileInfoNode).getAttribute(FILE_TYPE), "." + FilenameUtils.getExtension((String)file.getName()))) == null) break block14;
                    if (VivadoFileTypes.VERILOG_HEADER_FILE.equals((Object)vivadoFileType)) {
                        this.logConsole.print(VERILOG_HEADER_FILE_PREFIX + filePath);
                        this.incdirs.add(file.getParent());
                        break block14;
                    }
                    String fileLibrary = this.defaultLibrary;
                    NodeList attributeElements = fileInfoElement.getElementsByTagName(ATTRIBUTE);
                    int j = 0;
                    while (j < attributeElements.getLength()) {
                        Element attributeElement = (Element)attributeElements.item(j);
                        String attributeName = attributeElement.getAttribute(NAME_ATTR);
                        String attributeValue = attributeElement.getAttribute(VALUE_ATTR);
                        if (LIBRARY.equals(attributeName) && !attributeValue.isEmpty()) {
                            fileLibrary = attributeValue;
                        }
                        if (GLOBAL_INCLUDE_ATTR.equals(attributeName) && TRUE_VALUE.equals(attributeValue)) {
                            this.logConsole.print(GLOBAL_INCLUDE_PREFIX + filePath);
                            this.incdirs.add(filePath);
                            break block14;
                        }
                        ++j;
                    }
                    if (VivadoFileTypes.IP_INCLUDE.equals((Object)vivadoFileType)) {
                        this.addXCIIPFile(fileSetInfo, filePath, fileLibrary);
                    } else if (VivadoFileTypes.BLOCK_DESIGN.equals((Object)vivadoFileType)) {
                        this.addBlockDesignFiles(fileSetInfo, filePath);
                    } else {
                        this.addFileToLibrary(fileSetInfo.librariesToFileContainers, filePath, fileLibrary, vivadoFileType.dvtSyntaxName);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError("Exception while parsing file: ", (Throwable)e);
                }
            }
            ++i;
        }
    }

    private void addXCIIPFile(FileSetInfo fileSetInfo, String filePath, String xciFileLibrary) throws Exception {
        Path IPXMLFilePath = Paths.get(filePath.replace(XCI_SUFFIX, XML_SUFFIX), new String[0]);
        File IPXMLFile = IPXMLFilePath.toFile();
        if (!IPXMLFile.exists()) {
            return;
        }
        this.logConsole.print(BLOCKSRC_FILE_PREFIX + filePath);
        XilinxIPParser xilinxIPParser = new XilinxIPParser(IPXMLFile, this.projectRoot.toString(), xciFileLibrary, this.logConsole, this.buildConfigMonitor);
        XilinxIPParser.ParseResult xciParseResult = xilinxIPParser.getParseResult();
        if (this.buildConfigMonitor.isCanceled()) {
            return;
        }
        this.incdirs.addAll(xciParseResult.incdirs);
        for (Map.Entry<String, XilinxConfigParser.XilinxFilesContainer> libToFileContainer : xciParseResult.librariesToFileContainers.entrySet()) {
            String fileLibrary = libToFileContainer.getKey();
            XilinxConfigParser.XilinxFilesContainer filesContainer = libToFileContainer.getValue();
            for (Map.Entry<String, Collection<String>> syntaxToFilePaths : filesContainer.syntaxToFilePaths.entrySet()) {
                String syntaxName = syntaxToFilePaths.getKey();
                Collection<String> filePaths = syntaxToFilePaths.getValue();
                this.addFilesToLibrary(fileSetInfo.librariesToFileContainers, filePaths, fileLibrary, syntaxName);
            }
        }
    }

    private void addBlockDesignFiles(FileSetInfo fileSetInfo, String blockDesignFilePath) throws Exception {
        String rootDirectory = new File(blockDesignFilePath).getParent();
        File bxmlFile = new File(blockDesignFilePath.replace(BD_SUFFIX, BXML_SUFFIX));
        if (!bxmlFile.exists()) {
            return;
        }
        this.logConsole.print(BLOCK_DESIGN_FILE_PREFIX + blockDesignFilePath);
        XilinxBXMLParser xilinxBXMLParser = new XilinxBXMLParser(bxmlFile, rootDirectory, this.logConsole, this.buildConfigMonitor);
        Map<String, String> parseResult = xilinxBXMLParser.getParseResult();
        for (Map.Entry<String, String> includedFileToLib : parseResult.entrySet()) {
            if (this.buildConfigMonitor.isCanceled()) {
                return;
            }
            String filePath = includedFileToLib.getKey();
            String fileLibrary = includedFileToLib.getValue();
            VivadoFileTypes vivadoFileType = VivadoFileTypes.from(null, "." + FilenameUtils.getExtension((String)filePath));
            if (vivadoFileType != null && vivadoFileType != VivadoFileTypes.BLOCK_DESIGN && vivadoFileType != VivadoFileTypes.IP_INCLUDE) {
                this.addFileToLibrary(fileSetInfo.librariesToFileContainers, includedFileToLib.getKey(), includedFileToLib.getValue(), vivadoFileType.dvtSyntaxName);
                continue;
            }
            this.addXCIIPFile(fileSetInfo, filePath, fileLibrary);
        }
    }

    private void parseFileSetConfig(Element fileSet, FileSetInfo fileSetInfo, String relativePathRoot) throws Exception {
        this.parseFileSetConfigOptions(fileSet, relativePathRoot);
        this.parseFileSetConfigDefines(fileSet, fileSetInfo);
        this.parseFileSetConfigGenericsAndParams(fileSet, fileSetInfo);
    }

    private void parseFileSetConfigGenericsAndParams(Element fileSet, FileSetInfo fileSetInfo) throws Exception {
        NodeList genericElements = (NodeList)this.makeXPathQuery("Config/Generic", fileSet, XPathConstants.NODESET);
        if (genericElements == null) {
            return;
        }
        this.logConsole.print(GENERICS_AND_PARAMETERS_MSG);
        int j = 0;
        while (j < genericElements.getLength()) {
            if (this.buildConfigMonitor.isCanceled()) {
                return;
            }
            Element generic = (Element)genericElements.item(j);
            String genericName = generic.getAttribute(NAME_ATTR);
            String genericValue = generic.getAttribute(VALUE_ATTR);
            if (!genericName.isEmpty()) {
                fileSetInfo.genericsAndParameters.put(genericName, genericValue);
            }
            ++j;
        }
    }

    private void parseFileSetConfigDefines(Element fileSet, FileSetInfo fileSetInfo) throws Exception {
        NodeList defineElements = (NodeList)this.makeXPathQuery("Config/Define", fileSet, XPathConstants.NODESET);
        if (defineElements == null) {
            return;
        }
        this.logConsole.print(DEFINES_MSG);
        int j = 0;
        while (j < defineElements.getLength()) {
            if (this.buildConfigMonitor.isCanceled()) {
                return;
            }
            Element define = (Element)defineElements.item(j);
            String defineName = define.getAttribute(NAME_ATTR);
            String defineValue = define.getAttribute(VALUE_ATTR);
            if (!defineName.isEmpty()) {
                fileSetInfo.defines.put(defineName, defineValue);
            }
            ++j;
        }
    }

    private void parseFileSetConfigOptions(Element fileSet, String relativePathRoot) throws Exception {
        NodeList optionElements = (NodeList)this.makeXPathQuery("Config/Option", fileSet, XPathConstants.NODESET);
        if (optionElements == null) {
            return;
        }
        this.logConsole.print(FILESET_CONFIG_OPTIONS_MSG);
        int j = 0;
        while (j < optionElements.getLength()) {
            if (this.buildConfigMonitor.isCanceled()) {
                return;
            }
            Element option = (Element)optionElements.item(j);
            String optionName = option.getAttribute(NAME_ATTR);
            String optionValue = option.getAttribute(VALUE_ATTR);
            if (!optionName.isEmpty() && !optionValue.isEmpty()) {
                if (TOP_MODULE_OPTION.equals(optionName)) {
                    if (!this.globalHeader.contains("-top " + optionValue + NEW_LINE)) {
                        this.globalHeader = "-top " + optionValue + NEW_LINE + this.globalHeader;
                    }
                    this.logConsole.print(TOP_ENTITY_PREFIX + optionValue);
                } else if (DESIGN_SRC_SET_OPTION.equals(optionName)) {
                    this.activeDesignFilesSet = optionValue;
                    this.logConsole.print(ACTIVE_DESIGN_FILESET_PREFIX + optionValue);
                } else if (INCDIR_OPTION.equals(optionName)) {
                    String incdirPath = this.getAbsolutePathFrom(optionValue, relativePathRoot);
                    if (!new File(incdirPath).exists()) {
                        this.logConsole.print(NON_EXISTING_INCDIR_PREFIX + incdirPath);
                    } else {
                        if (incdirPath != null) {
                            this.incdirs.add(incdirPath);
                        }
                        this.logConsole.print(INCDIR_PREFIX + incdirPath);
                    }
                }
            }
            ++j;
        }
    }

    private String getAbsolutePathFrom(String path, String relativePathRoot) throws Exception {
        File fileForPath;
        if (path == null || path.isEmpty()) {
            return null;
        }
        if (this.projectDirectory != null) {
            path = path.replace(PROJECT_DIR_VAR, this.projectDirectory.getCanonicalPath());
        }
        if (this.sourcesDirectory != null) {
            path = path.replace(SOURCE_DIR_VAR, this.sourcesDirectory.getCanonicalPath());
        }
        if (!(fileForPath = new File(path)).isAbsolute()) {
            fileForPath = new File(relativePathRoot, path);
        }
        return fileForPath.getCanonicalPath();
    }

    @Override
    protected AutoConfigResult internalGetAutoconfigResult() throws Exception {
        if (this.buildConfigMonitor.isCanceled()) {
            return new AutoConfigResult(AutoConfigResult.Status.CANCELED);
        }
        AutoConfigResult result = new AutoConfigResult(AutoConfigResult.Status.EMPTY);
        if (!this.globalHeader.isEmpty()) {
            result.append(String.valueOf(this.globalHeader) + NEW_LINE);
        }
        for (Map.Entry<String, FileSetInfo> fileSetInfoEntry : this.fileSetInfos.entrySet()) {
            String fileSetName = fileSetInfoEntry.getKey();
            this.logConsole.print(WRITING_FILES_FOR_FILESET_PREFIX + fileSetName);
            FileSetInfo fileSetInfo = fileSetInfoEntry.getValue();
            if (fileSetInfo == null || fileSetInfo.isEmpty()) continue;
            result.merge(this.getPartialAutoConfigResultFor(this.incdirs, fileSetInfo.defines, fileSetInfo.librariesToFileContainers));
        }
        return result;
    }

    public void setActiveSimulationFileSet(String activeSimulationFileset) {
        this.activeSimFileSet = activeSimulationFileset;
    }

    @Override
    public String[] getProjectNatures() throws Exception {
        String simLanguage = (String)this.makeXPathQuery(SIMULATOR_LANG_OPTION_XPATH, this.xmlDocument, XPathConstants.STRING);
        if (simLanguage == null || simLanguage.isEmpty()) {
            this.hasVHDLNature = true;
            this.hasVlogNature = true;
            return new String[]{"ro.amiq.vlogdt.VlogNature", "ro.amiq.vhdldt.VhdlNature"};
        }
        if (SIMULATOR_LANG_VHDL.equals(simLanguage)) {
            this.hasVHDLNature = true;
            return new String[]{"ro.amiq.vhdldt.VhdlNature"};
        }
        if (SIMULATOR_LANG_VLOG.equals(simLanguage)) {
            this.hasVlogNature = true;
            return new String[]{"ro.amiq.vlogdt.VlogNature"};
        }
        return null;
    }

    @Override
    protected String getCompatModeForSyntax(String syntaxName) {
        return VivadoFileTypes.getCompatModeForSyntax(syntaxName);
    }

    protected static class FileSetInfo {
        protected String relativePathRoot;
        protected Map<String, XilinxConfigParser.XilinxFilesContainer> librariesToFileContainers = new LinkedHashMap<String, XilinxConfigParser.XilinxFilesContainer>();
        protected Map<String, String> defines = new LinkedHashMap<String, String>();
        protected Map<String, String> genericsAndParameters = new LinkedHashMap<String, String>();

        public boolean isEmpty() {
            return this.librariesToFileContainers.isEmpty();
        }
    }

    static enum VivadoFileTypes {
        VHDL_FILE("VHDL", "vhdlSource", "VHDL_2002", "vcom", ".vhd", ".vhdl"),
        VHDL_2008_FILE("VHDL2008", "vhdlSource-2008", "VHDL_2008", "vcom", ".vhd", ".vhdl"),
        VERILOG_FILE("Verilog", "verilogSource", "Verilog_2005", "vlog", ".v"),
        SYSTEM_VERILOG_FILE("SVerilog", "systemVerilogSource", "SystemVerilog", "vlog", ".sv"),
        VERILOG_HEADER_FILE("VHeader", "verilogSource", "Verilog_2005", "vlog", ".vh", ".svh"),
        BLOCK_DESIGN("BD", "", "", "", ".bd"),
        IP_INCLUDE("XCI", "xml", "", "", ".xci");

        private String typeName;
        private String typeNameInIPFile;
        private Set<String> extensions;
        private String questaCompatMode;
        public String dvtSyntaxName;

        private VivadoFileTypes(String typeName, String typeNameInIPFile, String dvtSyntaxName, String questaCompatMode, String ... extensions) {
            this.typeName = typeName;
            this.typeNameInIPFile = typeNameInIPFile;
            this.dvtSyntaxName = dvtSyntaxName;
            this.questaCompatMode = questaCompatMode;
            this.extensions = new HashSet<String>(Arrays.asList(extensions));
        }

        private static VivadoFileTypes from(String typeName, String extension) {
            if (typeName != null && !typeName.isEmpty()) {
                return VivadoFileTypes.getFileTypeFromTypeName(typeName);
            }
            if (extension != null) {
                return VivadoFileTypes.getFileTypeFromExtension(extension);
            }
            return null;
        }

        private static VivadoFileTypes getFileTypeFromExtension(String extension) {
            VivadoFileTypes[] vivadoFileTypesArray = VivadoFileTypes.values();
            int n = vivadoFileTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                VivadoFileTypes fileType = vivadoFileTypesArray[n2];
                if (fileType.extensions.contains(extension)) {
                    return fileType;
                }
                ++n2;
            }
            return null;
        }

        private static VivadoFileTypes getFileTypeFromTypeName(String typeName) {
            VivadoFileTypes[] vivadoFileTypesArray = VivadoFileTypes.values();
            int n = vivadoFileTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                VivadoFileTypes fileType = vivadoFileTypesArray[n2];
                if (fileType.typeName.equals(typeName)) {
                    return fileType;
                }
                ++n2;
            }
            return null;
        }

        public static VivadoFileTypes getFileTypeFromIPFileType(String typeNameInIPFile) {
            if (typeNameInIPFile == null) {
                return null;
            }
            VivadoFileTypes[] vivadoFileTypesArray = VivadoFileTypes.values();
            int n = vivadoFileTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                VivadoFileTypes fileType = vivadoFileTypesArray[n2];
                if (fileType.typeNameInIPFile.equals(typeNameInIPFile)) {
                    return fileType;
                }
                ++n2;
            }
            return null;
        }

        public static String getCompatModeForSyntax(String syntaxName) {
            if (syntaxName == null || syntaxName.isEmpty()) {
                return " ";
            }
            VivadoFileTypes[] vivadoFileTypesArray = VivadoFileTypes.values();
            int n = vivadoFileTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                VivadoFileTypes fileType = vivadoFileTypesArray[n2];
                if (fileType.dvtSyntaxName.equals(syntaxName)) {
                    return "+questa." + fileType.questaCompatMode + " ";
                }
                ++n2;
            }
            return " ";
        }
    }
}

