/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import org.eclipse.core.runtime.IProgressMonitor;

public class CancellableCharSequence
implements CharSequence {
    private CharSequence wrapped;
    private IProgressMonitor progressMonitor;

    public CancellableCharSequence(CharSequence wrapped, IProgressMonitor progressMonitor) {
        this.wrapped = wrapped;
        this.progressMonitor = progressMonitor;
    }

    @Override
    public int length() {
        if (this.progressMonitor == null || this.progressMonitor.isCanceled()) {
            throw new CharSequenceCancelledException();
        }
        return this.wrapped == null ? -1 : this.wrapped.length();
    }

    @Override
    public char charAt(int index) {
        if (this.progressMonitor == null || this.progressMonitor.isCanceled()) {
            throw new CharSequenceCancelledException();
        }
        return this.wrapped == null ? (char)'\u0000' : this.wrapped.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.progressMonitor == null || this.progressMonitor.isCanceled()) {
            throw new CharSequenceCancelledException();
        }
        return this.wrapped == null ? null : this.wrapped.subSequence(start, end);
    }

    static class CharSequenceCancelledException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CharSequenceCancelledException() {
        }
    }
}

