/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorResult;

public enum IRunLogSimulatorParser implements LogSimulatorParser
{
    INSTANCE;

    private static final String TIMEZONE_IRUN = " ([A-Z]{3,4})";
    private static final List<Pattern> IRUN_PATTERNS;
    private static final Map<Pattern, String> IRUN_REPLACE_MAP;

    static {
        IRUN_PATTERNS = Collections.unmodifiableList(Arrays.asList(Pattern.compile("( ([A-Z]{3,4})\\s+irun)(?<args>.*?)(\\s+(User|The))", 32)));
        IRUN_REPLACE_MAP = ImmutableMap.of((Object)Pattern.compile("\t\t+.*[\n\r]+"), (Object)"");
    }

    @Override
    public LogSimulatorResult parseLogFile(LogSimulatorResult result, Path path, BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor) {
        this.parseLogFileSearchingPattern(result, (IPath)path, monitor, IRUN_PATTERNS, simLogParameters.maxSizeBuffer, simLogParameters.fullParsing);
        if (monitor.isCanceled()) {
            return LogSimulatorResult.CANCELED;
        }
        return result;
    }

    @Override
    public List<Pattern> getExtractionPatterns() {
        return IRUN_PATTERNS;
    }

    @Override
    public Map<Pattern, String> getReplacementPatterns() {
        return IRUN_REPLACE_MAP;
    }
}

