/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.logsimulator.CancellableCharSequence;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorResult;
import ro.amiq.dvt.buildconfig.logsimulator.SimulatorDetection;
import ro.amiq.dvt.buildconfig.logsimulator.SimulatorType;
import ro.amiq.dvt.buildconfig.logsimulator.TimeoutProgressMonitor;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.startup.core.DVTLogger;

public final class LogSimulatorManager {
    private static final String ERROR_MSG_SIMULATOR_NOT_DETECTED = "# The simulator type could not be detected automatically! Please explicit specify it.";
    private static final String NEWLINE = System.lineSeparator();
    private static final String PREFIX_USER_PATTERN = "[USRDEF] ";
    private static final String PREFIX_PREDEFINED_PATTERN = "[PREDEF] ";
    public static final String CONSOLE_PREFIX = "SimLog-Config - ";

    private LogSimulatorManager() {
    }

    public static LogSimulatorResult getResult(IProject project, Invocation invocation, BuildConfigParser.SimLogConfigParameters simLogParameters) {
        boolean hasUserSpecifiedPatterns;
        DVTBuildConsole buildConsole;
        LogSimulatorResult result;
        TimeoutProgressMonitor monitor = new TimeoutProgressMonitor(BuildConfigManager.getProgressMonitor(project), simLogParameters.timeoutSeconds);
        SimulatorType simulator = LogSimulatorManager.findSimulatorType(invocation, simLogParameters, (IProgressMonitor)monitor, result = new LogSimulatorResult(), buildConsole = DVTBuildConsoleRegistry.getConsole(project), hasUserSpecifiedPatterns = simLogParameters.userSpecifiedPatterns != null);
        if (simulator == null) {
            return result;
        }
        try {
            for (Path path : simLogParameters.simLogFiles) {
                LogSimulatorManager.extractDataFromLogFile(path, simLogParameters, (IProgressMonitor)monitor, result, simulator, buildConsole, hasUserSpecifiedPatterns);
            }
            LogSimulatorManager.processDataFromLogFile(simLogParameters, (IProgressMonitor)monitor, result, simulator, buildConsole);
            LogSimulatorManager.createInvocations(project, invocation, simLogParameters, result, simulator);
        }
        catch (CancellableCharSequence.CharSequenceCancelledException charSequenceCancelledException) {
            if (monitor.isTimeout()) {
                result.setStatus(LogSimulatorResult.Status.TIMEOUT);
            }
            result.setStatus(LogSimulatorResult.Status.CANCELED);
        }
        return result;
    }

    private static SimulatorType findSimulatorType(Invocation invocation, BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor, LogSimulatorResult result, DVTBuildConsole buildConsole, boolean existsUserSpecifiedPatterns) {
        SimulatorType simulator = null;
        long startTime = 0L;
        long endTime = 0L;
        buildConsole.print("SimLog-Config - Detecting simulator type...");
        startTime = System.currentTimeMillis();
        if (existsUserSpecifiedPatterns) {
            simulator = SimulatorDetection.INSTANCE.getUserSpecifiedSimulatorType(invocation);
        } else {
            simulator = SimulatorDetection.INSTANCE.getSimulator(invocation, simLogParameters, monitor);
            if (monitor.isCanceled()) {
                result.setStatus(LogSimulatorResult.Status.CANCELED);
                return null;
            }
        }
        if (simulator == null || result.hasErrors()) {
            result.addError(ERROR_MSG_SIMULATOR_NOT_DETECTED);
            result.resolveStatus();
            return null;
        }
        endTime = System.currentTimeMillis();
        buildConsole.print("SimLog-Config - Done detecting, simulator is " + simulator.name() + " [" + (endTime - startTime) + "ms]");
        return simulator;
    }

    private static void createInvocations(IProject project, Invocation invocation, BuildConfigParser.SimLogConfigParameters simLogParameters, LogSimulatorResult result, SimulatorType simulator) {
        if (result.getStatus() == LogSimulatorResult.Status.CANCELED) {
            return;
        }
        result.resolveStatus();
        int i = 0;
        while (i < result.getNoInvocations()) {
            IPath path = result.getFile(i);
            String invocationHeader = LogSimulatorManager.createInvocationHeader(path, simulator, project, invocation, simLogParameters);
            result.appendHeader(i, invocationHeader);
            ++i;
        }
    }

    private static void extractDataFromLogFile(Path path, BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor, LogSimulatorResult result, SimulatorType simulator, DVTBuildConsole buildConsole, boolean withUserSpecifiedPatterns) {
        long startTime = 0L;
        long endTime = 0L;
        buildConsole.print("SimLog-Config - Scanning logfile:\n\t" + path);
        startTime = System.currentTimeMillis();
        LogSimulatorParser parser = simulator.getParser();
        result = withUserSpecifiedPatterns ? parser.parseLogFileWithUserSpecifiedPattern(result, path, simLogParameters, monitor) : parser.parseLogFile(result, path, simLogParameters, monitor);
        endTime = System.currentTimeMillis();
        buildConsole.print("SimLog-Config - Using the following patterns:");
        if (withUserSpecifiedPatterns) {
            buildConsole.print(LogSimulatorManager.createPatternsString(PREFIX_USER_PATTERN, simLogParameters.userSpecifiedPatterns));
        } else {
            buildConsole.print(LogSimulatorManager.createPatternsString(PREFIX_PREDEFINED_PATTERN, simulator.getParser().getExtractionPatterns()));
        }
        buildConsole.print("SimLog-Config - Done scanning [" + (endTime - startTime) + "ms]");
    }

    private static void processDataFromLogFile(BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor, LogSimulatorResult result, SimulatorType simulator, DVTBuildConsole buildConsole) {
        LinkedHashMap<Pattern, String> postProcessingReplaceMap = new LinkedHashMap<Pattern, String>();
        Map<Pattern, String> userReplacementPatterns = simLogParameters.replaceMap;
        if (userReplacementPatterns == null || userReplacementPatterns.isEmpty()) {
            postProcessingReplaceMap.putAll(simulator.getParser().getReplacementPatterns());
        } else {
            postProcessingReplaceMap.putAll(userReplacementPatterns);
        }
        long startTime = 0L;
        long endTime = 0L;
        buildConsole.print("SimLog-Config - Processing result using ... :");
        for (Map.Entry entry : postProcessingReplaceMap.entrySet()) {
            buildConsole.print("\tReplace '" + StringEscapeUtils.escapeJava((String)((Pattern)entry.getKey()).toString()) + "' with '" + (String)entry.getValue() + "'");
        }
        startTime = System.currentTimeMillis();
        int i = 0;
        while (i < result.getNoInvocations()) {
            for (Map.Entry entry : postProcessingReplaceMap.entrySet()) {
                if (monitor.isCanceled()) {
                    result.setStatus(LogSimulatorResult.Status.CANCELED);
                    return;
                }
                CancellableCharSequence content = new CancellableCharSequence(result.getContent(i), monitor);
                StringBuffer newContent = new StringBuffer();
                Matcher matcher = ((Pattern)entry.getKey()).matcher(content);
                while (matcher.find()) {
                    String group = matcher.group();
                    if (group == null || group.isEmpty()) continue;
                    matcher.appendReplacement(newContent, (String)entry.getValue());
                }
                matcher.appendTail(newContent);
                result.setContent(i, newContent);
            }
            ++i;
        }
        endTime = System.currentTimeMillis();
        buildConsole.print("SimLog-Config - Done processing [" + (endTime - startTime) + "ms]");
    }

    private static String createPatternsString(String prefix, List<Pattern> patterns) {
        if (prefix == null || patterns == null) {
            return "";
        }
        return "\t" + patterns.stream().map(x -> String.valueOf(prefix) + x.toString()).collect(Collectors.joining(String.valueOf(NEWLINE) + "\t"));
    }

    private static String createInvocationHeader(IPath path, SimulatorType simulator, IProject project, Invocation invocation, BuildConfigParser.SimLogConfigParameters simLogParameters) {
        String compilationRoot;
        StringBuilder invocationDirectives = new StringBuilder();
        String compatMode = invocation.getState().fToolCompat == IBuildConfigParserConstants.ToolCompat.DVT ? simulator.getToolCompat().toString() : invocation.getState().fToolCompat.toString();
        invocationDirectives.append("+dvt_init+").append(compatMode).append(NEWLINE);
        boolean addCompilationRootDirective = LogSimulatorManager.isCompilationRootEqualToProjectPath(project, invocation);
        if (addCompilationRootDirective && (compilationRoot = LogSimulatorManager.getCompilationRootForInitFromSimLog(project.getLocation(), path)) != null) {
            invocationDirectives.append("+dvt_compilation_root+").append(compilationRoot).append(NEWLINE);
        }
        invocationDirectives.append(simLogParameters.reuseText).append(NEWLINE);
        return invocationDirectives.toString();
    }

    private static boolean isCompilationRootEqualToProjectPath(IProject project, Invocation invocation) {
        boolean result = false;
        try {
            result = Files.isSameFile(project.getLocation().toFile().toPath(), Paths.get(invocation.getState().fCompilationRoot, new String[0]));
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private static String getCompilationRootForInitFromSimLog(IPath projectPath, IPath logPath) {
        if (logPath == null) {
            return projectPath.toOSString();
        }
        return logPath.makeRelativeTo(projectPath).toFile().getParent();
    }
}

