/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.logsimulator.CancellableCharSequence;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorResult;
import ro.amiq.dvt.startup.core.DVTLogger;

public interface LogSimulatorParser {
    public static final String ARGS_GROUP_NAME = "args";
    public static final int CHUNK_BUFFER_SIZE = 250000;

    public LogSimulatorResult parseLogFile(LogSimulatorResult var1, Path var2, BuildConfigParser.SimLogConfigParameters var3, IProgressMonitor var4);

    public List<Pattern> getExtractionPatterns();

    public Map<Pattern, String> getReplacementPatterns();

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public void parseLogFileSearchingPattern(LogSimulatorResult result, IPath file, IProgressMonitor monitor, List<Pattern> patterns, long bufferMaxSize, boolean fullParsing) {
        logFile = file.toOSString();
        try {
            var9_8 = null;
            var10_12 = null;
            try {
                reader = new BufferedReader(new FileReader(logFile));
                try {
                    cbuf = new char[250000];
                    data = new StringBuilder();
                    while (true) {
                        data.append(cbuf);
                        if (monitor.isCanceled()) {
                            return;
                        }
                        if (!fullParsing && (long)data.length() >= bufferMaxSize) {
                            result.addError("# The parsing log file process stopped after reading " + data.length() + "bytes, try to increase the max size of buffer using +dvt_simlog_max_size_buffer+<size in MB>.");
                            return;
                        }
                        index = this.searchPatternInBuffer(file, patterns, data, result, fullParsing, monitor);
                        if (index == -1) {
                            return;
                        }
                        if (index == 0) {
                        }
                        if (data.length() < index) {
                            data.setLength(0);
                        }
                        data.delete(0, index);
                        break;
                    }
                }
                finally {
                    if (reader.read(cbuf) != -1) ** continue;
                    return;
                }
            }
            catch (Throwable var10_13) {
                if (var9_8 == null) {
                    var9_8 = var10_13;
                    throw var9_8;
                }
                if (var9_8 == var10_13) throw var9_8;
                var9_8.addSuppressed(var10_13);
                throw var9_8;
            }
        }
        catch (FileNotFoundException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    default public int searchPatternInBuffer(IPath file, List<Pattern> patterns, StringBuilder data, LogSimulatorResult result, boolean fullParsing, IProgressMonitor monitor) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(new CancellableCharSequence(data, monitor));
            int endIndexMatcher = 0;
            while (matcher.find()) {
                result.createInvocation(file);
                result.append(matcher.group(ARGS_GROUP_NAME));
                endIndexMatcher = matcher.end();
                if (fullParsing) continue;
                return -1;
            }
            if (endIndexMatcher == 0) continue;
            return endIndexMatcher;
        }
        return 0;
    }

    default public LogSimulatorResult parseLogFileWithUserSpecifiedPattern(LogSimulatorResult result, Path path, BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor) {
        this.parseLogFileSearchingPattern(result, (IPath)path, monitor, simLogParameters.userSpecifiedPatterns, simLogParameters.maxSizeBuffer, simLogParameters.fullParsing);
        if (monitor.isCanceled()) {
            return LogSimulatorResult.CANCELED;
        }
        return result;
    }
}

