/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class LogSimulatorResult {
    private static final String NEWLINE = System.lineSeparator();
    public static final LogSimulatorResult CANCELED = new LogSimulatorResult(Status.CANCELED);
    public static final LogSimulatorResult EMPTY = new LogSimulatorResult(Status.EMPTY);
    private Status fStatus;
    private List<StringBuffer> fContentInvocations;
    private List<IPath> fFileInvocations;
    private List<String> fErrors;
    private int fIndexCurrentInvocation;

    private LogSimulatorResult(Status status) {
        this.fStatus = status;
    }

    public LogSimulatorResult() {
        this.fStatus = Status.EMPTY;
        this.fContentInvocations = new ArrayList<StringBuffer>();
        this.fFileInvocations = new ArrayList<IPath>();
        this.fIndexCurrentInvocation = -1;
        this.fErrors = new ArrayList<String>();
    }

    public Status getStatus() {
        return this.fStatus;
    }

    public void setStatus(Status fStatus) {
        this.fStatus = fStatus;
    }

    public void appendHeader(int indexInvocation, String header) {
        if (indexInvocation < 0 || indexInvocation >= this.fContentInvocations.size() || header == null) {
            return;
        }
        this.fContentInvocations.get(indexInvocation).insert(0, header);
    }

    public void appendHeader(String header) {
        this.appendHeader(this.fIndexCurrentInvocation, header);
    }

    public void append(int indexInvocation, String data) {
        if (indexInvocation < 0 || indexInvocation >= this.fContentInvocations.size() || data == null) {
            return;
        }
        this.fContentInvocations.get(indexInvocation).append(data).append(NEWLINE);
    }

    public void append(String data) {
        this.append(this.fIndexCurrentInvocation, data);
    }

    public void addError(String error) {
        if (error == null) {
            return;
        }
        this.fErrors.add(error);
    }

    public StringBuffer getContent(int indexInvocation) {
        return this.fContentInvocations.get(indexInvocation);
    }

    public IPath getFile(int indexInvocation) {
        if (indexInvocation < 0 || indexInvocation >= this.fFileInvocations.size()) {
            return null;
        }
        return this.fFileInvocations.get(indexInvocation);
    }

    public void setContent(int i, StringBuffer newContent) {
        this.fContentInvocations.set(i, newContent);
    }

    public void resolveStatus() {
        if (this.fStatus == Status.CANCELED) {
            return;
        }
        if (this.hasErrors()) {
            this.fStatus = Status.ERROR;
            return;
        }
        boolean allContentIsEmpty = true;
        for (StringBuffer content : this.fContentInvocations) {
            if (content.length() == 0) continue;
            allContentIsEmpty = false;
            break;
        }
        if (allContentIsEmpty) {
            this.fStatus = Status.EMPTY;
            return;
        }
        this.fStatus = Status.OK;
    }

    public List<String> getErrors() {
        return this.fErrors;
    }

    public boolean hasErrors() {
        return !this.fErrors.isEmpty();
    }

    public void createInvocation(IPath file) {
        ++this.fIndexCurrentInvocation;
        this.fFileInvocations.add(file);
        this.fContentInvocations.add(new StringBuffer());
    }

    public int getNoInvocations() {
        return this.fIndexCurrentInvocation + 1;
    }

    public String getEntireContent() {
        StringBuilder allContent = new StringBuilder();
        this.fContentInvocations.forEach(x -> {
            StringBuilder stringBuilder2 = allContent.append((StringBuffer)x).append(NEWLINE);
        });
        return allContent.toString();
    }

    public static enum Status {
        EMPTY,
        OK,
        ERROR,
        CANCELED,
        TIMEOUT;

    }
}

