/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorResult;

public enum QuestaLogSimulatorParser implements LogSimulatorParser
{
    INSTANCE;

    private static final List<Pattern> QUESTA_PATTERNS;
    private static final Map<Pattern, String> QUESTA_REPLACE_MAP;

    static {
        QUESTA_PATTERNS = Collections.unmodifiableList(Arrays.asList(Pattern.compile("vcom(?<args>.+?)\n", 32), Pattern.compile("vlog(?<args>.+?)\n", 32)));
        QUESTA_REPLACE_MAP = ImmutableMap.of();
    }

    @Override
    public LogSimulatorResult parseLogFile(LogSimulatorResult result, Path path, BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor) {
        this.parseLogFileSearchingPattern(result, (IPath)path, monitor, QUESTA_PATTERNS, simLogParameters.maxSizeBuffer, simLogParameters.fullParsing);
        if (monitor.isCanceled()) {
            return LogSimulatorResult.CANCELED;
        }
        return result;
    }

    @Override
    public List<Pattern> getExtractionPatterns() {
        return QUESTA_PATTERNS;
    }

    @Override
    public Map<Pattern, String> getReplacementPatterns() {
        return QUESTA_REPLACE_MAP;
    }
}

