/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.logsimulator.SimulatorType;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum SimulatorDetection {
    INSTANCE;


    public SimulatorType getDefaultSimulator() {
        return SimulatorType.VCS;
    }

    public SimulatorType getSimulator(Invocation invocation, BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor) {
        SimulatorType simulator = null;
        simulator = this.getUserSpecifiedSimulatorType(invocation);
        if (simulator != null) {
            return simulator;
        }
        simulator = this.detectSimulatorUsed(simLogParameters, monitor);
        if (simulator != null) {
            return simulator;
        }
        return null;
    }

    public SimulatorType getUserSpecifiedSimulatorType(Invocation invocation) {
        IBuildConfigParserConstants.ToolCompat toolCompat = invocation.getState().fToolCompat;
        if (toolCompat == IBuildConfigParserConstants.ToolCompat.IUS_IRUN) {
            return SimulatorType.IRUN;
        }
        if (toolCompat == IBuildConfigParserConstants.ToolCompat.XCELIUM_XRUN) {
            return SimulatorType.XRUN;
        }
        if (toolCompat == IBuildConfigParserConstants.ToolCompat.VCS_VHDLAN || toolCompat == IBuildConfigParserConstants.ToolCompat.VCS_VLOGAN) {
            return SimulatorType.VCS;
        }
        if (toolCompat == IBuildConfigParserConstants.ToolCompat.QUESTA_VCOM || toolCompat == IBuildConfigParserConstants.ToolCompat.QUESTA_VLOG) {
            return SimulatorType.QUESTA;
        }
        return null;
    }

    private SimulatorType detectSimulatorUsed(BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor) {
        Path path = simLogParameters.simLogFiles.get(0);
        if (path == null) {
            return null;
        }
        String logFile = path.toOSString();
        SimulatorType[] simulatorTypeArray = SimulatorType.values();
        int n = simulatorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimulatorType simulator = simulatorTypeArray[n2];
            if (this.readFile(logFile, monitor, simulator.getDetectionPattern(), simLogParameters.maxSizeBuffer, simLogParameters.fullParsing)) {
                return simulator;
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readFile(String logFile, IProgressMonitor monitor, Pattern pattern, long bufferMaxSize, boolean fullParsing) {
        long currentBufferSize = 0L;
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
                String line = null;
                line = reader.readLine();
                if (line != null) {
                }
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }
}

