/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import java.util.EnumSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.logsimulator.IRunLogSimulatorParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorParser;
import ro.amiq.dvt.buildconfig.logsimulator.QuestaLogSimulatorParser;
import ro.amiq.dvt.buildconfig.logsimulator.VCSLogSimulatorParser;
import ro.amiq.dvt.buildconfig.logsimulator.XRunLogSimulatorParser;

public enum SimulatorType {
    VCS(VCSLogSimulatorParser.INSTANCE, Constants.VCS_DETECT_PATTERN, IBuildConfigParserConstants.VCS_TOOLS),
    IRUN(IRunLogSimulatorParser.INSTANCE, Constants.IRUN_DETECT_PATTERN, EnumSet.of(IBuildConfigParserConstants.ToolCompat.IUS_IRUN)),
    XRUN(XRunLogSimulatorParser.INSTANCE, Constants.XRUN_DETECT_PATTERN, EnumSet.of(IBuildConfigParserConstants.ToolCompat.XCELIUM_XRUN)),
    QUESTA(QuestaLogSimulatorParser.INSTANCE, Constants.QUESTA_DETECT_PATTERN, IBuildConfigParserConstants.QUESTA_TOOLS);

    private final LogSimulatorParser parser;
    private final Pattern detectionPattern;
    private final EnumSet<IBuildConfigParserConstants.ToolCompat> toolCompats;

    private SimulatorType(LogSimulatorParser parser, Pattern detectionPattern, EnumSet<IBuildConfigParserConstants.ToolCompat> toolCompats) {
        this.parser = parser;
        this.detectionPattern = detectionPattern;
        this.toolCompats = toolCompats;
    }

    public LogSimulatorParser getParser() {
        return this.parser;
    }

    public Pattern getDetectionPattern() {
        return this.detectionPattern;
    }

    public IBuildConfigParserConstants.ToolCompat getToolCompat() {
        return (IBuildConfigParserConstants.ToolCompat)((Object)this.toolCompats.iterator().next());
    }

    public static SimulatorType from(String string) {
        if (string == null || (string = string.trim()).isEmpty()) {
            return null;
        }
        SimulatorType[] simulatorTypeArray = SimulatorType.values();
        int n = simulatorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimulatorType type = simulatorTypeArray[n2];
            if (type.name().equalsIgnoreCase(string)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    private static class Constants {
        public static final Pattern VCS_DETECT_PATTERN = Pattern.compile("\\bvcs\\b", 2);
        public static final Pattern XRUN_DETECT_PATTERN = Pattern.compile("\\bxrun\\b", 2);
        public static final Pattern IRUN_DETECT_PATTERN = Pattern.compile("\\birun\\b", 2);
        public static final Pattern QUESTA_DETECT_PATTERN = Pattern.compile("\\b(vcom|vlog)\\b", 2);

        private Constants() {
        }
    }
}

