/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorResult;

public enum VCSLogSimulatorParser implements LogSimulatorParser
{
    INSTANCE;

    private static final List<Pattern> VCS_PATTERNS;
    private static final Map<Pattern, String> VCS_REPLACE_MAP;

    static {
        VCS_PATTERNS = Collections.unmodifiableList(Arrays.asList(Pattern.compile("(vcs|vlogan)(?<args>.*?)(?=(\\*\\*\\*|Chronologic VCS))", 32)));
        VCS_REPLACE_MAP = ImmutableMap.of();
    }

    @Override
    public LogSimulatorResult parseLogFile(LogSimulatorResult result, Path path, BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor) {
        this.parseLogFileSearchingPattern(result, (IPath)path, monitor, VCS_PATTERNS, simLogParameters.maxSizeBuffer, simLogParameters.fullParsing);
        if (monitor.isCanceled()) {
            return LogSimulatorResult.CANCELED;
        }
        return result;
    }

    @Override
    public List<Pattern> getExtractionPatterns() {
        return VCS_PATTERNS;
    }

    @Override
    public Map<Pattern, String> getReplacementPatterns() {
        return VCS_REPLACE_MAP;
    }
}

