/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.logsimulator;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorParser;
import ro.amiq.dvt.buildconfig.logsimulator.LogSimulatorResult;

public enum XRunLogSimulatorParser implements LogSimulatorParser
{
    INSTANCE;

    private static final String TIMEZONE_XRUN = " ([A-Z]{3,4})";
    private static final String COMPANY_TEXT = "Design Systems, Inc.";
    private static final List<Pattern> XRUN_PATTERNS;
    private static final Map<Pattern, String> XRUN_REPLACE_MAP;

    static {
        XRUN_PATTERNS = Collections.unmodifiableList(Arrays.asList(Pattern.compile("(( ([A-Z]{3,4})|Design Systems, Inc.)\\s+xrun\\s)(?<args>.*?)(\\s+(xrun:|User|The))", 32)));
        XRUN_REPLACE_MAP = ImmutableMap.of((Object)Pattern.compile("\t\t+.*[\n\r]+"), (Object)"", (Object)Pattern.compile("(-define\\s*\\w+=)\"(.*?)\""), (Object)"$1\\\\\"$2\\\\\"", (Object)Pattern.compile("(\\+define\\+\\w+=)\"(.*?)\""), (Object)"$1\\\\\"$2\\\\\"");
    }

    @Override
    public LogSimulatorResult parseLogFile(LogSimulatorResult result, Path path, BuildConfigParser.SimLogConfigParameters simLogParameters, IProgressMonitor monitor) {
        this.parseLogFileSearchingPattern(result, (IPath)path, monitor, XRUN_PATTERNS, simLogParameters.maxSizeBuffer, simLogParameters.fullParsing);
        if (monitor.isCanceled()) {
            return LogSimulatorResult.CANCELED;
        }
        return result;
    }

    @Override
    public List<Pattern> getExtractionPatterns() {
        return XRUN_PATTERNS;
    }

    @Override
    public Map<Pattern, String> getReplacementPatterns() {
        return XRUN_REPLACE_MAP;
    }
}

