/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig.splitinvocation;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import ro.amiq.dvt.buildconfig.ActiveBuildConfig;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationConfig;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;

public class SplitInvocationUtils {
    private static final String FAILED_TO_SERIALIZE_BC_ERROR = "Error: Failed to serialize active build config.";
    public static final String GLUE_DIRECTORY_NAME = "split_config";
    private static final String SERIALIZED_BC_SUFFIX = ".before_split";
    public static final String SPLIT_FILE_SUFFIX = ".build.split";
    public static final String MD5_LIBRARIES = "md5_libraries";
    public static final String LIBFILE = "LIBFILE";
    public static final String LIBDIR = "LIBDIR";
    public static final List<String> globalDirectives = new ArrayList<String>();

    static {
        globalDirectives.addAll(IBuildConfigParserConstants.Directive.GLOBAL_DIRECTIVES);
        globalDirectives.add("-CFLAGS");
        globalDirectives.add("-ccflags");
        globalDirectives.add("-ccargs");
        globalDirectives.add("-I");
        globalDirectives.add("-D");
        globalDirectives.add("-L");
        globalDirectives.add("-l ");
        globalDirectives.add("-imacros");
        globalDirectives.add("-include");
        globalDirectives.add("+nctop");
        globalDirectives.add("+xmtop");
        globalDirectives.add("-sv_lib");
        globalDirectives.add("-sv_liblist");
        globalDirectives.add("-sv_root");
        globalDirectives.add("-top");
        globalDirectives.add("+UVM_TESTNAME");
        globalDirectives.add("+OVM_TESTNAME");
        globalDirectives.add("+UVM_TIMEOUT");
        globalDirectives.add("+UVM_MAX_QUIT_COUNT");
    }

    private static boolean splitFileExists(IProject project) {
        String projectLocation = project.getLocation().makeAbsolute().toOSString();
        String splitFileName = String.valueOf(BuildConfigManagerCommon.getActiveBuildConfig(project).getName()) + SPLIT_FILE_SUFFIX;
        return Paths.get(projectLocation, ".dvt", splitFileName).toFile().exists();
    }

    private static boolean serializedBCExists(Path buildConfigsDefaultDirectoryPath, String serializedBCName) {
        if (buildConfigsDefaultDirectoryPath == null || serializedBCName == null) {
            return false;
        }
        IPath serializedBCPath = buildConfigsDefaultDirectoryPath.append(serializedBCName);
        return serializedBCPath.toFile().exists();
    }

    public static boolean isSplitConfigUsed(IProject project) {
        List<BuildConfigProperty> cmdFileCalls = BuildConfigManager.getIncludeProperties(project);
        for (BuildConfigProperty cmdFileCall : cmdFileCalls) {
            String cmdVal = cmdFileCall.getValue();
            if (cmdVal == null || !cmdVal.endsWith(String.valueOf(BuildConfigManagerCommon.getActiveBuildConfig(project).getName()) + SPLIT_FILE_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    public static boolean buildConfigsCoincide(IProject project) {
        ActiveBuildConfig activeBuildConfig = BuildConfigManagerCommon.getActiveBuildConfig(project);
        ActiveBuildConfig deserializedBuildConfig = null;
        Path buildConfigsDefaultDirectoryPath = (Path)project.getLocation().append(".dvt").append(GLUE_DIRECTORY_NAME);
        String serializedBCName = String.valueOf(activeBuildConfig.getName()) + SERIALIZED_BC_SUFFIX;
        if (!SplitInvocationUtils.splitFileExists(project) || !SplitInvocationUtils.serializedBCExists(buildConfigsDefaultDirectoryPath, serializedBCName)) {
            return false;
        }
        try {
            deserializedBuildConfig = BuildConfigManager.loadBuildConfig(buildConfigsDefaultDirectoryPath, serializedBCName, project);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (deserializedBuildConfig == null) {
            return false;
        }
        List<Invocation> activeBCInvocations = activeBuildConfig.getCachedInfo();
        List<Invocation> deserializedBCInvocations = deserializedBuildConfig.getCachedInfo();
        if (activeBCInvocations.size() != deserializedBCInvocations.size()) {
            return false;
        }
        int i = 0;
        while (i < activeBCInvocations.size()) {
            Invocation currentActiveBCInvocation = activeBCInvocations.get(i);
            Invocation currentDeserializedBCInvocation = deserializedBCInvocations.get(i);
            if (!currentActiveBCInvocation.getState().equals(currentDeserializedBCInvocation.getState())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean shouldGenerateSplitBuildConfiguration(IProject project) {
        SplitInvocationConfig splitInvocationConfig = BuildConfigManager.getAutoSplitInvocation(project);
        return splitInvocationConfig != null && !SplitInvocationUtils.isSplitConfigUsed(project);
    }

    public static boolean shouldSwitchToSplitBuildConfiguration(IProject project) {
        SplitInvocationConfig splitInvocationConfig = BuildConfigManager.getAutoSplitInvocation(project);
        if (splitInvocationConfig == null) {
            return false;
        }
        String projectLocation = project.getLocation().makeAbsolute().toOSString();
        java.nio.file.Path glueDirPath = Paths.get(projectLocation, ".dvt", GLUE_DIRECTORY_NAME);
        return !SplitInvocationUtils.isSplitConfigUsed(project) && SplitInvocationUtils.buildConfigsCoincide(project) && SplitInvocationUtils.librariesCoincide(project) && glueDirPath.toFile().exists();
    }

    public static java.nio.file.Path getOrCreateGlueDirectory(IProject project) throws IOException {
        String projectLocation = project.getLocation().makeAbsolute().toOSString();
        java.nio.file.Path glueDirPath = Paths.get(projectLocation, ".dvt", GLUE_DIRECTORY_NAME);
        if (!glueDirPath.toFile().exists()) {
            Files.createDirectories(glueDirPath, new FileAttribute[0]);
        }
        return glueDirPath;
    }

    public static void serializeBuildConfig(IProject project) {
        String serializedBCName;
        Path buildConfigsDefaultDirectoryPath;
        if (project.getLocation() == null) {
            return;
        }
        ActiveBuildConfig activeBuildConfig = BuildConfigManagerCommon.getActiveBuildConfig(project);
        if (!BuildConfigManagerCommon.saveBuildConfig(activeBuildConfig, buildConfigsDefaultDirectoryPath = (Path)project.getLocation().append(".dvt").append(GLUE_DIRECTORY_NAME), serializedBCName = String.valueOf(activeBuildConfig.getName()) + SERIALIZED_BC_SUFFIX)) {
            DVTLogger.INSTANCE.logError(FAILED_TO_SERIALIZE_BC_ERROR);
        }
    }

    public static void createLibraryLastModified(IProject project) throws IOException {
        List<Invocation> invocations = BuildConfigManager.getInvocations(project);
        LinkedHashMap libDescriptorslastModified = new LinkedHashMap();
        for (Invocation invocation : invocations) {
            List<BuildConfigProperty> libDescriptors = BuildConfigManager.getLibs(invocation);
            for (BuildConfigProperty libDescriptor : libDescriptors) {
                String dirPath;
                if (libDescriptor.getKind() == 5) {
                    String filePath = libDescriptor.getValue();
                    if (filePath == null) continue;
                    LinkedHashMap<String, Long> libFiles = (LinkedHashMap<String, Long>)libDescriptorslastModified.get(LIBFILE);
                    if (libFiles == null) {
                        libFiles = new LinkedHashMap<String, Long>();
                    }
                    libFiles.put(filePath, new File(filePath).lastModified());
                    libDescriptorslastModified.put(LIBFILE, libFiles);
                    continue;
                }
                if (libDescriptor.getKind() != 4 || (dirPath = libDescriptor.getValue()) == null) continue;
                LinkedHashMap libDir = (LinkedHashMap)libDescriptorslastModified.get(LIBDIR);
                if (libDir == null) {
                    libDir = new LinkedHashMap();
                }
                ConcurrentHashMap concurrentLibFiles = new ConcurrentHashMap();
                ((Stream)Stream.of(new File(dirPath).listFiles()).parallel()).filter(dirFile -> !dirFile.isDirectory()).forEach(file -> concurrentLibFiles.put(file.getName(), new File(file.getAbsolutePath()).lastModified()));
                AbstractMap libFiles = TestHelper.isTestMode() ? new TreeMap(concurrentLibFiles) : concurrentLibFiles;
                libDir.put(dirPath, libFiles);
                libDescriptorslastModified.put(LIBDIR, libDir);
            }
        }
        if (libDescriptorslastModified.isEmpty()) {
            return;
        }
        java.nio.file.Path glueDirectoryPath = SplitInvocationUtils.getOrCreateGlueDirectory(project);
        java.nio.file.Path md5LibrariesPath = glueDirectoryPath.resolve(MD5_LIBRARIES);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml generatedYaml = new Yaml(options);
        try {
            Object object = null;
            Object var8_10 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(md5LibrariesPath.toUri())));){
                writer.write(generatedYaml.dump(libDescriptorslastModified));
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static boolean librariesCoincide(IProject project) {
        java.nio.file.Path librariesFile = Paths.get(project.getLocation().makeAbsolute().toOSString(), ".dvt", GLUE_DIRECTORY_NAME, MD5_LIBRARIES);
        Map libDescriptorsLastModified = null;
        File lastModifiedLibraryFiles = librariesFile.toFile();
        if (!lastModifiedLibraryFiles.exists()) {
            return true;
        }
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(lastModifiedLibraryFiles));){
                libDescriptorsLastModified = (Map)new Yaml().load((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (libDescriptorsLastModified == null) {
            return true;
        }
        for (Map.Entry libDescriptor : libDescriptorsLastModified.entrySet()) {
            String libDescriptorKind = (String)libDescriptor.getKey();
            if (LIBFILE.equals(libDescriptorKind)) {
                Map libFiles = (Map)libDescriptor.getValue();
                try {
                    libFiles.entrySet().parallelStream().forEach(libFile -> {
                        Long oldLastModified = (Long)libFile.getValue();
                        String filePath = (String)libFile.getKey();
                        if (oldLastModified == null || filePath == null) {
                            throw new RuntimeException();
                        }
                        Long newLastModified = new File(filePath).lastModified();
                        if (!oldLastModified.equals(newLastModified)) {
                            throw new RuntimeException();
                        }
                    });
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }
            if (!LIBDIR.equals(libDescriptorKind)) continue;
            Map libDirs = (Map)libDescriptor.getValue();
            for (Map.Entry libDir : libDirs.entrySet()) {
                String dirPath = (String)libDir.getKey();
                Map libFiles = (Map)libDir.getValue();
                if (dirPath == null || libFiles == null) {
                    return false;
                }
                File[] listFiles = new File(dirPath).listFiles();
                if (listFiles == null) {
                    return false;
                }
                long listFileSize = Stream.of(listFiles).filter(dirFile -> !dirFile.isDirectory()).count();
                if ((long)libFiles.size() != listFileSize) {
                    return false;
                }
                java.nio.file.Path dir = Paths.get(dirPath, new String[0]);
                try {
                    libFiles.entrySet().parallelStream().forEach(libFileEntry -> {
                        String filePath;
                        Long newLastModified;
                        Long oldLastModified = (Long)libFileEntry.getValue();
                        if (!oldLastModified.equals(newLastModified = Long.valueOf(new File(dir.resolve(filePath = (String)libFileEntry.getKey()).toString()).lastModified()))) {
                            throw new RuntimeException();
                        }
                    });
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }
        }
        return true;
    }

    public static enum SplitInvocationArg {
        DV,
        NOF_LINES,
        LIBRARIES;

    }

    public static enum SplitInvocationLibraryElementsMessageType {
        ADDED,
        REMOVED;

    }
}

