/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.builders;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTAutoLinkManagerCommon;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum DVTAutoLinkManager implements DVTAutoLinkManagerCommon
{
    INSTANCE;

    private static final String AUTOLINK_ROOT_ENV_VAR_PREFIX = "AUTOLINK_ROOT_VAR-";
    public static final String DVT_AUTO_LINK_CALLER_NAME = "Auto Link Manager";
    private static final String QN_AUTO_LINK_ROOT = "ro.amiq.dvt.AutoLinkRoot";
    private static final String QN_USER_LINK_PATH = "ro.amiq.dvt.UserLinkPath";
    public static final String DIRTY_AUTOLINKED_FILE = "DirtyAutolinkedFile";
    public static final QualifiedName QN_DIRTY_AUTOLINKED_FILE;
    public static final String DIRTY_PRJ_DESCRIPTION_FILE = "DirtyProjectDescriptionFile";
    public static final QualifiedName QN_DIRTY_PRJ_DESCRIPTION_FILE;
    private static final String AUTO_LINK_ROOT_LABEL = "+dvt_auto_link_root+";
    private static boolean fOSWindows;
    private HashMap<IPath, LinkDescription> fCachedLinksMap;
    private Deque<String> fGetLinksCacheStack;
    private Set<IProject> fProjectsUsingLinks = new HashSet<IProject>();
    private static Pattern SYS_VAR;
    private Map<IPath, IFileInfo> fFileInfoCache = new ConcurrentHashMap<IPath, IFileInfo>();
    private int fNofFileInfoCacheHits;
    private int fNofFileInfoCalls;
    public static final int ERROR_AUTOLINK_READ_ONLY = 1;
    public static final int ERROR_AUTOLINK_ERROR = 2;
    private Map<IProject, Integer> fErrorsMap = new ConcurrentHashMap<IProject, Integer>();

    static {
        QN_DIRTY_AUTOLINKED_FILE = new QualifiedName("ro.amiq.dvt", DIRTY_AUTOLINKED_FILE);
        QN_DIRTY_PRJ_DESCRIPTION_FILE = new QualifiedName("ro.amiq.dvt", DIRTY_PRJ_DESCRIPTION_FILE);
        SYS_VAR = Pattern.compile("((\\$\\{?[a-zA-Z_][a-zA-Z0-9_]*\\}?)|(%[a-zA-Z_][a-zA-Z0-9_]*%))", 8);
    }

    public static DVTAutoLinkManager getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isWindows() {
        return fOSWindows;
    }

    public void dirtyAutoLink(IProject project, String subFolderName) throws CoreException {
        IFolder directory = null;
        directory = project.getFolder("DVT Auto-Linked");
        if (!directory.exists()) {
            return;
        }
        if (!subFolderName.equals("DVT Auto-Linked") && !(directory = directory.getFolder(subFolderName)).exists()) {
            return;
        }
        this.dirtyAutoLink(project, directory);
    }

    public void dirtyAutoLink(IProject project, IFolder directory) throws CoreException {
        directory.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile) {
                    resource.setSessionProperty(QN_DIRTY_AUTOLINKED_FILE, (Object)true);
                    return false;
                }
                return true;
            }
        });
    }

    public String inverseTranslateAutoLinkedFileFullPath(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        if (fOSWindows) {
            return fullPath.replace(':', '\u1393');
        }
        return fullPath;
    }

    public void validateAutoLink(IProject project, IFile file) throws CoreException {
        if (project == null || file == null || file.getProject() == null) {
            return;
        }
        if (file.getProject().getName().equals(project.getName()) && file.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) {
            file.setSessionProperty(QN_DIRTY_AUTOLINKED_FILE, null);
        }
    }

    public void removeDirtyAutoLink(IProject project, String subFolderName, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        IFolder autolinkFolder = project.getFolder("DVT Auto-Linked");
        if (!autolinkFolder.exists()) {
            return;
        }
        try {
            if (!subFolderName.equals("DVT Auto-Linked") && !(autolinkFolder = autolinkFolder.getFolder(subFolderName)).exists()) {
                return;
            }
            Map<IResource, IEditorPart> openEditors = this.collectOpenEditors(project);
            boolean noMembers = this.recursiveVisitAndRemove(autolinkFolder, openEditors, cachedLinksMap);
            if (noMembers) {
                this.fastRemoveLink(project, (IResource)autolinkFolder, cachedLinksMap);
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    private Map<IResource, IEditorPart> collectOpenEditors(final IProject project) {
        final HashMap<IResource, IEditorPart> openEditors = new HashMap<IResource, IEditorPart>();
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return openEditors;
        }
        Display display = workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            return openEditors;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                if (activePage == null) {
                    return;
                }
                IEditorReference[] references = activePage.getEditorReferences();
                if (references == null) {
                    return;
                }
                IEditorReference[] iEditorReferenceArray = references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file;
                    IEditorReference reference = iEditorReferenceArray[n2];
                    IEditorPart editor = reference.getEditor(false);
                    if (editor != null && editor instanceof DVTEditor && (file = (IFile)editor.getAdapter(IResource.class)) != null && file.getProject().getName().equals(project.getName()) && file.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) {
                        openEditors.put((IResource)editor.getAdapter(IResource.class), editor);
                    }
                    ++n2;
                }
            }
        });
        return openEditors;
    }

    public void cleanCachedLinks(IProject project) {
        this.fGetLinksCacheStack = null;
        this.fCachedLinksMap = null;
    }

    public boolean autolinkUsingLinksForProject(IProject project) {
        return this.fProjectsUsingLinks.contains(project);
    }

    public void setProjectAutolinkUsingLinks(IProject project, boolean autolinkUsingLinks) {
        if (autolinkUsingLinks) {
            this.fProjectsUsingLinks.add(project);
        } else {
            this.fProjectsUsingLinks.remove(project);
        }
    }

    private Map<IPath, LinkDescription> getCachedLinks(IProject project, String callerName) {
        if (this.fGetLinksCacheStack == null) {
            this.fGetLinksCacheStack = new ArrayDeque<String>();
        }
        this.fGetLinksCacheStack.push(callerName);
        if (this.fCachedLinksMap != null) {
            return this.fCachedLinksMap;
        }
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        HashMap linksMap = projectDescription.getLinks();
        this.fCachedLinksMap = new HashMap();
        if (linksMap != null) {
            this.fCachedLinksMap.putAll(linksMap);
        }
        return this.fCachedLinksMap;
    }

    private void putCachedLinks(IProject project, boolean checkUpdateProjectDescIsConsistent, String callerName) throws CoreException {
        if (this.fGetLinksCacheStack == null || this.fGetLinksCacheStack.isEmpty()) {
            return;
        }
        String oldCallerName = this.fGetLinksCacheStack.peek();
        if (!oldCallerName.equals(callerName)) {
            this.cleanCachedLinks(project);
            throw new RuntimeException("Inconsistent state 1 (no pop for caller " + oldCallerName + ")");
        }
        this.fGetLinksCacheStack.pop();
        if (this.fCachedLinksMap == null) {
            return;
        }
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (this.fCachedLinksMap.isEmpty()) {
            projectDescription.setLinkDescriptions(null);
        } else {
            projectDescription.setLinkDescriptions(new HashMap<IPath, LinkDescription>(this.fCachedLinksMap));
        }
        if (this.fGetLinksCacheStack.isEmpty()) {
            this.updateProjectDescription(project);
            this.cleanCachedLinks(project);
        } else if (this.fNofFileInfoCacheHits != 0 && checkUpdateProjectDescIsConsistent) {
            this.cleanCachedLinks(project);
            throw new RuntimeException("Inconsistent state 2 (no pop for caller " + oldCallerName + ")");
        }
    }

    private boolean recursiveVisitAndRemove(IFolder folder, Map<IResource, IEditorPart> openEditors, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        IResource[] members;
        IProject project = folder.getProject();
        boolean noMembers = true;
        IResource[] iResourceArray = members = folder.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IFolder) {
                boolean subDirectoryNoMembers = this.recursiveVisitAndRemove((IFolder)member, openEditors, cachedLinksMap);
                if (subDirectoryNoMembers) {
                    this.fastRemoveLink(project, member, cachedLinksMap);
                    project.setSessionProperty(QN_DIRTY_PRJ_DESCRIPTION_FILE, (Object)true);
                }
                noMembers &= subDirectoryNoMembers;
            } else if (member instanceof IFile) {
                if (member.getSessionProperty(QN_DIRTY_AUTOLINKED_FILE) == null) {
                    noMembers = false;
                } else {
                    this.closeEditor(openEditors, member);
                    this.fastRemoveLink(project, member, cachedLinksMap);
                    project.setSessionProperty(QN_DIRTY_PRJ_DESCRIPTION_FILE, (Object)true);
                }
            }
            ++n2;
        }
        return noMembers;
    }

    private void closeEditor(Map<IResource, IEditorPart> openEditors, IResource member) {
        final IEditorPart openEditor = openEditors.get(member);
        if (openEditor == null) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow == null) {
                        return;
                    }
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    if (activePage == null) {
                        return;
                    }
                    activePage.closeEditor(openEditor, true);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    public IFile autoLinkFile(IProject project, IFolder directory, IPath filePath, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        if (project == null || directory == null || filePath == null) {
            return null;
        }
        IFile file = directory.getFile(Path.fromOSString((String)filePath.lastSegment()));
        boolean fileExists = file.exists();
        if (!fileExists || file.getLocation() == null) {
            if (fileExists) {
                this.fastRemoveLink(project, (IResource)file, cachedLinksMap);
            }
            this.fastCreateLink(project, filePath, (IResource)file, cachedLinksMap);
            project.setSessionProperty(QN_DIRTY_PRJ_DESCRIPTION_FILE, (Object)true);
        }
        return file;
    }

    private IFile autoLinkFileInRoot(IProject project, IFolder directory, IPath directoryPath, IPath filePath, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        if (project == null || directory == null || filePath == null) {
            return null;
        }
        IFile file = directory.getFile(Path.fromOSString((String)filePath.lastSegment()));
        boolean fileExists = file.exists();
        if (!fileExists || file.getLocation() == null) {
            filePath = Path.fromOSString((String)ResourceFilterUtils.toDvtEnvVars(directoryPath.append(filePath.lastSegment()).toOSString()));
            if (fileExists) {
                this.fastRemoveLink(project, (IResource)file, cachedLinksMap);
            }
            this.fastCreateLink(project, filePath, (IResource)file, cachedLinksMap);
            project.setSessionProperty(QN_DIRTY_PRJ_DESCRIPTION_FILE, (Object)true);
        }
        return file;
    }

    @Override
    public boolean hasEnviromentVariable(IProject project, IPath path) {
        String pathText = path.toOSString();
        if (pathText.indexOf(36) == -1 && pathText.indexOf(37) == -1) {
            return false;
        }
        Matcher matcher = SYS_VAR.matcher(pathText);
        return matcher.find();
    }

    private int filePathSegmentIndex(IProject project, AutoLinkRoot root, IPath filePath) {
        IPath pathRoot = root.getExpandedPath();
        if (pathRoot == null) {
            return -1;
        }
        IPath dirPath = filePath.removeLastSegments(1);
        if (pathRoot.segmentCount() <= dirPath.segmentCount()) {
            return pathRoot.segmentCount();
        }
        return -1;
    }

    private IFile createAutoLinkInRootVariable(IProject project, AutoLinkRoot root, IPath filePath, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        int segmentIndex;
        if (project == null || root == null || filePath == null) {
            return null;
        }
        IPath directoryPath = root.getPath();
        IFolder directory = project.getFolder("DVT Auto-Linked");
        if (!directory.exists()) {
            this.fastCreateLink(project, null, (IResource)directory, cachedLinksMap);
        }
        if (!(directory = directory.getFolder(root.getAlias())).exists()) {
            this.fastCreateLink(project, null, (IResource)directory, cachedLinksMap);
        }
        if ((segmentIndex = this.filePathSegmentIndex(project, root, filePath)) == -1) {
            return null;
        }
        int i = segmentIndex;
        while (i < filePath.segmentCount() - 1) {
            String segment = filePath.segment(i);
            directoryPath = directoryPath.append(segment);
            if (!(directory = directory.getFolder(segment)).exists()) {
                this.fastCreateLink(project, null, (IResource)directory, cachedLinksMap);
            }
            ++i;
        }
        return this.autoLinkFileInRoot(project, directory, directoryPath, filePath, cachedLinksMap);
    }

    private IFile createAutoLinkInRootPath(IProject project, AutoLinkRoot root, IPath filePath, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        int segmentIndex;
        if (project == null || root == null || filePath == null) {
            return null;
        }
        IFolder directory = project.getFolder("DVT Auto-Linked");
        if (!directory.exists()) {
            this.fastCreateLink(project, null, (IResource)directory, cachedLinksMap);
        }
        if (!(directory = directory.getFolder(root.getAlias())).exists()) {
            this.fastCreateLink(project, null, (IResource)directory, cachedLinksMap);
        }
        if ((segmentIndex = this.filePathSegmentIndex(project, root, filePath)) == -1) {
            return null;
        }
        int i = segmentIndex;
        while (i < filePath.segmentCount() - 1) {
            String segment = filePath.segment(i);
            if (!(directory = directory.getFolder(segment)).exists()) {
                this.fastCreateLink(project, null, (IResource)directory, cachedLinksMap);
            }
            ++i;
        }
        return this.autoLinkFile(project, directory, filePath, cachedLinksMap);
    }

    private IFile createAutoLinkInRoots(IProject project, AutoLinkRoot root, IPath filePath, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        if (project == null || root == null || filePath == null) {
            return null;
        }
        if (this.hasEnviromentVariable(project, root.getPath())) {
            return this.createAutoLinkInRootVariable(project, root, filePath, cachedLinksMap);
        }
        return this.createAutoLinkInRootPath(project, root, filePath, cachedLinksMap);
    }

    private IFile createAutoLinkInFolder(IProject project, IPath filePath, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        if (project == null || filePath == null) {
            return null;
        }
        IFolder directory = project.getFolder("DVT Auto-Linked");
        if (!directory.exists()) {
            this.fastCreateLink(project, null, (IResource)directory, cachedLinksMap);
        }
        IPath dirPath = filePath.removeLastSegments(1);
        if (fOSWindows) {
            String device = dirPath.getDevice();
            if (device != null) {
                directory = directory.getFolder(String.valueOf(device.substring(0, device.length() - 1)) + '\u1393');
            }
            if (!directory.exists()) {
                this.fastCreateLink(project, null, (IResource)directory, cachedLinksMap);
            }
        }
        int i = 0;
        while (i < dirPath.segmentCount()) {
            String segment = dirPath.segment(i);
            if (!(directory = directory.getFolder(segment)).exists()) {
                this.fastCreateLink(project, null, (IResource)directory, cachedLinksMap);
            }
            ++i;
        }
        return this.autoLinkFile(project, directory, filePath, cachedLinksMap);
    }

    public IFile createAutoLink(IProject project, IPath filePath, Map<String, AutoLinkRoot> currAutoLinkedRoots, Map<IPath, LinkDescription> cachedLinksMap, boolean checkExists) throws CoreException {
        if (checkExists && filePath.isAbsolute() && !filePath.toFile().exists()) {
            return null;
        }
        AutoLinkRoot root = DVTFileUtils.getInstance().autoLinkRootForFile(filePath, currAutoLinkedRoots);
        if (root != null) {
            return this.createAutoLinkInRoots(project, root, filePath, cachedLinksMap);
        }
        return this.createAutoLinkInFolder(project, filePath, cachedLinksMap);
    }

    private void recursiveRemoveLinkDirectory(IProject project, IFolder folder, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = folder.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IFolder) {
                this.recursiveRemoveLinkDirectory(project, (IFolder)member, cachedLinksMap);
            }
            this.fastRemoveLink(project, member, cachedLinksMap);
            ++n2;
        }
        this.fastRemoveLink(project, (IResource)folder, cachedLinksMap);
    }

    public void fastRemoveLink(IProject project, IResource resource, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        IPath projectRelativePath = resource.getProjectRelativePath();
        if (cachedLinksMap == null) {
            projectDescription.setLinkLocation(projectRelativePath, null);
            resource.delete(true, null);
        } else {
            cachedLinksMap.remove(projectRelativePath);
            this.fastRemoveVirtualResource((Resource)resource);
        }
    }

    private void fastCreateLink(IProject project, IPath filePath, IResource resource, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        URI uri = resource instanceof IFile ? URIUtil.toURI((IPath)filePath) : LinkDescription.VIRTUAL_LOCATION;
        IPath projectRelativePath = resource.getProjectRelativePath();
        LinkDescription linkDescription = new LinkDescription(resource, uri);
        if (this.autolinkUsingLinksForProject(resource.getProject())) {
            if (cachedLinksMap == null) {
                ProjectDescription projectDescription = ((Project)project).internalGetDescription();
                projectDescription.setLinkLocation(resource.getProjectRelativePath(), linkDescription);
            } else {
                cachedLinksMap.put(projectRelativePath, linkDescription);
            }
        }
        if (resource instanceof IFile) {
            this.fastCreateVirtualResource((Resource)resource, filePath, uri, linkDescription);
        } else if (resource instanceof IFolder) {
            this.fastCreateVirtualResource((Resource)resource, null, LinkDescription.VIRTUAL_LOCATION, linkDescription);
        }
    }

    public final void updateProjectDescription(IProject project) throws CoreException {
        if (!project.isAccessible()) {
            return;
        }
        if (project.getSessionProperty(QN_DIRTY_PRJ_DESCRIPTION_FILE) == null) {
            return;
        }
        project.setSessionProperty(QN_DIRTY_PRJ_DESCRIPTION_FILE, null);
        IFolder directory = project.getFolder("DVT Auto-Linked");
        Workspace workspace = (Workspace)project.getWorkspace();
        IProgressMonitor monitor = Policy.monitorFor(null);
        try {
            ISchedulingRule rule = workspace.getRuleFactory().createRule((IResource)directory);
            try {
                workspace.prepareOperation(rule, monitor);
                workspace.beginOperation(true);
                IFile projectFile = project.getFile(".project");
                if (!projectFile.isReadOnly()) {
                    ((Project)project).writeDescription(0);
                }
            }
            catch (Throwable throwable) {
                this.reflectionWorkspaceEndOperation(workspace, rule, false, EclipseUtils.isAtLeastEclipse47() ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                throw throwable;
            }
            this.reflectionWorkspaceEndOperation(workspace, rule, false, EclipseUtils.isAtLeastEclipse47() ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
        }
        finally {
            monitor.done();
        }
    }

    public final void startWorkspaceOperation(IProject project, boolean createNewTree) throws CoreException {
        Workspace workspace = (Workspace)project.getWorkspace();
        workspace.prepareOperation((ISchedulingRule)project, (IProgressMonitor)new NullProgressMonitor());
        workspace.beginOperation(createNewTree);
    }

    public final void endWorkspaceOperation(IProject project, boolean build) throws CoreException {
        Workspace workspace = (Workspace)project.getWorkspace();
        this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)project, build, (IProgressMonitor)(EclipseUtils.isAtLeastEclipse47() ? null : new NullProgressMonitor()));
    }

    private final void fastCreateVirtualResource(Resource resource, IPath filePath, URI localLocation, LinkDescription linkDescription) throws CoreException {
        Workspace workspace = (Workspace)resource.getWorkspace();
        IFileInfo fileInfo = this.assertLinkRequirements(resource, filePath, localLocation);
        ResourceInfo info = workspace.createResource((IResource)resource, false);
        boolean autolinkUsingLinks = this.autolinkUsingLinksForProject(resource.getProject());
        if (autolinkUsingLinks || resource instanceof IFolder) {
            info.set(65536);
        } else {
            info.setModificationStamp(-1L);
        }
        if (linkDescription.isGroup()) {
            info.set(524288);
        }
        resource.getLocalManager().link(resource, localLocation, fileInfo);
        if (localLocation == LinkDescription.VIRTUAL_LOCATION) {
            info.setModificationStamp(System.currentTimeMillis());
        }
    }

    private void fastRemoveVirtualResource(Resource resource) throws CoreException {
        Workspace workspace = (Workspace)resource.getWorkspace();
        if (resource.exists()) {
            workspace.getMarkerManager().removeMarkers((IResource)resource, 2);
            try {
                Class<?> clazz = workspace.getClass();
                Method deleteResource = clazz.getDeclaredMethod("deleteResource", IResource.class);
                deleteResource.setAccessible(true);
                deleteResource.invoke((Object)workspace, resource);
            }
            catch (InvocationTargetException e) {
                DVTLogger.INSTANCE.logError(e.getCause());
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            resource.getPropertyManager().deleteResource((IResource)resource);
        }
    }

    public void cleanFileInfoCache() {
        this.fNofFileInfoCacheHits = 0;
        this.fNofFileInfoCalls = 0;
        this.fFileInfoCache.clear();
    }

    public final void printFileInfoCacheStat() {
    }

    public final IFileInfo fetchFileInfo(IPath filePath) {
        try {
            ++this.fNofFileInfoCalls;
            IFileInfo fileInfo = this.fFileInfoCache.get(filePath);
            if (fileInfo != null) {
                ++this.fNofFileInfoCacheHits;
                return fileInfo;
            }
            IFileStore store = EFS.getStore((URI)URIUtil.toURI((IPath)filePath));
            fileInfo = store.fetchInfo();
            this.fFileInfoCache.put(filePath, fileInfo);
            return fileInfo;
        }
        catch (Exception exception) {
            return new FileInfo();
        }
    }

    public final void removeFileInfo(IPath filePath) {
        try {
            this.fFileInfoCache.remove(filePath);
        }
        catch (Exception exception) {}
    }

    public final IFileInfo getCachedFileInfo(IPath filePath) {
        try {
            return this.fFileInfoCache.get(filePath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final IFileInfo assertLinkRequirements(Resource resource, IPath filePath, URI localLocation) throws CoreException {
        if (resource instanceof IFolder && LinkDescription.VIRTUAL_LOCATION.equals(localLocation)) {
            return new FileInfo(resource.getName());
        }
        IFileInfo fileInfo = this.fFileInfoCache.get(filePath);
        if (fileInfo != null) {
            ++this.fNofFileInfoCacheHits;
            return fileInfo;
        }
        URI resolved = resource.getPathVariableManager().resolveURI(localLocation);
        fileInfo = this.fetchFileInfo(URIUtil.toPath((URI)resolved));
        return fileInfo;
    }

    public void updateAutoLinkRoots(IProject project, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
        String prevAutoLinkedRoots = this.getUnlimitedSizePersistentProperty(project, QN_AUTO_LINK_ROOT);
        Map<String, AutoLinkRoot> currAutoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
        HashSet<String> aliasesWorkingCopy = new HashSet<String>(currAutoLinkedRoots.keySet());
        if (prevAutoLinkedRoots != null) {
            int endIndex = 0;
            int startIndex = 0;
            while ((endIndex = prevAutoLinkedRoots.indexOf(10, startIndex)) != -1) {
                String autoLinkRootDesc = prevAutoLinkedRoots.substring(startIndex, endIndex);
                startIndex = endIndex + 1;
                int index = autoLinkRootDesc.indexOf(61);
                if (index == -1 && index < AUTO_LINK_ROOT_LABEL.length()) continue;
                String alias = autoLinkRootDesc.substring(AUTO_LINK_ROOT_LABEL.length(), index);
                IPath expandedPath = Path.fromOSString((String)autoLinkRootDesc.substring(index + 1));
                AutoLinkRoot autoLinkedRoot = null;
                autoLinkedRoot = currAutoLinkedRoots.get(alias);
                if (autoLinkedRoot != null && autoLinkedRoot.getExpandedPath().equals((Object)expandedPath)) {
                    aliasesWorkingCopy.remove(alias);
                    continue;
                }
                aliasesWorkingCopy.add(alias);
            }
        }
        if (!aliasesWorkingCopy.isEmpty()) {
            StringBuilder currAutoLinkedRootsString = new StringBuilder();
            for (AutoLinkRoot autoLinkRoot : currAutoLinkedRoots.values()) {
                currAutoLinkedRootsString.append(AUTO_LINK_ROOT_LABEL).append(autoLinkRoot.getAlias()).append('=');
                currAutoLinkedRootsString.append(autoLinkRoot.getExpandedPath().toOSString()).append('\n');
            }
            this.setUnlimitedSizePersistentProperty(project, QN_AUTO_LINK_ROOT, currAutoLinkedRootsString.toString());
            IFolder autolinkFolder = project.getFolder("DVT Auto-Linked");
            if (autolinkFolder.exists()) {
                this.recursiveRemoveLinkDirectory(project, autolinkFolder, cachedLinksMap);
                project.setSessionProperty(QN_DIRTY_PRJ_DESCRIPTION_FILE, (Object)true);
            }
        }
        this.restoreUserLinked(project, true);
    }

    private boolean cleanAutoLinked(IProject project, String subFolderName) {
        try {
            IFile projectFile;
            boolean readOnly;
            IFolder directory;
            IPath autoLinkedPathPrefix = Path.fromOSString((String)"DVT Auto-Linked");
            if (!subFolderName.equals("DVT Auto-Linked")) {
                autoLinkedPathPrefix.append(subFolderName);
            }
            if ((directory = project.getFolder(autoLinkedPathPrefix)) != null && directory.exists() && !(readOnly = (projectFile = project.getFile(".project")).getResourceAttributes().isReadOnly())) {
                this.dirtyAutoLink(project, directory);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public IFile getFile(IContainer container, String fileName, IProgressMonitor monitor) throws CoreException {
        IFile result = null;
        if (container.isVirtual()) {
            IPath containerPath = DVTFileUtils.getInstance().resolveAutoLinkPath((IResource)container);
            IPath filePath = Path.fromOSString((String)this.translateAutoLinkedFileFullPath(DVTFileUtils.getInstance().makeUNCPath(containerPath.append(fileName)).toOSString()));
            try {
                File file = filePath.toFile();
                if (!file.exists()) {
                    file.createNewFile();
                    result = ((IFolder)container).getFile(fileName);
                    result.createLink(filePath, 8192, monitor);
                    this.saveUserAutolinked(result.getProject(), filePath.makeAbsolute());
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        } else {
            result = container.getFile(Path.fromOSString((String)fileName));
        }
        return result;
    }

    public void saveUserAutolinked(IProject project, IPath fullPath) throws CoreException {
        String userLinkPaths = this.getUnlimitedSizePersistentProperty(project, QN_USER_LINK_PATH);
        userLinkPaths = userLinkPaths == null ? String.valueOf(fullPath.toOSString()) + "\n" : String.valueOf(userLinkPaths) + fullPath.toOSString() + "\n";
        this.setUnlimitedSizePersistentProperty(project, QN_USER_LINK_PATH, userLinkPaths);
    }

    public boolean restoreUserLinked(IProject project, boolean create) {
        try {
            String currUserLinkPaths = this.getUnlimitedSizePersistentProperty(project, QN_USER_LINK_PATH);
            HashSet<String> validUserLinkPaths = new HashSet<String>();
            if (currUserLinkPaths != null) {
                int endIndex = 0;
                int startIndex = 0;
                while ((endIndex = currUserLinkPaths.indexOf(10, startIndex)) != -1) {
                    String userLinkPath = currUserLinkPaths.substring(startIndex, endIndex);
                    startIndex = endIndex + 1;
                    IFile file = DVTFileUtils.getInstance().findProjectFile(project, userLinkPath);
                    Map<String, AutoLinkRoot> roots = BuildConfigManager.getAutoLinkedRoots(project);
                    if (file == null) {
                        AutoLinkRoot foundRoot = DVTFileUtils.getInstance().autoLinkRootForFile(Path.fromOSString((String)userLinkPath), roots);
                        IPath tailAutoLinkPath = DVTFileUtils.getInstance().equalPathFromAutoLinkRoot(Path.fromOSString((String)userLinkPath), foundRoot);
                        if (tailAutoLinkPath != null) {
                            file = project.getFile(Path.fromOSString((String)"DVT Auto-Linked").append(tailAutoLinkPath));
                        }
                    }
                    if (file != null && file.exists() && file.getLocation() != null) {
                        this.validateAutoLink(project, file);
                        validUserLinkPaths.add(userLinkPath);
                        continue;
                    }
                    if (!create || file == null) continue;
                    this.createAutoLink(project, Path.fromOSString((String)userLinkPath), roots, null, false);
                    validUserLinkPaths.add(userLinkPath);
                }
                StringBuilder nextUserLinkPaths = new StringBuilder("");
                for (String validUserLinkPath : validUserLinkPaths) {
                    nextUserLinkPaths.append(validUserLinkPath).append('\n');
                }
                this.setUnlimitedSizePersistentProperty(project, QN_USER_LINK_PATH, nextUserLinkPaths.toString());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        return true;
    }

    private void setUnlimitedSizePersistentProperty(IProject project, String qualifiedName, String string) {
        IPath workingLocation = project.getWorkingLocation("auto_linked");
        DVTFileUtils.getInstance().writeStringToFile(workingLocation.append(qualifiedName).toFile(), string, false);
    }

    private String getUnlimitedSizePersistentProperty(IProject project, String qualifiedName) {
        IPath workingLocation = project.getWorkingLocation("auto_linked");
        return DVTFileUtils.getInstance().readFileContent(workingLocation.append(qualifiedName).toFile());
    }

    public void prepareFullBuildAutoLink(final IProject project) throws CoreException {
        this.fErrorsMap.put(project, 0);
        this.startWorkspaceOperation(project, true);
        IAutoLinkOperation op = new IAutoLinkOperation(){

            @Override
            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                DVTAutoLinkManager.this.writeAutoLinkRootEnvVarsToProjectDescription(project);
                DVTAutoLinkManager.this.updateAutoLinkRoots(project, cachedLinksMap);
            }
        };
        this.modifyWorkspaceOperation(project, DVT_AUTO_LINK_CALLER_NAME, op, false);
        this.cleanAutoLinked(project, "DVT Auto-Linked");
        this.restoreUserLinked(project, false);
        this.endWorkspaceOperation(project, false);
    }

    private void writeAutoLinkRootEnvVarsToProjectDescription(IProject project) {
        HashMap prevVariableDescriptions;
        BuildConfigParser.InvocationState globalDirectivesInvocationState;
        List<Invocation> invocations;
        if (!(project instanceof Project)) {
            return;
        }
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return;
        }
        boolean changed = false;
        Map<Object, Object> rootsToEnvVarsMap = Collections.emptyMap();
        if (this.autolinkUsingLinksForProject(project) && !(invocations = BuildConfigManager.getInvocations(project)).isEmpty() && (globalDirectivesInvocationState = invocations.get(0).getState()) != null) {
            rootsToEnvVarsMap = globalDirectivesInvocationState.fDVTDefinedVarAutoLinkRootsMap;
        }
        if ((prevVariableDescriptions = projectDescription.getVariables()) != null) {
            for (Map.Entry varDescEntry : prevVariableDescriptions.entrySet()) {
                String varDescName = (String)varDescEntry.getKey();
                VariableDescription varDesc = (VariableDescription)varDescEntry.getValue();
                if (!varDescName.startsWith(AUTOLINK_ROOT_ENV_VAR_PREFIX) || varDesc == null || varDesc.getName() == null || rootsToEnvVarsMap.get(varDesc.getName().substring(AUTOLINK_ROOT_ENV_VAR_PREFIX.length())) != null) continue;
                changed |= projectDescription.setVariableDescription(varDescName, null);
            }
        }
        for (Map.Entry variable : rootsToEnvVarsMap.entrySet()) {
            String variableDescName = AUTOLINK_ROOT_ENV_VAR_PREFIX + (String)variable.getKey();
            VariableDescription newVarDesc = new VariableDescription(variableDescName, (String)variable.getValue());
            changed |= projectDescription.setVariableDescription(variableDescName, newVarDesc);
        }
        if (!changed) {
            return;
        }
        try {
            this.updateProjectDescription(project);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void modifyWorkspaceOperation(IProject project, String callerName, IAutoLinkOperation op, boolean workspaceOperation) throws CoreException {
        block8: {
            if (workspaceOperation) {
                this.startWorkspaceOperation(project, true);
            }
            Map<IPath, LinkDescription> cachedLinksMap = this.getCachedLinks(project, callerName);
            try {
                try {
                    op.run(cachedLinksMap);
                }
                catch (Throwable e) {
                    if (e instanceof CoreException) {
                        throw (CoreException)e;
                    }
                    DVTLogger.INSTANCE.logError(e);
                    this.putCachedLinks(project, false, callerName);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.putCachedLinks(project, false, callerName);
                throw throwable;
            }
            this.putCachedLinks(project, false, callerName);
        }
        if (workspaceOperation) {
            this.endWorkspaceOperation(project, true);
        }
    }

    public final boolean hasError(IProject project, int errorKind) {
        try {
            Integer savedError = this.fErrorsMap.get(project);
            if (savedError == null) {
                savedError = 0;
            }
            return (savedError & errorKind) != 0;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public final void reportError(IProject project, int error) {
        try {
            Integer savedError = this.fErrorsMap.get(project);
            if (savedError == null) {
                savedError = 0;
            }
            if ((savedError & error) == 0) {
                savedError = savedError + error;
                this.fErrorsMap.put(project, savedError);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void reportAutoLinkErrors(final IProject project) {
        Integer savedError = this.fErrorsMap.get(project);
        if (savedError == null) {
            savedError = 0;
        }
        if (savedError != 0) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String projectName;
                    String string = projectName = project == null ? "<null project>" : project.getName();
                    if (DVTAutoLinkManager.this.hasError(project, 1)) {
                        Utils.popMessage(2, "Cannot Update The DVT Auto-Linked", "DVT was unable to update the DVT Auto-Linked folder for project '" + projectName + "' because project description file '.project' is read only.");
                    } else {
                        Utils.popMessage(2, "Cannot Auto-link Resources", "DVT was unable to auto-link resources for project '" + projectName + "' due to an unexpected error.\n" + "Please consult the error log for further details.");
                    }
                }
            });
        }
    }

    public void reflectionWorkspaceEndOperation(Workspace workspace, ISchedulingRule rule, boolean build, IProgressMonitor monitor) {
        try {
            if (EclipseUtils.isAtLeastEclipse47()) {
                Method endOperationM = workspace.getClass().getMethod("endOperation", ISchedulingRule.class, Boolean.TYPE);
                endOperationM.invoke((Object)workspace, rule, build);
            } else {
                Method endOperationM = workspace.getClass().getMethod("endOperation", ISchedulingRule.class, Boolean.TYPE, IProgressMonitor.class);
                endOperationM.invoke((Object)workspace, rule, build, monitor);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void removeAutolink(final IProject project) throws CoreException {
        IAutoLinkOperation op = new IAutoLinkOperation(){

            @Override
            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                DVTAutoLinkManager.getInstance().dirtyAutoLink(project, "DVT Auto-Linked");
                DVTAutoLinkManager.getInstance().removeDirtyAutoLink(project, "DVT Auto-Linked", cachedLinksMap);
            }
        };
        this.modifyWorkspaceOperation(project, DVT_AUTO_LINK_CALLER_NAME, op, true);
    }

    public boolean projectDescriptionContainsAutolink(IProject project) {
        boolean descriptionContainsAutoLinked = false;
        try {
            IPath projectFile = project.getFile(".project").getLocation();
            ProjectDescription diskDescription = new ProjectDescriptionReader(project).read(projectFile);
            HashMap links = diskDescription.getLinks();
            if (links != null && links.get(Path.fromOSString((String)"DVT Auto-Linked")) != null) {
                descriptionContainsAutoLinked = true;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return descriptionContainsAutoLinked;
    }

    public static interface IAutoLinkOperation {
        public void run(Map<IPath, LinkDescription> var1) throws CoreException;
    }
}

