/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.builders;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public interface DVTAutoLinkManagerCommon {
    public static final String AUTOLINK_FOLDER_NAME = "DVT Auto-Linked";
    public static final char COLON_REPLACEMENT_CHAR = '\u1393';
    public static final Pattern SYS_VAR = Pattern.compile("((\\$\\{?[a-zA-Z_][a-zA-Z0-9_]*\\}?)|(%[a-zA-Z_][a-zA-Z0-9_]*%))", 8);

    default public String translateAutoLinkedFileFullPath(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        if (this.isWindows()) {
            return fullPath.replace('\u1393', ':');
        }
        return fullPath;
    }

    default public boolean hasEnviromentVariable(IProject project, IPath path) {
        String pathText = path.toOSString();
        if (pathText.indexOf(36) == -1 && pathText.indexOf(37) == -1) {
            return false;
        }
        Matcher matcher = SYS_VAR.matcher(pathText);
        return matcher.find();
    }

    public boolean isWindows();
}

