/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.builders;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.specador.SpecadorManager;

public enum DVTBuildCancelManager implements IBuildDoneListener
{
    INSTANCE;

    public static final String CANCEL_MESSAGE_PATTERN;
    public static final String BUILD_CANCEL_MESSAGE = "Project database is not up to date because build was cancelled by user.";
    public static final String PRECOMPILED_LOAD_FAIL_MESSAGE = "Failed to load precompiled database.";

    static {
        CANCEL_MESSAGE_PATTERN = String.valueOf(System.lineSeparator()) + "*** Error: {0}" + System.lineSeparator();
    }

    @Override
    public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        if (!IBuildDoneListener.BuildFinishReason.isFullBuild(buildFinishReason)) {
            return;
        }
        this.updateBuildStatus(buildFinishReason, projectName);
    }

    public void updateBuildStatus(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        this.updateBuildConsole(buildFinishReason, projectName);
        FIncrementalNotificationTracker.INSTANCE.buildCancelUpdate(projectName, buildFinishReason);
        SpecadorManager.INSTANCE.buildCancelUpdate(projectName, buildFinishReason);
    }

    private void updateBuildConsole(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        if (IBuildDoneListener.BuildFinishReason.FULL_BUILD_CANCEL != buildFinishReason && IBuildDoneListener.BuildFinishReason.PRECOMPILED_LIB_LOAD_CANCEL != buildFinishReason) {
            return;
        }
        IProject project = Utils.getProject(projectName);
        if (project == null) {
            return;
        }
        DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole(project);
        String message = MessageFormat.format(CANCEL_MESSAGE_PATTERN, IBuildDoneListener.BuildFinishReason.FULL_BUILD_CANCEL == buildFinishReason ? BUILD_CANCEL_MESSAGE : PRECOMPILED_LOAD_FAIL_MESSAGE);
        console.print(message);
    }
}

