/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.builders;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTConsoleButtonsDescription;
import ro.amiq.dvt.builders.DVTMessageConsole;
import ro.amiq.dvt.builders.DVTMessageReportConsole;
import ro.amiq.dvt.builders.DVTPrecompiledDatabaseRebuildConsole;
import ro.amiq.dvt.externaltools.ConsoleHighlightModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class DVTBuildConsole
extends DVTBuildConsoleCommon
implements IResourceChangeListener {
    private static final String PATTERN_STRING_DONE = "(?m)^Done\\s+(?:\\([a-zA-Z0-9 ]+\\)\\s+)?(.+)\\s+\\[[^\\]]+\\]\\s+\\.{3}";
    private static final Pattern PATTERN_DONE = Pattern.compile("(?m)^Done\\s+(?:\\([a-zA-Z0-9 ]+\\)\\s+)?(.+)\\s+\\[[^\\]]+\\]\\s+\\.{3}");
    private static final String LINE_QUALIFIER_DONE = "Done\\s+";
    private static final String PATTERN_STRING_LOAD = "(?m)^Loading\\s+(?:test\\s+.+?\\s+)?(?:-y lib\\s+)?(?:precompiled database\\s+)?(?:\\([0-9/]+\\)\\s+)?((?:.(?!\\.{3}))+)(?:\\s+\\.{3})?";
    private static final Pattern PATTERN_LOAD = Pattern.compile("(?m)^Loading\\s+(?:test\\s+.+?\\s+)?(?:-y lib\\s+)?(?:precompiled database\\s+)?(?:\\([0-9/]+\\)\\s+)?((?:.(?!\\.{3}))+)(?:\\s+\\.{3})?");
    private static final String LINE_QUALIFIER_LOAD = "Loading\\s+";
    private static final String PATTERN_STRING_SIMPLE_PATH = "(?m)^\\s+((?:/\\S+)+)";
    private static final Pattern PATTERN_SIMPLE_PATH = Pattern.compile("(?m)^\\s+((?:/\\S+)+)");
    private static final String LINE_QUALIFIER_SIMPLE_PATH = "\\s+/";
    private static final String PATTERN_STRING_LOAD_TEST = "(?m)^\\s+imported\\s+by\\s+test\\s+\\([0-9/]+\\)\\s+(.+)\\s+\\.{3}";
    private static final Pattern PATTERN_LOAD_TEST = Pattern.compile("(?m)^\\s+imported\\s+by\\s+test\\s+\\([0-9/]+\\)\\s+(.+)\\s+\\.{3}");
    private static final String LINE_QUALIFIER_LOAD_TEST = "\\s+imported";
    private static final String PATTERN_STRING_SCAN = "(?m)^Scanning\\s+(?:-v lib\\s+\\([0-9/]+\\)\\s+)?(.+)\\s+(?:\\[[0-9]+\\s+ms\\]\\s+)?\\.{3}";
    private static final Pattern PATTERN_SCAN = Pattern.compile("(?m)^Scanning\\s+(?:-v lib\\s+\\([0-9/]+\\)\\s+)?(.+)\\s+(?:\\[[0-9]+\\s+ms\\]\\s+)?\\.{3}");
    private static final String LINE_QUALIFIER_SCAN = "Scanning\\s+";
    private static final String PATTERN_STRING_SKIP = "(?m)^Skipping\\s+(?:\\([a-zA-Z0-9]+\\)\\s+)?(.+)\\s+\\.{3}";
    private static final Pattern PATTERN_SKIP = Pattern.compile("(?m)^Skipping\\s+(?:\\([a-zA-Z0-9]+\\)\\s+)?(.+)\\s+\\.{3}");
    private static final String LINE_QUALIFIER_SKIP = "Skipping\\s+";
    private static final String PATTERN_STRING_OPTIMIZING = "(?m)^Optimizing\\s+(?:\\([a-zA-Z0-9]+\\)\\s+)?(?:\\([0-9/]+\\)\\s+)?(.+)\\s+\\.{3}";
    private static final Pattern PATTERN_OPTIMIZING = Pattern.compile("(?m)^Optimizing\\s+(?:\\([a-zA-Z0-9]+\\)\\s+)?(?:\\([0-9/]+\\)\\s+)?(.+)\\s+\\.{3}");
    private static final String LINE_QUALIFIER_OPTIMIZING = "Optimizing\\s+";
    private static final String PATTERN_STRING_CMD_FILE_CALL = "(?m)^\\s*(?:-f|-F|-file|Build configuration file: )\\s+(.+)";
    private static final Pattern PATTERN_CMD_FILE_CALL = Pattern.compile("(?m)^\\s*(?:-f|-F|-file|Build configuration file: )\\s+(.+)");
    private static final String LINE_QUALIFIER_CMD_FILE_CALL = "-.*|Build";
    private static final String PATTERN_STRING_INCLUDE_CONFIG_CALL = "(?m)^\\s*\\+dvt_include_config\\+(.+)";
    private static final Pattern PATTERN_INCLUDE_CONFIG_CALL = Pattern.compile("(?m)^\\s*\\+dvt_include_config\\+(.+)");
    private static final String LINE_QUALIFIER_INCLUDE_CONFIG_CALL = "-.*|Build";
    private static final String PATTERN_STRING_BUILD_LOG = "(.*dvt_build\\.log)";
    private static final Pattern PATTERN_BUILD_LOG = Pattern.compile("(.*dvt_build\\.log)");
    private static final String LINE_QUALIFIER_BUILD_LOG = ".*dvt_build\\.log";
    private static final String PATTERN_STRING_CMD_FILE_IMPORTED = "(?m)^\\s+included by\\s+(.+) at line ([0-9]+)";
    private static final Pattern PATTERN_CMD_FILE_IMPORTED = Pattern.compile("(?m)^\\s+included by\\s+(.+) at line ([0-9]+)");
    private static final String LINE_QUALIFIER_CMD_FILE_IMPORTED = "\\s+included";
    private static final String PATTERN_STRING_AUTO_DEFINE = "(?m)^Encrypted code auto-api(?: \\(update\\))?(?:.+)\\R\\s+in file (.+) at line ([0-9]+)";
    private static final Pattern PATTERN_AUTO_DEFINE = Pattern.compile("(?m)^Encrypted code auto-api(?: \\(update\\))?(?:.+)\\R\\s+in file (.+) at line ([0-9]+)");
    private static final String LINE_QUALIFIER_AUTO_DEFINE = "Encrypted code auto-api";
    private static final String PATTERN_STRING_AUTO_MACRO = "(?m)^Encrypted code auto-macro(?: \\(update\\))?(?:.+)\\R\\s+in file (.+) at line ([0-9]+)";
    private static final Pattern PATTERN_AUTO_MACRO = Pattern.compile("(?m)^Encrypted code auto-macro(?: \\(update\\))?(?:.+)\\R\\s+in file (.+) at line ([0-9]+)");
    private static final String LINE_QUALIFIER_AUTO_MACRO = "ncrypted code auto-macro";
    private static final String PATTERN_STRING_AUTO_CLOSE = "(?m)^Encrypted code auto-close: (?:.+)\\s+in file (.+) at line ([0-9]+)";
    private static final Pattern PATTERN_AUTO_CLOSE = Pattern.compile("(?m)^Encrypted code auto-close: (?:.+)\\s+in file (.+) at line ([0-9]+)");
    private static final String LINE_QUALIFIER_AUTO_ClOSE = "Encrypted code auto-close";
    private static final String PATTERN_STRING_GO_TO = "(?m)^Go to:\\s+(.+) at line ([0-9]+)";
    private static final Pattern PATTERN_GO_TO = Pattern.compile("(?m)^Go to:\\s+(.+) at line ([0-9]+)");
    private static final String LINE_QUALIFIER_GO_TO = "Go to:";
    private static final String PATTERN_STRING_INVOCATION = "(?m)^Invocation #[0-9]+ .*? in (.+) at line ([0-9]+(?:[,.][0-9]+)*)";
    private static final Pattern PATTERN_INVOCATION = Pattern.compile("(?m)^Invocation #[0-9]+ .*? in (.+) at line ([0-9]+(?:[,.][0-9]+)*)");
    private static final String LINE_QUALIFIER_INVOCATION = "Invocation #.*";
    private static final String PATTERN_STRING_TCL_DONE = "(?m)^\\s+TCL done (\\S+)";
    private static final Pattern PATTERN_TCL_DONE = Pattern.compile("(?m)^\\s+TCL done (\\S+)");
    private static final String LINE_QUALIFIER_TCL_DONE = "\\s+TCL done";
    private static final String PATTERN_STRING_TCL = "(?m)^\\s+TCL(?: \\w+)? (\\S+) @ ([0-9]+(?:[,.][0-9]+)*) : .*";
    private static final Pattern PATTERN_TCL = Pattern.compile("(?m)^\\s+TCL(?: \\w+)? (\\S+) @ ([0-9]+(?:[,.][0-9]+)*) : .*");
    private static final String LINE_QUALIFIER_TCL = "\\s+TCL";
    private static final String PATTERN_STRING_LINES_TOP_FILE = "(?m)^\\[[0-9]+ (?:lines), [0-9]+ (?:ms)\\] (.*)";
    private static final Pattern PATTERN_LINES_TOP_FILE = Pattern.compile("(?m)^\\[[0-9]+ (?:lines), [0-9]+ (?:ms)\\] (.*)");
    private static final String LINE_QUALIFIER_LINES_TOP_FILE = "\\[[0-9]+ (?:lines), [0-9]+ (?:ms)\\] ";
    private static final String PATTERN_STRING_TIME_TOP_FILE = "(?m)^\\[[0-9]+ (?:ms), [0-9]+ (?:lines)\\] (.*)";
    private static final Pattern PATTERN_TIME_TOP_FILE = Pattern.compile("(?m)^\\[[0-9]+ (?:ms), [0-9]+ (?:lines)\\] (.*)");
    private static final String LINE_QUALIFIER_TIME_TOP_FILE = "\\[[0-9]+ (?:ms), [0-9]+ (?:lines)\\] ";
    private static final String PATTERN_STRING_SPEED_TOP_FILE = "(?m)^\\[[0-9]+.[0-9]+ (?:lines/ms), [0-9]+ (?:lines), [0-9]+ (?:ms)\\] (.*)";
    private static final Pattern PATTERN_SPEED_TOP_FILE = Pattern.compile("(?m)^\\[[0-9]+.[0-9]+ (?:lines/ms), [0-9]+ (?:lines), [0-9]+ (?:ms)\\] (.*)");
    private static final String LINE_QUALIFIER_SPEED_TOP_FILE = "\\[[0-9]+.[0-9]+ (?:lines/ms), [0-9]+ (?:lines), [0-9]+ (?:ms)\\] ";
    private static final String PATTERN_STRING_PREPROCESSED_FILE = "(?m)^Computing preprocessed files prerequisites for\\s+(.+)\\s+\\.{3}";
    private static final Pattern PATTERN_PREPROCESSED_FILE = Pattern.compile("(?m)^Computing preprocessed files prerequisites for\\s+(.+)\\s+\\.{3}");
    private static final String LINE_QUALIFIER_PREPROCESSED_FILE = "Computing preprocessed files prerequisites for\\s+";
    public static final String CONSOLE_NAME_PREFIX = "DVT Internal Build Console for project";
    public static final String REPORT_CONSOLE_NAME_PREFIX = "DVT Internal Build Report Console for project";
    public static final String PRECOMPILED_CONSOLE_NAME_PREFIX = "DVT Internal Precompiled Database Rebuild Console for project";
    private static final Set<String> PATTERN_NAMES = new HashSet<String>(Arrays.asList("DVT Error Filter", "DVT Warning Filter", "GCC Error Filter", "GCC Warning Filter"));
    private static final Pattern PATTERN_TIME_INFO = Pattern.compile("\\s+\\[[0-9]+\\s+ms\\]");
    public static final String ERROR_MESSAGE_FORMAT = "*** Error: {0}\n    at line {1} in {2}{3}{4}";
    public static final String WARNING_MESSAGE_FORMAT = "*** Warning: {0}\n    at line {1} in {2}{3}{4}";
    private DVTMessageReportConsole fReportConsole;
    private IConsoleManager fConsoleManager;
    private MessageConsoleStream fOutputStream;
    private MessageConsoleStream fReportOutputStream;

    public DVTBuildConsole(IProject project) {
        this.fProject = project;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 14);
    }

    @Override
    public void clean() {
        super.clean();
        if (!PrecompiledDBUtils.wasBuildTriggeredAutomatically()) {
            this.clearConsole(this.fConsole);
            this.clearConsole(this.fReportConsole);
        }
        if (this.fConsole != null) {
            this.fConsole.activate();
        }
    }

    public void clearConsole() {
        this.clearConsole(this.fConsole);
        this.clearConsole(this.fReportConsole);
    }

    @Override
    public void buildConfigStart() {
        this.ensurePrefsInitialized();
    }

    @Override
    public void buildConfigEnded() {
        super.buildConfigEnded();
        if (this.fConsole != null) {
            this.setPatternsToConsole(this.fConsole);
            this.setProcessConsole(this.fConsole);
        }
        if (this.fReportConsole != null) {
            this.setPatternsToConsole(this.fReportConsole);
            this.setProcessConsole(this.fReportConsole);
        }
    }

    public void buildDone() {
        CompileWaiversManager.INSTANCE.reportNofProblemsWaivedByWaiver(this.fProject, DVTBuildConsoleCommon.MessageSink.FILE, false);
        this.printNofWaivedProblems();
        final Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (DVTBuildConsole.this.fMessageQueue != null && !DVTBuildConsole.this.fMessageQueue.isEmpty()) {
                    return;
                }
                try {
                    if (DVTBuildConsole.this.fLogWriter != null) {
                        DVTBuildConsole.this.fLogWriter.flush();
                    }
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                }
                try {
                    DVTBuildConsole.this.refreshLogFile();
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                }
                if (DVTBuildConsole.this.fReportConsole != null) {
                    DVTBuildConsole.this.removeReportConsole();
                }
                timer.cancel();
            }
        };
        timer.schedule(task, 100L, 100L);
        ObjectionManager.getInstance().clear(Objection.CONSOLE_OUTPUT_COMPLETE);
    }

    private void refreshLogFile() throws CoreException {
        File logFile = this.getLogFile();
        if (logFile == null) {
            return;
        }
        IPath projectLocation = this.fProject.getLocation();
        if (projectLocation == null) {
            return;
        }
        IPath logFilePath = Path.fromOSString((String)logFile.getAbsolutePath());
        if (!projectLocation.isPrefixOf(logFilePath)) {
            return;
        }
        IFile logIFile = this.fProject.getWorkspace().getRoot().getFileForLocation(logFilePath);
        if (logIFile == null) {
            return;
        }
        logIFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fProject.equals((Object)event.getResource()) && (event.getType() == 4 || event.getType() == 2)) {
            this.removeConsole();
            this.removeReportConsole();
            try {
                try {
                    DVTUtilsCommon.INSTANCE.closeClosable(this.fLogWriter);
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                    this.fLogWriter = null;
                }
            }
            finally {
                this.fLogWriter = null;
            }
        }
    }

    @Override
    protected void createBuildConsole() {
        try {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            this.fConsoleManager = plugin.getConsoleManager();
            this.fConsole = new DVTMessageConsole(this.fProject, "DVT Internal Build Console for project [" + this.fProject.getName() + "]", null, new DVTConsoleButtonsDescription(true, true, true));
            this.fConsoleManager.addConsoles(new IConsole[]{this.fConsole});
            this.fOutputStream = this.fConsole.newMessageStream();
            this.setPatternsToConsole(this.fConsole);
            this.setProcessConsole(this.fConsole);
            this.fConsole.activate();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void createReportConsole() {
        try {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            this.fConsoleManager = plugin.getConsoleManager();
            this.fReportConsole = new DVTMessageReportConsole(this.fProject, "DVT Internal Build Report Console for project [" + this.fProject.getName() + "]", null);
            this.fConsoleManager.addConsoles(new IConsole[]{this.fReportConsole});
            this.fReportOutputStream = this.fReportConsole.newMessageStream();
            this.setPatternsToConsole(this.fReportConsole);
            this.setProcessConsole(this.fReportConsole);
            this.fReportConsole.activate();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public DVTPrecompiledDatabaseRebuildConsole createPrecompiledRebuildConsole(Invocation invocation) {
        try {
            DVTPrecompiledDatabaseRebuildConsole invocationConsole;
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            this.fConsoleManager = plugin.getConsoleManager();
            if (this.fPrecompiledRebuildConsoles == null) {
                this.fPrecompiledRebuildConsoles = new HashMap();
            }
            if ((invocationConsole = (DVTPrecompiledDatabaseRebuildConsole)((Object)this.fPrecompiledRebuildConsoles.get(invocation))) == null) {
                invocationConsole = new DVTPrecompiledDatabaseRebuildConsole(this.fProject, "DVT Internal Precompiled Database Rebuild Console for project [" + this.fProject.getName() + "] [Invocation " + invocation.getState().invocationNumber + "]", null);
                this.fPrecompiledRebuildConsoles.put(invocation, invocationConsole);
            }
            this.fConsoleManager.addConsoles(new IConsole[]{invocationConsole});
            this.setPatternsToConsole(invocationConsole);
            this.setProcessConsole(invocationConsole);
            return invocationConsole;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void setProcessConsole(DVTMessageConsole console) {
        ExternalToolsConfiguration config = new ExternalToolsConfiguration();
        ExternalToolsModelManager.getInstance().setProcessConsole((IConsole)console, this.fProject, config, null, 1, this.fProject.getLocation().toOSString());
    }

    private void setPatternsToConsole(DVTMessageConsole console) {
        LinkedList<ConsoleListener> consoleListeners = new LinkedList<ConsoleListener>();
        consoleListeners.add(new ConsoleListener(PATTERN_DONE, LINE_QUALIFIER_DONE, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_SIMPLE_PATH, LINE_QUALIFIER_SIMPLE_PATH, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_LOAD, LINE_QUALIFIER_LOAD, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_LOAD_TEST, LINE_QUALIFIER_LOAD_TEST, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_SCAN, LINE_QUALIFIER_SCAN, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_SKIP, LINE_QUALIFIER_SKIP, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_OPTIMIZING, LINE_QUALIFIER_OPTIMIZING, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_CMD_FILE_CALL, "-.*|Build", this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_INCLUDE_CONFIG_CALL, "-.*|Build", this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_BUILD_LOG, LINE_QUALIFIER_BUILD_LOG, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_INVOCATION, LINE_QUALIFIER_INVOCATION, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_CMD_FILE_IMPORTED, LINE_QUALIFIER_CMD_FILE_IMPORTED, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_GO_TO, LINE_QUALIFIER_GO_TO, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_AUTO_DEFINE, LINE_QUALIFIER_AUTO_DEFINE, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_AUTO_MACRO, LINE_QUALIFIER_AUTO_MACRO, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_AUTO_CLOSE, LINE_QUALIFIER_AUTO_ClOSE, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_TCL_DONE, LINE_QUALIFIER_TCL_DONE, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_TCL, LINE_QUALIFIER_TCL, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_LINES_TOP_FILE, LINE_QUALIFIER_LINES_TOP_FILE, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_TIME_TOP_FILE, LINE_QUALIFIER_TIME_TOP_FILE, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_SPEED_TOP_FILE, LINE_QUALIFIER_SPEED_TOP_FILE, this.fProject));
        consoleListeners.add(new ConsoleListener(PATTERN_PREPROCESSED_FILE, LINE_QUALIFIER_PREPROCESSED_FILE, this.fProject));
        ConsoleHighlightModelManager.getInstance().fConsoleToListeners.putIfAbsent((IConsole)console, new ConcurrentLinkedQueue());
        Queue<IConsoleScanListener> listeners = ConsoleHighlightModelManager.getInstance().fConsoleToListeners.get((Object)console);
        for (IConsoleScanListener iConsoleScanListener : consoleListeners) {
            if (listeners.contains(iConsoleScanListener)) continue;
            listeners.add(iConsoleScanListener);
            console.addPatternMatchListener(iConsoleScanListener);
        }
    }

    private void clearConsole(DVTMessageConsole console) {
        if (console == null) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(() -> {
            console.clearConsole();
            ExternalToolsModelManager.fAppliedPatterns.clear();
            ExternalToolsModelManager.fAppliedProblemsPatterns.clear();
        });
    }

    @Override
    protected void removeConsole() {
        try {
            if (this.fConsole != null) {
                this.fConsole.clearConsole();
                this.fConsoleManager.removeConsoles(new IConsole[]{this.fConsole});
                this.fConsole = null;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void removeReportConsole() {
        try {
            if (this.fReportConsole != null) {
                this.fReportConsole.clearConsole();
                this.fConsoleManager.removeConsoles(new IConsole[]{this.fReportConsole});
                this.fReportConsole = null;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void printProblem(DVTProblem problem) {
        String messageFormat = problem.getSeverity() == Severity.ERROR ? ERROR_MESSAGE_FORMAT : WARNING_MESSAGE_FORMAT;
        Object[] objectArray = new Object[5];
        objectArray[0] = problem.getMessage();
        objectArray[1] = Integer.toString(problem.getLine());
        objectArray[2] = problem.getPath();
        Object object = objectArray[3] = problem.getFileIndex() != -1 ? " [compile index " + problem.getFileIndex() + "]" : "";
        objectArray[4] = problem.getInvocationNumber() != -1 ? String.valueOf(problem.getFileIndex() != -1 ? "" : " ") + "[invocation " + problem.getInvocationNumber() + "]" : "";
        String formattedMessage = MessageFormat.format(messageFormat, objectArray);
        if (problem.getSeverity() == Severity.WARNING) {
            this.print(formattedMessage, DVTBuildConsoleCommon.MessageSink.FILE);
            ObjectionManager.getInstance().clear(Objection.CONSOLE_OUTPUT_COMPLETE);
            return;
        }
        LanguageKind languageKind = this.getLanguageKind(problem);
        if (languageKind == null) {
            return;
        }
        this.fNofErrors.put(languageKind, (Integer)this.fNofErrors.get((Object)languageKind) + 1);
        DVTBuildConsoleCommon.MessageSink sink = (Integer)this.fNofErrors.get((Object)languageKind) > 20 ? DVTBuildConsoleCommon.MessageSink.FILE : DVTBuildConsoleCommon.MessageSink.REPORT;
        this.print(formattedMessage, sink);
        ObjectionManager.getInstance().clear(Objection.CONSOLE_OUTPUT_COMPLETE);
    }

    @Override
    protected void scheduleProcessMessages() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            while (!this.fMessageQueue.isEmpty()) {
                DVTBuildConsoleCommon.Message m = (DVTBuildConsoleCommon.Message)this.fMessageQueue.poll();
                if (m == null) continue;
                try {
                    if (m.sink.ordinal() >= DVTBuildConsoleCommon.MessageSink.REPORT.ordinal()) {
                        this.fReportModel.addMessage(m.messageText);
                    }
                    if (this.fPrefs.toConsole && this.fConsole != null && this.fOutputStream != null && !this.fOutputStream.isClosed() && m.sink.ordinal() >= DVTBuildConsoleCommon.MessageSink.CONSOLE.ordinal()) {
                        this.fOutputStream.println(m.messageText);
                        this.fOutputStream.flush();
                    }
                    if (!this.fPrefs.toFile || this.fLogWriter == null || m.sink.ordinal() < DVTBuildConsoleCommon.MessageSink.FILE.ordinal()) continue;
                    this.fLogWriter.write(m.messageText);
                    this.fLogWriter.newLine();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    public void showBuildConsole() {
        if (this.fConsole == null) {
            return;
        }
        this.fConsole.activate();
    }

    public void printBuildReport(boolean activate) {
        if (this.fReportConsole == null && this.fPrefs.toConsole) {
            this.createReportConsole();
        }
        if (this.fReportConsole == null) {
            return;
        }
        if (activate) {
            this.fReportConsole.activate();
        }
        if (!this.fPrefs.toConsole) {
            this.removeReportConsole();
            return;
        }
        this.fReportModel.setPrefs(this.fPrefs);
        this.fReportModel.setProject(this.fProject);
        this.fReportModel.printBuildReport(this.fReportOutputStream, this.fPrefs, this.fNofWaivedProblems, this.fNofErrors);
        try {
            this.fReportOutputStream.flush();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String toString() {
        return "DVTBuildConsole [fProject=" + this.fProject + ", " + this.fPrefs + "]";
    }

    static class ConsoleListener
    implements IConsoleScanListener {
        private TextConsole fTextConsole;
        private Pattern fPattern;
        private String fLineQualifier;
        private TextConsoleViewer fConsoleViewer;
        private IProject fProject;

        ConsoleListener(Pattern pattern, String lineQualifier, IProject project) {
            this.fPattern = pattern;
            this.fLineQualifier = lineQualifier;
            this.fProject = project;
        }

        @Override
        public TextConsole getConsole() {
            return this.fTextConsole;
        }

        @Override
        public TextConsoleViewer getConsoleViewer() {
            return this.fConsoleViewer;
        }

        public void connect(TextConsole console) {
            this.fTextConsole = console;
        }

        public void disconnect() {
            this.fTextConsole = null;
            this.fConsoleViewer = null;
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return this.fLineQualifier;
        }

        public String getPattern() {
            return this.fPattern.pattern();
        }

        @Override
        public Pattern getWholePattern() {
            return this.fPattern;
        }

        @Override
        public void addHyperlink(int offset, int length) {
            try {
                IDocument document = this.fTextConsole.getDocument();
                String filePath = "";
                int lineNumber = 0;
                String text = document.get(offset, length);
                if (text.startsWith("***") && text.endsWith("***")) {
                    return;
                }
                Matcher m = this.fPattern.matcher(text);
                if (!m.matches() || m.groupCount() < 1) {
                    return;
                }
                filePath = m.group(1);
                if (m.groupCount() >= 2) {
                    lineNumber = DVTStringUtil.parseInt(m.group(2), 0);
                }
                offset += m.start(1);
                length = filePath.length();
                m = PATTERN_TIME_INFO.matcher(filePath);
                if (m.find()) {
                    filePath = filePath.substring(0, m.start());
                    length = filePath.length();
                }
                if (this.fProject == null) {
                    return;
                }
                ((DVTMessageConsole)this.fTextConsole).addHyperlink(new DVTMessageConsole.DummyHyperlinkLineContainer(lineNumber == 0 ? 1 : lineNumber), offset, length);
            }
            catch (Exception exception) {}
        }

        @Override
        public void setConsoleViewer(TextConsoleViewer newConsoleViewer) {
            this.fConsoleViewer = newConsoleViewer;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fPattern == null ? 0 : this.fPattern.hashCode());
            result = 31 * result + (this.fProject == null ? 0 : this.fProject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConsoleListener other = (ConsoleListener)obj;
            if (this.fPattern == null ? other.fPattern != null : !this.fPattern.equals(other.fPattern)) {
                return false;
            }
            return !(this.fProject == null ? other.fProject != null : !this.fProject.equals((Object)other.fProject));
        }
    }

    private final class ExternalToolsConfiguration
    implements IExternalToolsConfiguration {
        private ExternalToolsConfiguration() {
        }

        @Override
        public void setWorkingDir(String workingDir) {
        }

        @Override
        public void setWSLink(boolean wSLink) {
        }

        @Override
        public void setPatterns(ExternalToolsPattern[] patterns) {
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public void setFullCommand(String fullCommand) {
        }

        @Override
        public void setFilterKinds(String[] filterKinds) {
        }

        @Override
        public void setEnable(boolean builderEnable) {
        }

        @Override
        public void setCleanCommand(String cleanCommand) {
        }

        @Override
        public void setAutoCommand(String autoCommand) {
        }

        @Override
        public boolean isWSLink() {
            return false;
        }

        @Override
        public String getWorkingDir() {
            return null;
        }

        @Override
        public ExternalToolsPattern[] getPatterns() {
            ArrayList<ExternalToolsPattern> result = new ArrayList<ExternalToolsPattern>();
            List<ExternalToolsPattern> patterns = ExternalToolsUtil.getCategoryPatterns("Specman");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            patterns = ExternalToolsUtil.getCategoryPatterns("GCC");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            patterns = ExternalToolsUtil.getCategoryPatterns("DVT");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            return result.toArray(result.toArray(new ExternalToolsPattern[result.size()]));
        }

        @Override
        public String getName() {
            return "[" + DVTBuildConsole.this.fProject + "] Build Console";
        }

        @Override
        public String getFullCommand() {
            return null;
        }

        @Override
        public String[] getFilterKinds() {
            return new String[0];
        }

        @Override
        public boolean getEnable() {
            return false;
        }

        @Override
        public String getConfigurationType() {
            return null;
        }

        @Override
        public String getCleanCommand() {
            return null;
        }

        @Override
        public String getAutoCommand() {
            return null;
        }

        @Override
        public boolean getAttribute(String attributeName, boolean defaultValue) {
            return false;
        }

        @Override
        public int getAttribute(String attributeName, int defaultValue) {
            return 0;
        }

        @Override
        public String getAttribute(String attributeName, String defaultValue) {
            return null;
        }

        @Override
        public List getAttribute(String attributeName, List defaultValue) {
            return null;
        }

        @Override
        public Set getAttribute(String attributeName, Set defaultValue) {
            return null;
        }

        @Override
        public Map getAttribute(String attributeName, Map defaultValue) {
            return null;
        }

        @Override
        public void setAttribute(String attributeName, Object attributeValue) {
        }

        @Override
        public void removeAttribute(String attributeName) {
        }

        @Override
        public boolean hasAttribute(String attributeName) {
            return false;
        }

        @Override
        public Map getAttributes() {
            return null;
        }

        @Override
        public void setAttributes(Map attributes) {
        }

        @Override
        public IExternalToolsConfiguration getWorkingCopy() {
            return this;
        }
    }
}

