/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.builders;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildReportPrefs;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTBuildReportModel;
import ro.amiq.dvt.builders.DVTMessageConsole;
import ro.amiq.dvt.builders.DVTPrecompiledDatabaseRebuildConsole;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemWaiver;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public abstract class DVTBuildConsoleCommon {
    public static final String MEMORY_MONITOR_CONSOLE_WARNING_MESSAGE_FORMAT = String.valueOf(System.lineSeparator()) + System.lineSeparator() + "*** Warning: {0}" + System.lineSeparator() + System.lineSeparator();
    public static final String MEMORY_MONITOR_CONSOLE_ERROR_MESSAGE_FORMAT = String.valueOf(System.lineSeparator()) + System.lineSeparator() + "*** Error: {0}" + System.lineSeparator() + System.lineSeparator();
    private static final String START_SECTION_FORMAT = String.valueOf(System.lineSeparator()) + "*** {0} ***";
    public static final String SECTION_FORMAT = "*** {0} ***";
    protected static final int MAX_ERRORS_IN_CONSOLE = 20;
    protected IProject fProject;
    protected DVTMessageConsole fConsole;
    protected BuildReportPrefs fPrefs;
    protected ConcurrentLinkedQueue<Message> fMessageQueue = new ConcurrentLinkedQueue();
    protected BufferedWriter fLogWriter;
    public static final String BUILD_LOG_FILE_NAME = "dvt_build.log";
    private boolean fHasFatalPersistentError;
    protected DVTBuildReportModel fReportModel = new DVTBuildReportModel();
    protected Map<Invocation, DVTPrecompiledDatabaseRebuildConsole> fPrecompiledRebuildConsoles;
    protected Map<LanguageKind, Integer> fNofWaivedProblems = new EnumMap<LanguageKind, Integer>(LanguageKind.class);
    protected Map<LanguageKind, Integer> fNofErrors = new EnumMap<LanguageKind, Integer>(LanguageKind.class);

    public DVTBuildConsoleCommon() {
        LanguageKind[] languageKindArray = LanguageKind.values();
        int n = languageKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageKind lk = languageKindArray[n2];
            this.fNofErrors.put(lk, 0);
            this.fNofWaivedProblems.put(lk, 0);
            ++n2;
        }
    }

    public void print(String message) {
        this.print(message, MessageSink.CONSOLE);
    }

    public void print(String message, MessageSink sink) {
        this.fMessageQueue.add(new Message(message, sink));
        if (this.fPrefs == null || !this.fPrefs.getFinishedReading()) {
            return;
        }
        this.initSinks();
        this.scheduleProcessMessages();
    }

    public DVTBuildReportModel getReportModel() {
        return this.fReportModel;
    }

    protected LanguageKind getLanguageKind(DVTProblem problem) {
        DVTProblemCategory category = problem.getCategory();
        if (category == null) {
            return null;
        }
        return category.getLanguageKind();
    }

    protected void initSinks() {
        if (this.fHasFatalPersistentError) {
            return;
        }
        if (this.fConsole == null && this.fPrefs.toConsole) {
            this.createBuildConsole();
        }
        if (!this.fPrefs.toConsole) {
            this.removeConsole();
        }
        File logFile = this.getLogFile();
        if (this.fPrefs.toFile && this.fLogWriter == null && logFile != null) {
            try {
                this.fLogWriter = new BufferedWriter(new FileWriter(logFile));
            }
            catch (FileNotFoundException e) {
                if (this.fHasFatalPersistentError) {
                    return;
                }
                this.fHasFatalPersistentError = true;
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if (message != null && (message.contains("(Permission denied)") || message.contains("(Read-only file system)"))) {
                    if (this.fHasFatalPersistentError) {
                        return;
                    }
                    this.fHasFatalPersistentError = true;
                }
                DVTLogger.INSTANCE.logError(e);
            }
        }
    }

    public void printWaiving(DVTProblem problem, DVTProblemWaiver waiver) {
        LanguageKind lk = this.getLanguageKind(problem);
        if (lk == null) {
            return;
        }
        this.fNofWaivedProblems.put(lk, this.fNofWaivedProblems.get((Object)lk) + 1);
        this.print("Waive [" + problem.toString() + "] by [" + waiver.toString() + "]", MessageSink.FILE);
    }

    public void printNofWaivedProblems() {
        File logFile = this.getLogFile();
        if (logFile == null) {
            return;
        }
        int nofWaivedProblems = this.fNofWaivedProblems.values().stream().mapToInt(x -> x).sum();
        if (nofWaivedProblems > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("There are ").append(nofWaivedProblems).append(" waived problems. ");
            if (this.fPrefs.toFile) {
                sb.append("Check the build log file for details:\n").append(logFile.getAbsolutePath());
            } else {
                sb.append("\nWriting build log is disabled, remove the +dvt_build_log_to_file+false directive from the active build file to enable it.\n");
            }
            this.print(sb.toString());
        }
    }

    protected void ensurePrefsInitialized() {
        if (this.fPrefs == null) {
            this.fPrefs = new BuildReportPrefs(true, true, this.getProjectLocation());
        }
    }

    public void setBuildLogFileLocation(String location) {
        this.ensurePrefsInitialized();
        this.fPrefs.logLocation = location;
    }

    public void setBuildLogToConsole(Boolean toConsole) {
        this.ensurePrefsInitialized();
        this.fPrefs.toConsole = toConsole;
    }

    public void setBuildLogToFile(Boolean toFile) {
        this.ensurePrefsInitialized();
        this.fPrefs.toFile = toFile;
    }

    public void buildConfigEnded() {
        this.ensurePrefsInitialized();
        this.fPrefs.setFinishedReading(true);
    }

    public File getLogFile() {
        if (this.fPrefs == null) {
            return null;
        }
        if (this.fPrefs.logLocation == null) {
            return null;
        }
        return new File(this.fPrefs.logLocation, BUILD_LOG_FILE_NAME);
    }

    public Map<Invocation, DVTPrecompiledDatabaseRebuildConsole> getPrecompiledRebuildConsoles() {
        return this.fPrecompiledRebuildConsoles;
    }

    public void clean() {
        block8: {
            if (!PrecompiledDBUtils.wasBuildTriggeredAutomatically()) {
                this.fReportModel.clear();
            }
            this.fPrefs = null;
            this.fMessageQueue.clear();
            if (this.fLogWriter != null) {
                try {
                    try {
                        DVTUtilsCommon.INSTANCE.closeClosable(this.fLogWriter);
                    }
                    catch (Throwable e) {
                        DVTLogger.INSTANCE.logError(e);
                        this.fLogWriter = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.fLogWriter = null;
                    throw throwable;
                }
                this.fLogWriter = null;
            }
        }
        LanguageKind[] languageKindArray = LanguageKind.values();
        int n = languageKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageKind lk = languageKindArray[n2];
            this.fNofErrors.put(lk, 0);
            this.fNofWaivedProblems.put(lk, 0);
            ++n2;
        }
    }

    public void printSection(String message) {
        this.print(MessageFormat.format(SECTION_FORMAT, message), MessageSink.REPORT);
    }

    public void printSection(String message, MessageSink sink) {
        this.print(MessageFormat.format(SECTION_FORMAT, message), sink);
    }

    public void printStartSection(String message) {
        this.print(MessageFormat.format(START_SECTION_FORMAT, message), MessageSink.REPORT);
    }

    protected abstract void scheduleProcessMessages();

    protected abstract void createBuildConsole();

    protected abstract void removeConsole();

    public void buildAutoConfigStart() {
        this.ensurePrefsInitialized();
        this.fPrefs.setFinishedReading(true);
    }

    public void buildConfigStart() {
    }

    protected String getProjectLocation() {
        return this.fProject.getLocation().toOSString();
    }

    public boolean isBuildLogToFile() {
        if (this.fPrefs == null) {
            return false;
        }
        return this.fPrefs.toFile;
    }

    protected static class Message {
        String messageText;
        MessageSink sink;

        public Message(String message, MessageSink sink) {
            this.messageText = message;
            this.sink = sink;
        }
    }

    public static enum MessageSink {
        FILE,
        CONSOLE,
        REPORT;

    }
}

