/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.builders;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.console.MessageConsoleStream;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildReportPrefs;
import ro.amiq.dvt.builders.TopStatsFileInfo;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.model.problems.PSSProblemCategories;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;

public class DVTBuildReportModel {
    private static final String SECTION_FORMAT = "*** {0} ***";
    public static final String ERROR_MESSAGE_FORMAT = "*** Error: {0}\n    at line {1} in {2}{3}{4}" + System.lineSeparator();
    public static final String BUILD_LOG_FILE_NAME = "dvt_build.log";
    private static final int MAX_ERRORS_IN_REPORT = 10;
    private static final int MAX_FILES_IN_TOP = 10;
    private IProject fProject;
    private List<String> fBuildReport = new ArrayList<String>();
    private int fTotalNumberOfFiles;
    private int fNonZeroTimeNumberOfFiles;
    private int fTotalNumberOfLines;
    private int fTotalCompilationTime;
    private float fCompilationSpeedSum;
    private TreeMap<Long, List<TopStatsFileInfo>> fTopFilesByCompileTime = new TreeMap();
    private TreeMap<Long, List<TopStatsFileInfo>> fTopVFilesByCompileTime = new TreeMap();
    private TreeMap<Integer, List<TopStatsFileInfo>> fTopFilesByNofLines = new TreeMap();
    private TreeMap<Float, List<TopStatsFileInfo>> fTopFilesByCompilationSpeed = new TreeMap();
    private ConcurrentLinkedQueue<DVTProblem> fSyntaxErrorsInProject = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DVTProblem> fSemanticErrorsInProject = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DVTProblem> fConfigErrorsInProject = new ConcurrentLinkedQueue();
    private int fNofConfigErrors;
    private int fNofSemanticErrors;
    private int fNofSyntaxErrors;
    private BuildReportPrefs fPrefs;

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void setPrefs(BuildReportPrefs prefs) {
        this.fPrefs = prefs;
    }

    public void addMessage(String message) {
        this.fBuildReport.add(message);
    }

    public void clear() {
        this.fBuildReport.clear();
        this.fTotalNumberOfFiles = 0;
        this.fTotalNumberOfLines = 0;
        this.fTotalCompilationTime = 0;
        this.fCompilationSpeedSum = 0.0f;
        this.fNonZeroTimeNumberOfFiles = 0;
        this.fTopFilesByCompileTime.clear();
        this.fTopVFilesByCompileTime.clear();
        this.fTopFilesByNofLines.clear();
        this.fTopFilesByCompilationSpeed.clear();
        this.fSyntaxErrorsInProject.clear();
        this.fSemanticErrorsInProject.clear();
        this.fConfigErrorsInProject.clear();
        this.fNofSemanticErrors = 0;
        this.fNofSyntaxErrors = 0;
        this.fNofConfigErrors = 0;
    }

    public void printBuildReport(MessageConsoleStream fReportOutputStream, BuildReportPrefs fPrefs, Map<LanguageKind, Integer> fNofWaivedProblems, Map<LanguageKind, Integer> fNofErrors) {
        int nofLines;
        String path;
        List<TopStatsFileInfo> files;
        if (fReportOutputStream == null || fReportOutputStream.isClosed()) {
            return;
        }
        fReportOutputStream.println("********************************************************************************");
        fReportOutputStream.println("BUILD REPORT FOR PROJECT " + this.fProject.getName());
        fReportOutputStream.println("********************************************************************************");
        for (String string : this.fBuildReport) {
            fReportOutputStream.println(string);
        }
        fReportOutputStream.println();
        fReportOutputStream.println(MessageFormat.format(SECTION_FORMAT, "Top files by compile time"));
        for (Long l : this.fTopFilesByCompileTime.descendingKeySet()) {
            files = this.fTopFilesByCompileTime.get(l);
            if (files == null || files.isEmpty()) continue;
            for (TopStatsFileInfo topStatsFileInfo : files) {
                path = topStatsFileInfo.getParserPath().path;
                nofLines = topStatsFileInfo.getNofRawLines();
                fReportOutputStream.println("[" + l + " ms, " + nofLines + " lines] " + path);
            }
        }
        fReportOutputStream.println();
        fReportOutputStream.println(MessageFormat.format(SECTION_FORMAT, "Top files by number of lines"));
        for (Integer n : this.fTopFilesByNofLines.descendingKeySet()) {
            files = this.fTopFilesByNofLines.get(n);
            if (files == null || files.isEmpty()) continue;
            for (TopStatsFileInfo topStatsFileInfo : files) {
                path = topStatsFileInfo.getParserPath().path;
                long time = topStatsFileInfo.getTime();
                fReportOutputStream.println("[" + n + " lines, " + time + " ms] " + path);
            }
        }
        if (!this.fTopFilesByCompilationSpeed.isEmpty()) {
            fReportOutputStream.println();
            fReportOutputStream.println(MessageFormat.format(SECTION_FORMAT, "Top files by compile speed"));
            for (Map.Entry entry : this.fTopFilesByCompilationSpeed.entrySet()) {
                if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                for (TopStatsFileInfo fileInfo : (List)entry.getValue()) {
                    String path2 = fileInfo.getParserPath().path;
                    fReportOutputStream.println("[" + String.format("%.2f", entry.getKey()) + " lines/ms, " + fileInfo.getNofRawLines() + " lines, " + fileInfo.getTime() + " ms] " + path2);
                }
            }
        }
        if (!this.fTopVFilesByCompileTime.isEmpty()) {
            fReportOutputStream.println();
            fReportOutputStream.println(MessageFormat.format(SECTION_FORMAT, "Top -v files by compile time"));
            for (Long l : this.fTopVFilesByCompileTime.descendingKeySet()) {
                files = this.fTopVFilesByCompileTime.get(l);
                if (files == null || files.isEmpty()) continue;
                for (TopStatsFileInfo topStatsFileInfo : files) {
                    path = topStatsFileInfo.getParserPath().path;
                    nofLines = topStatsFileInfo.getNofRawLines();
                    fReportOutputStream.println("[" + l + " ms, " + nofLines + " lines] " + path);
                }
            }
        }
        fReportOutputStream.println();
        fReportOutputStream.println("Average compilation speed per file: " + String.format("%.2f", Float.valueOf(this.computeAverageCompilationSpeedPerFile())) + " lines/ms");
        fReportOutputStream.println("Average compilation speed: " + String.format("%.2f", Float.valueOf(this.computeAverageCompilationSpeed())) + " lines/ms");
        fReportOutputStream.println();
        fReportOutputStream.println("Total number of files: " + this.fTotalNumberOfFiles);
        fReportOutputStream.println("Total number of lines: " + this.fTotalNumberOfLines);
        String string = this.printErrorSummary(fPrefs, fNofWaivedProblems, fNofErrors);
        fReportOutputStream.println(string);
        try {
            fReportOutputStream.flush();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String printErrorSummary(BuildReportPrefs fPrefs, Map<LanguageKind, Integer> fNofWaivedProblems, Map<LanguageKind, Integer> fNofErrors) {
        StringBuilder message = new StringBuilder();
        LanguageKind[] languageKindArray = LanguageKind.values();
        int n = languageKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                LanguageKind lk;
                block11: {
                    lk = languageKindArray[n2];
                    try {
                        if (this.fProject.hasNature(lk.NATURE_ID)) break block11;
                        break block12;
                    }
                    catch (CoreException coreException) {}
                }
                message.append("Total number of " + lk.DISPLAY_NAME + " errors: " + fNofErrors.get((Object)lk));
                if (fNofErrors.get((Object)lk) > DVTProblemsUiUpdater.MAX_MARKERS_PER_PROBLEM_CATEGORY) {
                    message.append(". For performance reasons, after applying the waivers, the Problems View will present only max " + DVTProblemsUiUpdater.MAX_MARKERS_PER_PROBLEM_CATEGORY + " items per category (Syntax Errors, Syntax Warnings, Semantic Errors, etc.)");
                }
                if (fNofWaivedProblems.get((Object)lk) > 0) {
                    message.append(". There were " + fNofWaivedProblems.get((Object)lk) + " waived problems.\n");
                } else {
                    message.append(".\n");
                }
            }
            ++n2;
        }
        File logFile = this.getLogFile();
        if (logFile == null) {
            return message.toString();
        }
        int nofWaivedProblems = fNofWaivedProblems.values().stream().mapToInt(x -> x).sum();
        if (nofWaivedProblems == 0) {
            message.append("Check the build log file for complete build information:\n");
            message.append(logFile.getAbsolutePath());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("There are ").append(nofWaivedProblems).append(" waived problems. ");
            if (fPrefs.toFile) {
                sb.append("Check the build log file for details:\n").append(logFile.getAbsolutePath());
            } else {
                sb.append("\nWriting build log is disabled, remove the +dvt_build_log_to_file+false directive from the active build file to enable it.\n");
            }
            message.append(sb.toString());
        }
        return message.toString();
    }

    public File getLogFile() {
        if (this.fPrefs == null) {
            return null;
        }
        if (this.fPrefs.logLocation == null) {
            return null;
        }
        return new File(this.fPrefs.logLocation, BUILD_LOG_FILE_NAME);
    }

    public Map<Long, List<TopStatsFileInfo>> getTopFilesByCompileTime() {
        return this.fTopFilesByCompileTime;
    }

    public Map<Integer, List<TopStatsFileInfo>> getTopFilesByNofLines() {
        return this.fTopFilesByNofLines;
    }

    public Map<Float, List<TopStatsFileInfo>> getTopFilesByCompilationSpeed() {
        return this.fTopFilesByCompilationSpeed;
    }

    public void updateTopStatsForProject(ParserPath parserPath, int nofRawLines, long time) {
        this.updateTopStatsForProject(parserPath, nofRawLines, time, false);
    }

    public void updateTopStatsForProject(ParserPath parserPath, int nofRawLines, long time, boolean isVFile) {
        TopStatsFileInfo fileInfo = new TopStatsFileInfo(parserPath, nofRawLines, time);
        ++this.fTotalNumberOfFiles;
        this.fTotalNumberOfLines += nofRawLines;
        this.fTotalCompilationTime = (int)((long)this.fTotalCompilationTime + time);
        if (time > 0L) {
            ++this.fNonZeroTimeNumberOfFiles;
            this.fCompilationSpeedSum += fileInfo.getCompilationSpeed();
        }
        if (!isVFile) {
            this.computeTopFilesByCompilationTime(fileInfo);
            this.computeTopFilesByNofLines(fileInfo);
            this.computeTopFilesByCompilationSpeed(fileInfo);
        } else {
            this.computeTopVFilesByCompilationTime(fileInfo);
        }
    }

    private void computeTopFilesByCompilationTime(TopStatsFileInfo fileInfo) {
        boolean alreadyComputed = this.checkAlreadyComputedFile(fileInfo);
        if (alreadyComputed) {
            return;
        }
        List<TopStatsFileInfo> filesByTime = this.fTopFilesByCompileTime.get(fileInfo.getTime());
        if (filesByTime != null) {
            filesByTime.add(fileInfo);
            this.fTopFilesByCompileTime.put(fileInfo.getTime(), filesByTime);
            return;
        }
        filesByTime = new ArrayList<TopStatsFileInfo>();
        filesByTime.add(fileInfo);
        if (this.fTopFilesByCompileTime.size() < 10) {
            this.fTopFilesByCompileTime.put(fileInfo.getTime(), filesByTime);
            return;
        }
        long timeInSmallestFileInTree = this.fTopFilesByCompileTime.firstKey();
        if (timeInSmallestFileInTree < fileInfo.getTime()) {
            this.fTopFilesByCompileTime.remove(timeInSmallestFileInTree);
            this.fTopFilesByCompileTime.put(fileInfo.getTime(), filesByTime);
        }
    }

    private boolean checkAlreadyComputedFile(TopStatsFileInfo fileInfo) {
        Long oldTime = null;
        int indexOfOldFile = -1;
        for (Map.Entry<Long, List<TopStatsFileInfo>> entry : this.fTopFilesByCompileTime.entrySet()) {
            Long key = entry.getKey();
            List<TopStatsFileInfo> filesList = entry.getValue();
            if (filesList == null || !filesList.contains(fileInfo)) continue;
            indexOfOldFile = filesList.indexOf(fileInfo);
            TopStatsFileInfo oldFile = filesList.get(indexOfOldFile);
            if (oldFile.getTime() >= fileInfo.getTime()) {
                return true;
            }
            oldTime = key;
            break;
        }
        if (oldTime == null) {
            return false;
        }
        List<TopStatsFileInfo> filesList = this.fTopFilesByCompileTime.get(oldTime);
        filesList.remove(indexOfOldFile);
        if (filesList.isEmpty()) {
            this.fTopFilesByCompileTime.remove(oldTime);
        }
        return false;
    }

    private void computeTopVFilesByCompilationTime(TopStatsFileInfo fileInfo) {
        boolean alreadyComputed = this.fTopVFilesByCompileTime.values().stream().anyMatch(l -> l.stream().anyMatch(fi -> fi.equals(fileInfo)));
        if (alreadyComputed) {
            return;
        }
        List<TopStatsFileInfo> filesByTime = this.fTopVFilesByCompileTime.get(fileInfo.getTime());
        if (filesByTime != null) {
            filesByTime.add(fileInfo);
            this.fTopVFilesByCompileTime.put(fileInfo.getTime(), filesByTime);
            return;
        }
        filesByTime = new ArrayList<TopStatsFileInfo>();
        filesByTime.add(fileInfo);
        if (this.fTopVFilesByCompileTime.size() < 10) {
            this.fTopVFilesByCompileTime.put(fileInfo.getTime(), filesByTime);
            return;
        }
        long timeInSmallestFileInTree = this.fTopVFilesByCompileTime.firstKey();
        if (timeInSmallestFileInTree < fileInfo.getTime()) {
            this.fTopVFilesByCompileTime.remove(timeInSmallestFileInTree);
            this.fTopVFilesByCompileTime.put(fileInfo.getTime(), filesByTime);
        }
    }

    private void computeTopFilesByNofLines(TopStatsFileInfo fileInfo) {
        List<TopStatsFileInfo> topFilesByNofLines = this.fTopFilesByNofLines.get(fileInfo.getNofRawLines());
        if (topFilesByNofLines != null) {
            for (TopStatsFileInfo file : topFilesByNofLines) {
                if (!file.getParserPath().equals(fileInfo.getParserPath())) continue;
                if (file.getTime() >= fileInfo.getTime()) {
                    return;
                }
                topFilesByNofLines.remove(topFilesByNofLines.indexOf(file));
                topFilesByNofLines.add(fileInfo);
                this.fTopFilesByNofLines.put(fileInfo.getNofRawLines(), topFilesByNofLines);
                return;
            }
            topFilesByNofLines.add(fileInfo);
            this.fTopFilesByNofLines.put(fileInfo.getNofRawLines(), topFilesByNofLines);
            return;
        }
        topFilesByNofLines = new ArrayList<TopStatsFileInfo>();
        topFilesByNofLines.add(fileInfo);
        if (this.fTopFilesByNofLines.size() < 10) {
            this.fTopFilesByNofLines.put(fileInfo.getNofRawLines(), topFilesByNofLines);
            return;
        }
        int nofLinesInSmallestFileInTree = this.fTopFilesByNofLines.firstKey();
        if (nofLinesInSmallestFileInTree < fileInfo.getNofRawLines()) {
            this.fTopFilesByNofLines.remove(nofLinesInSmallestFileInTree);
            this.fTopFilesByNofLines.put(fileInfo.getNofRawLines(), topFilesByNofLines);
        }
    }

    private void computeTopFilesByCompilationSpeed(TopStatsFileInfo fileInfo) {
        boolean alreadyComputed = this.checkAlreadyComputedFileBySpeed(fileInfo);
        if (alreadyComputed) {
            return;
        }
        float compilationSpeed = fileInfo.getCompilationSpeed();
        if (compilationSpeed == -1.0f) {
            return;
        }
        List<TopStatsFileInfo> filesBySpeed = this.fTopFilesByCompilationSpeed.get(Float.valueOf(compilationSpeed));
        if (filesBySpeed != null) {
            filesBySpeed.add(fileInfo);
            this.fTopFilesByCompilationSpeed.put(Float.valueOf(compilationSpeed), filesBySpeed);
            return;
        }
        filesBySpeed = new ArrayList<TopStatsFileInfo>();
        filesBySpeed.add(fileInfo);
        if (this.fTopFilesByCompilationSpeed.size() < 10) {
            this.fTopFilesByCompilationSpeed.put(Float.valueOf(compilationSpeed), filesBySpeed);
            return;
        }
        float speedOfFastestFile = this.fTopFilesByCompilationSpeed.lastKey().floatValue();
        if (speedOfFastestFile > (float)fileInfo.getTime()) {
            this.fTopFilesByCompilationSpeed.remove(Float.valueOf(speedOfFastestFile));
            this.fTopFilesByCompilationSpeed.put(Float.valueOf(compilationSpeed), filesBySpeed);
        }
    }

    private boolean checkAlreadyComputedFileBySpeed(TopStatsFileInfo fileInfo) {
        Float oldSpeed = null;
        int indexOfOldFile = -1;
        for (Map.Entry<Float, List<TopStatsFileInfo>> entry : this.fTopFilesByCompilationSpeed.entrySet()) {
            Float key = entry.getKey();
            List<TopStatsFileInfo> filesList = entry.getValue();
            if (filesList == null || !filesList.contains(fileInfo)) continue;
            indexOfOldFile = filesList.indexOf(fileInfo);
            TopStatsFileInfo oldFile = filesList.get(indexOfOldFile);
            if (fileInfo.getCompilationSpeed() >= oldFile.getCompilationSpeed()) {
                return true;
            }
            oldSpeed = key;
            break;
        }
        if (oldSpeed == null) {
            return false;
        }
        List<TopStatsFileInfo> filesList = this.fTopFilesByCompilationSpeed.get(oldSpeed);
        filesList.remove(indexOfOldFile);
        if (filesList.isEmpty()) {
            this.fTopFilesByCompilationSpeed.remove(oldSpeed);
        }
        return false;
    }

    private float computeAverageCompilationSpeedPerFile() {
        return this.fCompilationSpeedSum / (float)this.fNonZeroTimeNumberOfFiles;
    }

    private float computeAverageCompilationSpeed() {
        return (float)this.fTotalNumberOfLines / (float)this.fTotalCompilationTime;
    }

    private void addErrorsMessagesToBuildReport() {
        String errorText;
        DVTProblem m;
        if (!this.fSyntaxErrorsInProject.isEmpty()) {
            this.fBuildReport.add(String.valueOf(System.lineSeparator()) + MessageFormat.format(SECTION_FORMAT, String.valueOf(this.fNofSyntaxErrors > 10 ? "First 10" : "All " + this.fNofSyntaxErrors) + " syntax errors"));
        }
        while (!this.fSyntaxErrorsInProject.isEmpty()) {
            m = this.fSyntaxErrorsInProject.poll();
            Object[] objectArray = new Object[5];
            objectArray[0] = m.getMessage();
            objectArray[1] = Integer.toString(m.getLine());
            objectArray[2] = m.getPath();
            Object object = objectArray[3] = m.getFileIndex() != -1 ? " [compile index " + m.getFileIndex() + "]" : "";
            objectArray[4] = m.getInvocationNumber() != -1 ? String.valueOf(m.getFileIndex() != -1 ? " " : "") + "[invocation " + m.getInvocationNumber() + "]" : "";
            errorText = MessageFormat.format(ERROR_MESSAGE_FORMAT, objectArray);
            this.fBuildReport.add(errorText);
        }
        if (!this.fSemanticErrorsInProject.isEmpty()) {
            this.fBuildReport.add(String.valueOf(System.lineSeparator()) + MessageFormat.format(SECTION_FORMAT, String.valueOf(this.fNofSemanticErrors > 10 ? "First 10" : "All " + this.fNofSemanticErrors) + " semantic errors"));
        }
        while (!this.fSemanticErrorsInProject.isEmpty()) {
            m = this.fSemanticErrorsInProject.poll();
            Object[] objectArray = new Object[5];
            objectArray[0] = m.getMessage();
            objectArray[1] = Integer.toString(m.getLine());
            objectArray[2] = m.getPath();
            Object object = objectArray[3] = m.getFileIndex() != -1 ? " [compile index " + m.getFileIndex() + "]" : "";
            objectArray[4] = m.getInvocationNumber() != -1 ? String.valueOf(m.getFileIndex() != -1 ? " " : "") + "[invocation " + m.getInvocationNumber() + "]" : "";
            errorText = MessageFormat.format(ERROR_MESSAGE_FORMAT, objectArray);
            this.fBuildReport.add(errorText);
        }
        if (!this.fConfigErrorsInProject.isEmpty()) {
            this.fBuildReport.add(String.valueOf(System.lineSeparator()) + MessageFormat.format(SECTION_FORMAT, String.valueOf(this.fNofConfigErrors > 10 ? "First 10" : "All " + this.fNofConfigErrors) + " build configuration errors"));
        }
        while (!this.fConfigErrorsInProject.isEmpty()) {
            m = this.fConfigErrorsInProject.poll();
            Object[] objectArray = new Object[5];
            objectArray[0] = m.getMessage();
            objectArray[1] = Integer.toString(m.getLine());
            objectArray[2] = m.getPath();
            Object object = objectArray[3] = m.getFileIndex() != -1 ? " [compile index " + m.getFileIndex() + "]" : "";
            objectArray[4] = m.getInvocationNumber() != -1 ? String.valueOf(m.getFileIndex() != -1 ? " " : "") + "[invocation " + m.getInvocationNumber() + "]" : "";
            errorText = MessageFormat.format(ERROR_MESSAGE_FORMAT, objectArray);
            this.fBuildReport.add(errorText);
        }
    }

    private void addProblemToBuildReport(DVTProblem problem) {
        boolean isSyntax;
        DVTProblemCategory category = problem.getCategory();
        boolean isBuildConfig = category == DVTProblemCategories.BUILDCONFIG;
        boolean isSemantic = category == EProblemCategories.E_SEMANTIC || category == EProblemCategories.SLN_SEMANTIC || category == VlogProblemCategories.SVLOG_SEMANTIC || category == VhdlProblemCategories.VHDL_SEMANTIC || category == PSSProblemCategories.PSS_SEMANTIC || category == MSDLProblemCategories.MSDL_SEMANTIC;
        boolean bl = isSyntax = category == EProblemCategories.E_SYNTAX || category == EProblemCategories.SLN_SYNTAX || category == VlogProblemCategories.SVLOG_SYNTAX || category == VhdlProblemCategories.VHDL_SYNTAX || category == PSSProblemCategories.PSS_SYNTAX || category == MSDLProblemCategories.MSDL_SYNTAX;
        if (isSemantic) {
            if (this.fNofSemanticErrors < 10) {
                this.fSemanticErrorsInProject.add(problem);
            }
            ++this.fNofSemanticErrors;
        } else if (isSyntax) {
            if (this.fNofSyntaxErrors < 10) {
                this.fSyntaxErrorsInProject.add(problem);
            }
            ++this.fNofSyntaxErrors;
        } else if (isBuildConfig) {
            if (this.fNofConfigErrors < 10) {
                this.fConfigErrorsInProject.add(problem);
            }
            ++this.fNofConfigErrors;
        }
    }
}

