/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.builders;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.internal.console.ConsoleHyperlinkPosition;
import ro.amiq.dvt.builders.DVTConsoleButtonsDescription;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTMessageConsole
extends MessageConsole
implements IPropertyChangeListener {
    private DVTConsoleButtonsDescription fButtonsDescription;
    private IConsoleManager fConsoleManager = ConsolePlugin.getDefault().getConsoleManager();
    public static final String HYPER_LINK_CATEGORY = ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY;
    public final LazyHyperlink fLazyHyperlink = new LazyHyperlink();
    private IProject fProject;

    public DVTMessageConsole(IProject project, String name, ImageDescriptor imageDescriptor, DVTConsoleButtonsDescription buttons) {
        super(name, imageDescriptor);
        this.fProject = project;
        this.fButtonsDescription = buttons;
    }

    public void addHyperlink(IHyperlink hyperlink, int offset, int length) throws BadLocationException {
        try {
            IDocument document = this.getDocument();
            int documentLength = document.getLength();
            if (offset < 0 || length < 0 || offset + length > documentLength) {
                return;
            }
            if (document.get(offset, length).equals("top files")) {
                return;
            }
            LazyHyperlinkPosition hyperlinkPosition = null;
            hyperlinkPosition = hyperlink == null ? new LazyHyperlinkPosition(offset, length, 0) : (hyperlink instanceof DummyHyperlinkLineContainer ? new LazyHyperlinkPosition(offset, length, ((DummyHyperlinkLineContainer)hyperlink).fLine) : new ConsoleHyperlinkPosition(hyperlink, offset, length));
            document.addPosition(HYPER_LINK_CATEGORY, (Position)hyperlinkPosition);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void clearConsole() {
        try {
            IDocument document = this.getDocument();
            document.removePositionCategory(HYPER_LINK_CATEGORY);
            document.addPositionCategory(HYPER_LINK_CATEGORY);
            if (document.containsPositionCategory("ro.amiq.dvt.externaltools.PROBLEM_POSITION_CATEGORY")) {
                document.removePositionCategory("ro.amiq.dvt.externaltools.PROBLEM_POSITION_CATEGORY");
            }
            document.addPositionCategory("ro.amiq.dvt.externaltools.PROBLEM_POSITION_CATEGORY");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        super.clearConsole();
    }

    public IHyperlink getHyperlink(int offset) {
        try {
            IDocument document = this.getDocument();
            if (document != null) {
                Position[] positions = document.getPositions(HYPER_LINK_CATEGORY);
                Position position = this.findPosition(offset, positions);
                if (position instanceof LazyHyperlinkPosition) {
                    return ((LazyHyperlinkPosition)position).getHyperLink();
                }
                if (position instanceof ConsoleHyperlinkPosition) {
                    return ((ConsoleHyperlinkPosition)position).getHyperLink();
                }
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return null;
    }

    public IHyperlink[] getHyperlinks() {
        return new IHyperlink[0];
    }

    private Position findPosition(int offset, Position[] positions) {
        if (positions.length == 0) {
            return null;
        }
        int left = 0;
        int right = positions.length - 1;
        int mid = 0;
        Position position = null;
        while (left < right) {
            mid = (left + right) / 2;
            position = positions[mid];
            if (offset < position.getOffset()) {
                if (left == mid) {
                    right = left;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (offset > position.getOffset() + position.getLength() - 1) {
                if (right == mid) {
                    left = right;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            left = right = mid;
        }
        position = positions[left];
        if (offset >= position.getOffset() && offset < position.getOffset() + position.getLength()) {
            return position;
        }
        return null;
    }

    protected void init() {
        super.init();
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DVTMessageConsole.this.setFont(JFaceResources.getFont((String)"ro.amiq.dvt.ui.console.buildConsoleFont"));
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("ro.amiq.dvt.ui.console.buildConsoleFont")) {
            this.setFont(JFaceResources.getFont((String)"ro.amiq.dvt.ui.console.buildConsoleFont"));
        }
    }

    protected void dispose() {
        super.dispose();
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    public DVTConsoleButtonsDescription getButtonsDescription() {
        return this.fButtonsDescription;
    }

    public static class DummyHyperlinkLineContainer
    implements IHyperlink {
        int fLine;

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
        }

        public DummyHyperlinkLineContainer(int line) {
            this.fLine = line;
        }
    }

    class LazyHyperlink
    implements IHyperlink {
        String fFileName = null;
        int fLineNumber;

        LazyHyperlink() {
        }

        public LazyHyperlink withFilename(String fileName) {
            this.fFileName = fileName;
            return this;
        }

        public LazyHyperlink withLineNumber(int lineNumber) {
            this.fLineNumber = lineNumber;
            return this;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            try {
                File file = new File(this.fFileName);
                if (!file.exists()) {
                    return;
                }
                IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(DVTMessageConsole.this.fProject, this.fFileName);
                if (iFile != null) {
                    DVTFileUtils.getInstance().openEditor(iFile, this.fLineNumber, null);
                } else {
                    DVTFileUtils.getInstance().openEditor(file, this.fLineNumber);
                }
            }
            catch (Exception exception) {}
        }
    }

    public class LazyHyperlinkPosition
    extends DVTPosition {
        private int line;

        public LazyHyperlinkPosition(int offset, int length, int line) {
            super(offset, length);
            this.line = line;
        }

        public IHyperlink getHyperLink() {
            try {
                return DVTMessageConsole.this.fLazyHyperlink.withFilename(DVTMessageConsole.this.getDocument().get(this.offset, this.length)).withLineNumber(this.line);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

