/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.builders;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollector;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollectorUIDelegate;
import ro.amiq.dvt.ui.reportissue.ThreadDumpCollectorConstants;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;

public class ParserProfileManager {
    private static ParserProfileManager instance;
    public static final int DEFAULT_COLLECTION_INTERVAL = 500;
    public static final int DEFAULT_MAX_THREAD_DUMPS = Integer.MAX_VALUE;
    public static final String PARSER_PROFILE_FILE_PREFIX = "parser_";
    private static final String TIME_PATTERN = "u-MM-dd_HH-mm-ss.SSS";
    private String sessionFolderLocation;
    private String sessionFolderPath;
    private String sessionFinalZipPath;
    private Map<String, String> profiledFileToUUIDMapping;
    private Set<String> threadDumpCollectionFiles;
    private int threadDumpCollectionInterval = 500;
    private int maxNumberOfThreadDumps = Integer.MAX_VALUE;
    private List<StringMatcher> threadDumpAdditionalFilesMatchers;
    private List<StringMatcher> threadDumpProfileParserDirectiveFileMatchers;
    private AtomicBoolean inProgress = new AtomicBoolean();

    private ParserProfileManager() {
    }

    public static ParserProfileManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new ParserProfileManager();
        return instance;
    }

    public void startParserProfileIfNecessary(String profiledFilePath) {
        if (!this.shouldCollectThreadDump(profiledFilePath)) {
            return;
        }
        if (this.sessionFolderLocation == null) {
            String timestamp = this.getCurrentTimestamp();
            String parserFolderPath = String.valueOf(ThreadDumpCollectorConstants.getOutputDirectory()) + File.separator + "full_build";
            this.sessionFolderLocation = String.valueOf(parserFolderPath) + File.separator + "temp_" + timestamp;
            this.sessionFolderPath = "full_build" + File.separator + "temp_" + timestamp;
            StringBuilder sessionZipPathBuilder = new StringBuilder(String.valueOf(parserFolderPath) + File.separator);
            if (DVTStartupConstants.isLSRunning.get()) {
                sessionZipPathBuilder.append(ThreadDumpCollectorConstants.getPlatformPrefix()).append('.');
            }
            sessionZipPathBuilder.append(PARSER_PROFILE_FILE_PREFIX).append(timestamp).append(".thread_dump.zip");
            this.sessionFinalZipPath = sessionZipPathBuilder.toString();
            this.profiledFileToUUIDMapping = new HashMap<String, String>();
        }
        if (!this.profiledFileToUUIDMapping.containsKey(profiledFilePath)) {
            this.profiledFileToUUIDMapping.put(profiledFilePath, UUID.randomUUID().toString());
        }
        this.inProgress.set(DVTThreadDumpCollector.with().interval(this.threadDumpCollectionInterval).delay(0L).maxDumps(this.maxNumberOfThreadDumps).path(this.sessionFolderPath).prefix(this.profiledFileToUUIDMapping.get(profiledFilePath)).start());
        DVTThreadDumpCollectorUIDelegate.INSTANCE.updateStatusBar("DVT Parser profiler started!", false, false);
    }

    public void stopProfiling() {
        if (this.inProgress.get()) {
            DVTThreadDumpCollector.stop();
            this.inProgress.set(false);
        }
    }

    public void finishProfiling() {
        this.stopProfiling();
        if (this.sessionFinalZipPath == null) {
            return;
        }
        HashMap<String, ArrayList<String>> uuidToTempZipPathMapping = this.calculateUUIDToTempZipPathMapping();
        try {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ZipOutputStream finalZip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.sessionFinalZipPath)));){
                    for (Map.Entry<String, String> profiledFileData : this.profiledFileToUUIDMapping.entrySet()) {
                        String profiledFilePath = profiledFileData.getKey();
                        String profiledFileUUID = profiledFileData.getValue();
                        ArrayList<String> tempZipPathsList = uuidToTempZipPathMapping.get(profiledFileUUID);
                        if (tempZipPathsList == null || tempZipPathsList.isEmpty()) continue;
                        String entryName = String.valueOf(Paths.get(profiledFilePath, new String[0]).getFileName().toString()) + "." + this.getCurrentTimestamp() + ".log";
                        finalZip.putNextEntry(new ZipEntry(entryName));
                        finalZip.write(String.format("This thread dump was generated while parsing %s\n\n", profiledFilePath).getBytes());
                        for (String tempZipPath : tempZipPathsList) {
                            try {
                                Throwable throwable2 = null;
                                Object var14_19 = null;
                                try (ZipFile inputZipFile = new ZipFile(tempZipPath);){
                                    if (!inputZipFile.entries().hasMoreElements()) continue;
                                    ZipEntry entry = inputZipFile.entries().nextElement();
                                    Throwable throwable3 = null;
                                    Object var18_25 = null;
                                    try (Scanner scanner = new Scanner(inputZipFile.getInputStream(entry));){
                                        while (scanner.hasNextLine()) {
                                            finalZip.write(scanner.nextLine().getBytes());
                                            finalZip.write("\n".getBytes());
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable3 == null) {
                                            throwable3 = throwable4;
                                        } else if (throwable3 != throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                        throw throwable3;
                                    }
                                }
                                catch (Throwable throwable5) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable5;
                                    } else if (throwable2 != throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (IOException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                        }
                        finalZip.closeEntry();
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                try {
                    DVTFileUtils.getInstance().removeRecursive(Paths.get(this.sessionFolderLocation, new String[0]));
                }
                catch (IOException e2) {
                    DVTLogger.INSTANCE.logError((Throwable)e2);
                }
            }
        }
        finally {
            try {
                DVTFileUtils.getInstance().removeRecursive(Paths.get(this.sessionFolderLocation, new String[0]));
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void setParserProfile(Set<String> threadDumpCollectionFiles, int threadDumpCollectionInterval, int maxNumberOfThreadDumps, String[] threadDumpAdditionalFilesMatchers) {
        this.threadDumpCollectionFiles = threadDumpCollectionFiles;
        this.threadDumpCollectionInterval = threadDumpCollectionInterval;
        this.maxNumberOfThreadDumps = maxNumberOfThreadDumps;
        this.threadDumpAdditionalFilesMatchers = this.convertToStringMatcher(threadDumpAdditionalFilesMatchers);
    }

    public void clean() {
        this.threadDumpCollectionFiles = null;
        this.threadDumpCollectionInterval = 500;
        this.maxNumberOfThreadDumps = Integer.MAX_VALUE;
        this.threadDumpAdditionalFilesMatchers = null;
        this.threadDumpProfileParserDirectiveFileMatchers = null;
        this.sessionFolderLocation = null;
        this.sessionFolderPath = null;
        this.sessionFinalZipPath = null;
        this.profiledFileToUUIDMapping = null;
    }

    public void setDirectiveFileMatchers(String[] profileParserDirectiveFileMatchers) {
        this.threadDumpProfileParserDirectiveFileMatchers = this.convertToStringMatcher(profileParserDirectiveFileMatchers);
    }

    public int getMaxNumberOfThreadDumps() {
        return this.maxNumberOfThreadDumps;
    }

    public List<StringMatcher> getThreadDumpAdditionalFilesMatchers() {
        return this.threadDumpAdditionalFilesMatchers;
    }

    public Set<String> getThreadDumpCollectionFiles() {
        return this.threadDumpCollectionFiles;
    }

    public int getThreadDumpCollectionInterval() {
        return this.threadDumpCollectionInterval;
    }

    private boolean shouldCollectThreadDump(String path) {
        if (path.indexOf("__vlog__") != -1) {
            return false;
        }
        if (this.threadDumpCollectionFiles != null && this.threadDumpCollectionFiles.contains(path)) {
            return true;
        }
        if (this.threadDumpAdditionalFilesMatchers != null) {
            for (StringMatcher matcher : this.threadDumpAdditionalFilesMatchers) {
                if (!matcher.match(path)) continue;
                return true;
            }
        }
        if (this.threadDumpProfileParserDirectiveFileMatchers != null) {
            for (StringMatcher matcher : this.threadDumpProfileParserDirectiveFileMatchers) {
                if (!matcher.match(path)) continue;
                return true;
            }
        }
        return false;
    }

    private List<StringMatcher> convertToStringMatcher(String[] matcherStrings) {
        ArrayList<StringMatcher> result = new ArrayList<StringMatcher>();
        if (matcherStrings == null) {
            return null;
        }
        String[] stringArray = matcherStrings;
        int n = matcherStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String filterPath = DVTStringUtil.translatePathPatternToOSPattern(path);
            if (filterPath != null) {
                filterPath = BaseUtils.canonicPath(filterPath);
                result.add(new StringMatcher(filterPath, false, false, true));
            }
            ++n2;
        }
        return result;
    }

    private String getCurrentTimestamp() {
        return Instant.now().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(TIME_PATTERN));
    }

    private HashMap<String, ArrayList<String>> calculateUUIDToTempZipPathMapping() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        for (String uuid : this.profiledFileToUUIDMapping.values()) {
            result.put(uuid, new ArrayList());
        }
        boolean isLS = DVTStartupConstants.isLSRunning.get();
        String lsId = ThreadDumpCollectorConstants.getPlatformPrefix();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (Stream<Path> pathStream = Files.walk(Paths.get(this.sessionFolderLocation, new String[0]), new FileVisitOption[0]);){
                pathStream.forEach(tempThreadDumpZipPath -> {
                    if (new File(tempThreadDumpZipPath.toUri()).isDirectory()) {
                        return;
                    }
                    String tempZipName = tempThreadDumpZipPath.getFileName().toString();
                    if (isLS) {
                        tempZipName = tempZipName.substring(lsId.length() + 1);
                    }
                    if (!this.isValidZip(tempThreadDumpZipPath.toString())) {
                        return;
                    }
                    ((ArrayList)result.get(tempZipName.substring(0, tempZipName.indexOf(46)))).add(tempThreadDumpZipPath.toString());
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidZip(String zipPath) {
        if (!new File(zipPath).exists()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipFile zipFile = new ZipFile(zipPath);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                if (!entries.hasMoreElements()) {
                    return false;
                }
                if (entries.nextElement().getSize() != 0L) return true;
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

