/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.builders;

import ro.amiq.dvt.model.reflection.ParserPath;

public class TopStatsFileInfo {
    private ParserPath parserPath;
    private int nofRawLines;
    private long time;
    private float compilationSpeed = -1.0f;

    public TopStatsFileInfo(ParserPath parserPath, int nofRawLines, long time) {
        this.parserPath = parserPath;
        this.nofRawLines = nofRawLines;
        this.time = time;
        if (time > 0L) {
            this.compilationSpeed = (float)nofRawLines / (float)time;
        }
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }

    public int getNofRawLines() {
        return this.nofRawLines;
    }

    public long getTime() {
        return this.time;
    }

    public float getCompilationSpeed() {
        return this.compilationSpeed;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.nofRawLines;
        result = 31 * result + (this.parserPath == null ? 0 : this.parserPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopStatsFileInfo other = (TopStatsFileInfo)obj;
        if (this.nofRawLines != other.nofRawLines) {
            return false;
        }
        return !(this.parserPath == null ? other.parserPath != null : !this.parserPath.equals(other.parserPath));
    }
}

