/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.ui.Utils;

public class ActiveFileHandler
extends AbstractCliHandlerDelegate {
    private static final String STRIP_EXT = "strip_extension";
    private static final String NAME_ONLY = "name_only";

    public String getCommandName() {
        return "printActiveEditorFile";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        boolean nameOnly = commandLine.hasOption(NAME_ONLY);
        boolean stripExt = commandLine.hasOption(STRIP_EXT);
        IWorkbenchPage activePage = Utils.getActivePage();
        if (activePage == null) {
            throw new DVTCliException("NO_EDITOR: no active editor.");
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == null) {
            throw new DVTCliException("NO_EDITOR: no active editor.");
        }
        IEditorInput editorInput = activeEditor.getEditorInput();
        if (!(editorInput instanceof IURIEditorInput)) {
            throw new DVTCliException("NO_EDITOR: active editor is not a file editor.");
        }
        URI uri = ((IURIEditorInput)editorInput).getURI();
        if (uri == null) {
            throw new DVTCliException("NO_EDITOR: active editor is not a file editor.");
        }
        if (!"file".equals(uri.getScheme())) {
            throw new DVTCliException("NO_EDITOR: file in active editor is not a local file.");
        }
        IPath iPath = Path.fromOSString((String)uri.getPath());
        if (!iPath.toFile().exists()) {
            throw new DVTCliException("NO_EDITOR: file in active editor not exist on disk.");
        }
        if (stripExt) {
            iPath = iPath.removeFileExtension();
        }
        if (nameOnly) {
            result.append(iPath.lastSegment());
        } else {
            result.append(iPath.toOSString());
        }
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(OptionBuilder.create((String)NAME_ONLY));
        options.addOption(OptionBuilder.create((String)STRIP_EXT));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }
}

