/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.File;
import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;

public class CloseFileHandler
extends AbstractCliHandlerDelegate {
    public static final String FORCE_SAVE = "forceSave";

    public String getCommandName() {
        return "closeFile";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        if (commandLine.getArgs().length < 2) {
            throw new DVTCliException("You did not specify the path to file. It has to be the first parameter.");
        }
        String path = commandLine.getArgs()[1];
        if (path == null) {
            throw new DVTCliException("Could not determine path from command.");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new DVTCliException("File '" + file.getAbsolutePath() + "' does not exist.");
        }
        final boolean forceSave = commandLine.hasOption(FORCE_SAVE);
        final URI fileURI = file.toURI();
        final Exception[] exception = new Exception[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                        int n5 = iEditorReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            try {
                                URI editorInputURI;
                                IEditorInput input = editorReference.getEditorInput();
                                if (input instanceof IURIEditorInput && fileURI.equals(editorInputURI = ((IURIEditorInput)input).getURI())) {
                                    if (forceSave) {
                                        editorReference.getEditor(true).doSave((IProgressMonitor)new NullProgressMonitor());
                                    }
                                    page.closeEditors(new IEditorReference[]{editorReference}, true);
                                }
                            }
                            catch (PartInitException e) {
                                exception[0] = e;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        if (exception[0] != null) {
            throw new DVTCliException(exception[0].getMessage());
        }
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(OptionBuilder.create((String)FORCE_SAVE));
        return options;
    }
}

