/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.File;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.cli.LocalNonWorkspaceTypedElement;
import ro.amiq.dvt.cli.ResourceCompareInput;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public class CompareFilesHandler
extends AbstractCliHandlerDelegate {
    private static final String BLOCKING = "blocking";
    private static final String BASE = "base";

    public String getCommandName() {
        return "compareFiles";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        File rightFile;
        File leftFile;
        if (commandLine.getArgs().length == 4 && commandLine.hasOption(BASE)) {
            throw new DVTCliException("You can't provide 3 files and use -base simultaneously!");
        }
        if (commandLine.getArgs().length == 2) {
            throw new DVTCliException("You need to provide at least 2 files for comparation. Use dvt_cli.sh -help for more info.");
        }
        String baseFilePath = null;
        String leftFilePath = null;
        String rightFilePath = null;
        if (commandLine.getArgs().length == 4) {
            baseFilePath = commandLine.getArgs()[1];
            leftFilePath = commandLine.getArgs()[2];
            rightFilePath = commandLine.getArgs()[3];
        } else {
            leftFilePath = commandLine.getArgs()[1];
            rightFilePath = commandLine.getArgs()[2];
            if (commandLine.hasOption(BASE)) {
                baseFilePath = commandLine.getOptionValue(BASE);
            }
        }
        if (leftFilePath == null || leftFilePath.isEmpty()) {
            throw new DVTCliException("You must specify which files you want to compare.");
        }
        IPath leftPath = Path.fromOSString((String)leftFilePath);
        if (!leftPath.isAbsolute()) {
            leftFilePath = Paths.get(cwd, leftFilePath).toString();
            leftPath = Path.fromOSString((String)leftFilePath);
        }
        if (!(leftFile = new File(leftFilePath)).isFile()) {
            throw new DVTCliException("Left member is not a file " + leftFilePath);
        }
        if (!leftFile.exists()) {
            throw new DVTCliException("Left file does not exist " + leftFilePath);
        }
        LocalNonWorkspaceTypedElement leftTypedElement = new LocalNonWorkspaceTypedElement(leftPath);
        if (rightFilePath == null || rightFilePath.isEmpty()) {
            throw new DVTCliException("You must specify which files you want to compare.");
        }
        IPath rightPath = Path.fromOSString((String)rightFilePath);
        if (!rightPath.isAbsolute()) {
            rightFilePath = Paths.get(cwd, rightFilePath).toString();
            rightPath = Path.fromOSString((String)rightFilePath);
        }
        if (!(rightFile = new File(rightFilePath)).isFile()) {
            throw new DVTCliException("Left member is not a file " + rightFilePath);
        }
        if (!rightFile.exists()) {
            throw new DVTCliException("Left file does not exist " + rightFilePath);
        }
        LocalNonWorkspaceTypedElement rightTypedElement = new LocalNonWorkspaceTypedElement(rightPath);
        LocalNonWorkspaceTypedElement ancestorTypedElement = null;
        if (baseFilePath != null) {
            File baseFile;
            IPath basePath = Path.fromOSString((String)baseFilePath);
            if (!basePath.isAbsolute()) {
                baseFilePath = Paths.get(cwd, baseFilePath).toString();
                basePath = Path.fromOSString((String)baseFilePath);
            }
            if (!(baseFile = new File(baseFilePath)).isFile()) {
                throw new DVTCliException("Left member is not a file " + baseFilePath);
            }
            if (!baseFile.exists()) {
                throw new DVTCliException("Left file does not exist " + baseFilePath);
            }
            ancestorTypedElement = new LocalNonWorkspaceTypedElement(basePath);
        }
        final IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        final ResourceCompareInput input = new ResourceCompareInput((ITypedElement)ancestorTypedElement, (ITypedElement)leftTypedElement, (ITypedElement)rightTypedElement, activePage);
        CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)activePage);
        if (!commandLine.hasOption(BLOCKING)) {
            return;
        }
        final AtomicBoolean closed = new AtomicBoolean(false);
        IPartListener closeListener = new IPartListener(){

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof IEditorPart && ((IEditorPart)part).getEditorInput() == input) {
                    activePage.removePartListener((IPartListener)this);
                    closed.set(true);
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        };
        activePage.addPartListener(closeListener);
        while (!closed.get()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(OptionBuilder.create((String)BLOCKING));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)BASE));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().c();
    }
}

