/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.startup.DVTPerspectiveSwitcher;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class CreateImportProjectBase
extends AbstractCliHandlerDelegate {
    public static final String DEFAULT_BUILD = "default.build";
    public static final String CREATE_PROJECT = "createProject";
    public static final String CREATE_E_PROJECT = "createEProject";
    public static final String CREATE_SV_PROJECT = "createSVProject";
    public static final String LOWERCASE_F = "f";
    public static final String UPPERCASE_F = "F";
    public static final String MAP = "map";
    public static final String NAME = "name";
    public static final String LANG = "lang";
    public static final String TOP = "top";
    public static final String TEST = "test";
    public static final String PROJECT_EXPLORER_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    public static final String NAVIGATOR_ID = "org.eclipse.ui.views.ResourceNavigator";
    public static final String PERSPECTIVE = "perspective";
    public static final String DVT = "DVT";
    public static final String WORKINGSET = "workingset";
    public static final String NEWWINDOW = "newwindow";
    public static final String FORCE = "force";
    public static final String CLOSE_OTHERS = "close_others";
    public static final String EXCLUDE = "exclude";
    public static final String INCLUDE = "include";
    public static final String OPEN_DIALOG = "openResourceFilterDialog";
    public static final String DISABLE_INCLUDE_AUTO_FS_CHECK = "disable_fs_check";
    public static final String CLEARCASE = "clearcase";
    public static final String GIT = "git";
    public static final String P4 = "p4";
    public static final String SVN = "svn";
    public static final String ORG_ECLIPSE_EGIT_CORE = "org.eclipse.egit.core";
    public static final String GIT_REPOS_VIEW_DIRECTORIES = "GitRepositoriesView.GitDirectories.relative";
    public static final String IDE_WORKBENCH_BUNDLE = "org.eclipse.ui.ide";
    public static final String OPEN_RESOURCE_SECTION = "org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog";
    public static final String WORKING_SET_NAME_TAG = "workingSetName";
    public static final String WORKING_SET_KEY = "WorkingSet";
    public static final String STORE_SECTION = "ResourceNavigator";
    public static final String STORE_WORKING_SET = "ResourceWorkingSetFilter.STORE_WORKING_SET";
    public static final String BUILD_CONFIG = "build_config";
    public static final String BUILD = "build";
    public static final String AUTO = "auto";
    public static final String FIRST_LEVEL = "first_level";
    private static final String AUTO_FILTERS_ROOT = ",root=";
    private static final String AUTO_FILTERS_APPLIES = ",applies=fd";
    private static final String AUTO_FILTERS_NAME = "name=*";
    private static final String AUTO_FILTERS_LAZY = "name=*,lazy";
    public static final String LINT = "lint";
    public static final String PROJECT_RELATIVE_PATH_REGEX = "projectRelativePath_regex=";
    private static IWindowListener fWindowListener;

    public static IWorkbenchWindow handleWorkingSetNewWindow(final IProject project, boolean inNewWindow, DVTCliHandlerV1.ResultBuilder result) throws CoreException {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkingSetManager workingSetManager = workbench.getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.getWorkingSet(project.getName());
        if (workingSet != null) {
            result.appendInfo("Adding project to existing working set");
            workingSet.setElements(new IAdaptable[]{project});
        } else {
            result.appendInfo("Creating new working set for project");
            workingSet = workingSetManager.createWorkingSet(project.getName(), new IAdaptable[]{project});
            workingSetManager.addWorkingSet(workingSet);
        }
        IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
        if (inNewWindow) {
            result.appendInfo("Opening new window");
            final IWorkbenchWindow[] newWindow = new IWorkbenchWindow[1];
            workbench.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        newWindow[0] = workbench.openWorkbenchWindow(CreateImportProjectBase.getPerspectiveName(project), null);
                    }
                    catch (WorkbenchException workbenchException) {}
                }
            });
            if (newWindow[0] != null) {
                window = newWindow[0];
                CreateImportProjectBase.ensureListenerActive();
            } else {
                result.appendWarning("Failed to open new window.");
            }
        }
        workingSet.setId("org.eclipse.ui.resourceWorkingSetPage");
        result.appendInfo("Applying working set");
        window.getActivePage().setWorkingSets(new IWorkingSet[]{workingSet});
        CreateImportProjectBase.applyWorkingSetForOpenResource(window);
        CreateImportProjectBase.applyWorkingSetForView(window, NAVIGATOR_ID, STORE_SECTION);
        return window;
    }

    public static void handlePerspectiveSwitch(CommandLine commandLine, String preferredDefault) throws DVTCliException {
        String perspectiveId = null;
        if (commandLine.hasOption(PERSPECTIVE)) {
            String value = commandLine.getOptionValue(PERSPECTIVE);
            if (DVT.equalsIgnoreCase(value)) {
                perspectiveId = "ro.amiq.dvt.ui.perspectives.DVTPerspective";
            }
            try {
                if (perspectiveId == null) {
                    perspectiveId = LanguageKind.valueOf((String)value.toUpperCase()).PERSPECTIVE_ID;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IPerspectiveDescriptor descriptor = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(value);
                if (descriptor != null) {
                    perspectiveId = descriptor.getId();
                }
                throw new DVTCliException("Unknown perspective name or id " + value + ". Valid are DVT, E, VLOG, VHDL or a perspective id.");
            }
        }
        if (perspectiveId == null) {
            perspectiveId = preferredDefault;
        }
        if (perspectiveId == null) {
            perspectiveId = "ro.amiq.dvt.ui.perspectives.DVTPerspective";
        }
        DVTPerspectiveSwitcher.switchPerspective((String)perspectiveId);
    }

    public static void handleShareWithClearcase(final IProject project, DVTCliHandlerV1.ResultBuilder result) throws CoreException {
        if (project == null) {
            return;
        }
        result.appendInfo("Sharing project with ClearCase");
        final Bundle clearCasePlugin = Platform.getBundle((String)"net.sourceforge.eclipseccase.ui");
        if (clearCasePlugin == null) {
            result.appendError("ClearCase plugin is not installed");
            return;
        }
        Platform.getPreferencesService().getRootNode().node("instance").node("org.eclipse.ui.workbench").putBoolean("UIActivities.ro.amiq.dvt.activities.enabled.ClearcaseToolbar", true);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Class associateProjectActionClass = clearCasePlugin.loadClass("net.sourceforge.eclipseccase.ui.actions.AssociateProjectAction");
                    Method selectionChangedMethod = associateProjectActionClass.getMethod("selectionChanged", IAction.class, ISelection.class);
                    Method executeMethod = associateProjectActionClass.getDeclaredMethod("execute", IAction.class);
                    Object associateProjectActionObj = associateProjectActionClass.newInstance();
                    selectionChangedMethod.invoke(associateProjectActionObj, null, new StructuredSelection((Object)project));
                    executeMethod.invoke(associateProjectActionObj, new Object[1]);
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                }
            }
        });
    }

    public static void handleGitRepos(IProject project, String reposString, DVTCliHandlerV1.ResultBuilder result) throws CoreException {
        if (project == null || reposString == null) {
            return;
        }
        Preferences prefNode = Platform.getPreferencesService().getRootNode().node("instance").node(ORG_ECLIPSE_EGIT_CORE);
        String existingReposString = prefNode.get(GIT_REPOS_VIEW_DIRECTORIES, "");
        LinkedHashSet<String> repos = new LinkedHashSet<String>();
        String[] stringArray = existingReposString.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String existingRepoString = stringArray[n2];
            if (!existingRepoString.isEmpty()) {
                repos.add(existingRepoString);
            }
            ++n2;
        }
        result.appendInfo("Existing git repositories: " + DVTStringUtil.join(repos, ":"));
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String[] stringArray2 = reposString.split(":", 0);
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String repoString = stringArray2[n];
            if (!repoString.isEmpty()) {
                File repoFile = new File(repoString);
                if (!repoFile.exists()) {
                    result.appendWarning("Provided path does not exist: " + repoString);
                } else if (!repoFile.isDirectory()) {
                    result.appendWarning("Provided path is not a directory: " + repoString);
                } else if (!".git".equals(repoFile.getName())) {
                    result.appendWarning("Provided path is not a valid git repository (must end with .git): " + repoString);
                } else {
                    IPath repoIPath = Path.fromOSString((String)repoString);
                    if (workspacePath.isPrefixOf(repoIPath)) {
                        repos.add(repoIPath.makeRelativeTo(workspacePath).toOSString());
                    } else {
                        repos.add(repoFile.getAbsolutePath());
                    }
                }
            }
            ++n;
        }
        result.appendInfo("Setting git repositories: " + DVTStringUtil.join(repos, ":"));
        prefNode.put(GIT_REPOS_VIEW_DIRECTORIES, DVTStringUtil.join(repos, ":"));
    }

    public static void handleShareWithPerforce(IProject project, String param, DVTCliHandlerV1.ResultBuilder result) throws CoreException {
        if (project == null || param == null || param.isEmpty()) {
            return;
        }
        String value = param.replaceAll("=", " ").replaceAll(",", " ");
        result.appendInfo("Sharing project with Perforce: " + value);
        try {
            project.setPersistentProperty(new QualifiedName("com.perforce.team.core.PerforceTeamProvider", "connection"), value);
            project.setPersistentProperty(new QualifiedName("org.eclipse.team.core", "repository"), "com.perforce.team.core.PerforceTeamProvider");
            RepositoryProvider.map((IProject)project, (String)"com.perforce.team.core.PerforceTeamProvider");
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", "Could not share project " + project.getName() + " with Perforce. Please make sure the Perforce Eclipse plugin is installed."));
        }
    }

    public static void handleShareWithSVN(IProject project, String repoUrl, DVTCliHandlerV1.ResultBuilder result) throws CoreException {
        if (project == null) {
            return;
        }
        result.appendInfo("Sharing project with Subversive SVN plugin");
        Bundle subversivePlugin = Platform.getBundle((String)"org.eclipse.team.svn.ui");
        if (subversivePlugin == null) {
            result.appendError("Subversive UI plugin is not installed");
            return;
        }
        Platform.getPreferencesService().getRootNode().node("instance").node("org.eclipse.team.svn.ui").putBoolean("preference.share.enableAuto", true);
        Bundle subversiveCorePlugin = Platform.getBundle((String)"org.eclipse.team.svn.core");
        if (subversiveCorePlugin == null) {
            result.appendError("Subversive core plugin is not installed");
            return;
        }
        try {
            boolean isNewRepository;
            Class svnUtilityClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.utility.SVNUtility");
            Method findRootsMethod = svnUtilityClass.getMethod("findRoots", String.class, Boolean.TYPE);
            Class repoRootClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.resource.IRepositoryRoot");
            Class repoLocationClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.resource.IRepositoryLocation");
            Object repoLocation = null;
            Object repoRootsArray = findRootsMethod.invoke(null, repoUrl, true);
            boolean bl = isNewRepository = repoRootsArray == null || Array.getLength(repoRootsArray) == 0;
            if (isNewRepository) {
                Class svnRemoteStorageClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage");
                Method instanceMethod = svnRemoteStorageClass.getMethod("instance", new Class[0]);
                Object svnRemoteStorageInstance = instanceMethod.invoke(null, new Object[0]);
                Method newRepoLocationMethod = svnRemoteStorageClass.getMethod("newRepositoryLocation", new Class[0]);
                repoLocation = newRepoLocationMethod.invoke(svnRemoteStorageInstance, new Object[0]);
                Method initializeRepositoryLocationMethod = svnUtilityClass.getMethod("initializeRepositoryLocation", repoLocationClass, String.class);
                initializeRepositoryLocationMethod.invoke(null, repoLocation, repoUrl);
            } else {
                Object repoRoot = Array.get(repoRootsArray, 0);
                Method getRepoLocationMethod = repoRootClass.getMethod("getRepositoryLocation", new Class[0]);
                repoLocation = getRepoLocationMethod.invoke(repoRoot, new Object[0]);
            }
            Class reconnectProjectOpClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.operation.local.management.ReconnectProjectOperation");
            Constructor reconnectProjectOpConstructor = reconnectProjectOpClass.getConstructor(IProject[].class, repoLocationClass);
            Object reconnectProjectOperation = reconnectProjectOpConstructor.newInstance(new IProject[]{project}, repoLocation);
            Class actionOperationClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.operation.IActionOperation");
            Class compositeOpClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.operation.CompositeOperation");
            Constructor compositeOpConstructor = compositeOpClass.getConstructor(String.class, NLS.class.getGenericSuperclass().getClass());
            Method addToCompositeOperationMethod = compositeOpClass.getMethod("add", actionOperationClass);
            Method getIdMethod = reconnectProjectOpClass.getMethod("getId", new Class[0]);
            Method getMessagesClass = reconnectProjectOpClass.getMethod("getMessagesClass", new Class[0]);
            Object compositeOperation = compositeOpConstructor.newInstance(getIdMethod.invoke(reconnectProjectOperation, new Object[0]), getMessagesClass.invoke(reconnectProjectOperation, new Object[0]));
            if (isNewRepository) {
                Class addRepoLocationOpClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.operation.remote.management.AddRepositoryLocationOperation");
                Constructor addRepoLocationOpConstructor = addRepoLocationOpClass.getConstructor(repoLocationClass);
                addToCompositeOperationMethod.invoke(compositeOperation, addRepoLocationOpConstructor.newInstance(repoLocation));
                Class saveRepoLocationOpClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation");
                Constructor saveRepoLocationOpConstructor = saveRepoLocationOpClass.getConstructor(new Class[0]);
                addToCompositeOperationMethod.invoke(compositeOperation, saveRepoLocationOpConstructor.newInstance(new Object[0]));
            }
            addToCompositeOperationMethod.invoke(compositeOperation, reconnectProjectOperation);
            Class progressMonitorUtilityClass = subversiveCorePlugin.loadClass("org.eclipse.team.svn.core.utility.ProgressMonitorUtility");
            Method doTaskExternalMethod = progressMonitorUtilityClass.getMethod("doTaskExternal", actionOperationClass, IProgressMonitor.class);
            doTaskExternalMethod.invoke(null, compositeOperation, new NullProgressMonitor());
        }
        catch (Throwable e) {
            result.appendError("Connecting project to Subersive SVN repository failed");
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private static void ensureListenerActive() {
        if (fWindowListener == null) {
            fWindowListener = new IWindowListener(){

                public void windowOpened(IWorkbenchWindow window) {
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                }

                public void windowActivated(IWorkbenchWindow window) {
                    CreateImportProjectBase.applyWorkingSetForView(null, CreateImportProjectBase.NAVIGATOR_ID, CreateImportProjectBase.STORE_SECTION);
                    CreateImportProjectBase.applyWorkingSetForOpenResource(null);
                }
            };
            PlatformUI.getWorkbench().addWindowListener(fWindowListener);
        }
    }

    private static void applyWorkingSetForView(IWorkbenchWindow window, String viewId, final String storeSection) {
        final IWorkbenchWindow zwindow = window == null ? DVTUiUtils.getActiveWorkbenchWindow() : window;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkingSet workingSet = zwindow.getActivePage().getAggregateWorkingSet();
                AbstractUIPlugin plugin = CreateImportProjectBase.getIdePlugin();
                if (plugin == null) {
                    return;
                }
                IDialogSettings settings = plugin.getDialogSettings().getSection(storeSection);
                if (settings == null) {
                    settings = plugin.getDialogSettings().addNewSection(storeSection);
                }
                settings.put(CreateImportProjectBase.STORE_WORKING_SET, workingSet.getName());
            }
        });
    }

    private static void applyWorkingSetForOpenResource(IWorkbenchWindow window) {
        if (window == null) {
            window = DVTUiUtils.getActiveWorkbenchWindow();
        }
        IWorkingSet workingSet = window.getActivePage().getAggregateWorkingSet();
        AbstractUIPlugin plugin = CreateImportProjectBase.getIdePlugin();
        if (plugin == null) {
            return;
        }
        IDialogSettings settings = plugin.getDialogSettings().getSection(OPEN_RESOURCE_SECTION);
        if (settings == null) {
            settings = plugin.getDialogSettings().addNewSection(OPEN_RESOURCE_SECTION);
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)WORKING_SET_KEY);
        memento.putString(WORKING_SET_NAME_TAG, workingSet.getName());
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            settings.put(WORKING_SET_KEY, writer.getBuffer().toString());
        }
        catch (IOException iOException) {}
    }

    private static AbstractUIPlugin getIdePlugin() {
        Bundle bundle = Platform.getBundle((String)IDE_WORKBENCH_BUNDLE);
        if (bundle == null) {
            return null;
        }
        String activator = (String)bundle.getHeaders().get("Bundle-Activator");
        if (activator == null) {
            return null;
        }
        Object activatorInstance = null;
        try {
            Class activatorClass = bundle.loadClass(activator);
            Method method = activatorClass.getMethod("getDefault", new Class[0]);
            activatorInstance = method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (activatorInstance == null) {
            return null;
        }
        if (!(activatorInstance instanceof AbstractUIPlugin)) {
            return null;
        }
        return (AbstractUIPlugin)activatorInstance;
    }

    public static String getPerspectiveName(IProject project) {
        block12: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            try {
                                if (project.getNature("ro.amiq.edt.enature") == null) break block8;
                                return "ro.amiq.edt.ui.perspectives.EDTPerspective";
                            }
                            catch (CoreException coreException) {}
                        }
                        if (project.getNature("ro.amiq.slndt.slnnature") == null) break block9;
                        return "ro.amiq.edt.ui.perspectives.EDTPerspective";
                    }
                    if (project.getNature("ro.amiq.pssdt.pssnature") == null) break block10;
                    return "ro.amiq.edt.ui.perspectives.EDTPerspective";
                }
                if (project.getNature("ro.amiq.vlogdt.VlogNature") == null) break block11;
                return "ro.amiq.vlogdt.ui.perspectives.VlogPerspective";
            }
            if (project.getNature("ro.amiq.vhdldt.VhdlNature") == null) break block12;
            return "ro.amiq.vhdldt.ui.perspectives.VhdlPerspective";
        }
        if (project.getNature("ro.amiq.msdldt.msdlnature") != null) {
            return "ro.amiq.dvt.ui.perspectives.DVTPerspective";
        }
        return null;
    }

    public static void handleSelection(final IWorkbenchWindow window, final IProject project) {
        DVTViewManager.getInstanceByWorkbenchWindow(window);
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event == null || event.getDelta() == null) {
                    return;
                }
                List<IResourceDelta> addedChildren = Arrays.asList(event.getDelta().getAffectedChildren(1));
                if (addedChildren.isEmpty()) {
                    return;
                }
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                Optional<IResourceDelta> addedProject = addedChildren.stream().filter(d -> d.getResource() == project).findFirst();
                if (!addedProject.isPresent()) {
                    String addedResourcesString = addedChildren.stream().map(d -> d.getResource().getFullPath().toOSString()).collect(Collectors.joining(", "));
                    DVTLogger.INSTANCE.logInfo("DVT CLI: Unexpected resources added upon creation / addition of project '" + project.getName() + "': \n    " + addedResourcesString);
                }
                Utils.safeRunAsynchInUIThread(() -> {
                    try {
                        DVTPlugin.getSelectionManager().resetLastSelectedResource(window);
                        DVTPlugin.getSelectionManager().selectAndReveal((IResource)project, window);
                        window.getActivePage().showView("org.eclipse.ui.console.ConsoleView");
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (Exception e2) {
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                });
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
    }

    protected void closeOtherProjects(IProgressMonitor monitor, String thisProjectName, DVTCliHandlerV1.ResultBuilder result) {
        if (thisProjectName == null || result == null) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!"DVT-Settings".equals(project.getName()) && !thisProjectName.equals(project.getName()) && project.isAccessible()) {
                    project.close(monitor);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            result.appendInfo("Failed to close other projects due to: " + e.getMessage());
        }
    }

    protected String createBuildFileIfNotExists(IPath projectLocation, String activeBuildFileName) {
        File defaultBuild;
        block15: {
            boolean fileCreated;
            File dotDVT = new File(projectLocation.toOSString(), ".dvt");
            if (dotDVT.exists()) {
                File activeBuildFile = new File(dotDVT, String.valueOf(activeBuildFileName) + ".build");
                if (activeBuildFile.exists()) {
                    return activeBuildFileName;
                }
            } else {
                dotDVT.mkdir();
            }
            if (fileCreated = (defaultBuild = new File(dotDVT, DEFAULT_BUILD)).createNewFile()) break block15;
            return "default";
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedWriter fw = new BufferedWriter(new FileWriter(defaultBuild));){
                fw.write("+dvt_init_auto");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logDebug("Errror while creating .dvt with default.build!");
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return "default";
    }
}

