/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.internal.resources.Filter;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ro.amiq.dvt.DVTEclipseCDTUtils;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigXml;
import ro.amiq.dvt.cli.CreateImportProjectBase;
import ro.amiq.dvt.cli.StringBuilderMap;
import ro.amiq.dvt.linter.ui.ILinterReportInput;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.nature.INatureContributor;
import ro.amiq.dvt.nature.NatureContributors;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFilters;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.startup.variableresolvers.DVTEnvVariableResolver;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.benchmark.StopWatch;

public class CreateProject
extends CreateImportProjectBase {
    private static final String ERROR_MULTIPLE_BUILD_OPTIONS = "Only one -build option is allowed";
    private static final String PROJECT_REFRESH_CANCELED = "Project refresh was canceled";
    private static final String OPEN_PROJECT_CANCELED = "Open project was canceled";
    private static final String EQUALS = "=";
    private static final String COMMA = ",";
    private static final List<String> MANDATORY_P4_ARGS = Arrays.asList("P4CLIENT", "P4PORT", "P4USER");
    private static final String VALID_LANGS = DVTStringUtil.join(LanguageKind.valuesWithNature(), ", ");
    private static final String AUTOMATICALLY_ADD_INCLUDE_AUTO_INFO = "To avoid slow downs, DVT will automatically create resource filters.";
    private static final String TOO_MANY_RESOURCES_INFO = "The project contains too many resources ";
    private static final String LAUNCHER_WARNING = "The launch files defined under the project might have been filtered.";
    private static final String SLOW_FS_INFO = "The project is located on a slow filesystem ";
    private static final int THRESHOLD_INCLUDE_AUTO_BY_DEFAULT = 50000;
    private static final int TIMEOUT_INCLUDE_AUTO_BY_DEFAULT = 10000;
    public static final boolean DVT_SHARE_PROJECT_SYNCHRONIZED = System.getenv("DVT_SHARE_PROJECT_SYNCHRONIZED") != null;
    private boolean autoFilterResources;
    private int autoFilterThreshold;
    private boolean autoFiltersFirstLevel;

    public String getCommandName() {
        return "createProject";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, List<String> command) throws DVTCliException, CoreException {
        if (Objects.equals(command.get(0), "createEProject")) {
            command.remove(0);
            command.add(0, this.getCommandName());
            command.add("-lang");
            command.add("e");
        } else if (Objects.equals(command.get(0), "createSVProject")) {
            command.remove(0);
            command.add(0, this.getCommandName());
            command.add("-lang");
            command.add("vlog");
        }
        super.handle(monitor, result, cwd, command);
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        try {
            this.handleInternal(monitor, result, cwd, commandLine);
        }
        finally {
            this.clearRestoreInhibited();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleInternal(IProgressMonitor monitor, final DVTCliHandlerV1.ResultBuilder result, String cwd, final CommandLine commandLine) throws DVTCliException, CoreException {
        INatureContributor cppNatureContributor;
        void var29_42;
        boolean projectExists;
        int i;
        String[] mapElements;
        int n;
        int n2;
        String[] stringArray;
        String[] mapElements2;
        boolean force = false;
        boolean closeOthers = false;
        this.autoFilterResources = false;
        this.autoFiltersFirstLevel = false;
        StopWatch.reset("[DVT-CLI]  checkfiles").start();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(commandLine.getArgs()));
        args.remove(0);
        if (args.isEmpty()) {
            throw new DVTCliException("You did not specify the project location. It has to be the first parameter.");
        }
        String location = (String)args.remove(0);
        File projectDir = new File(location);
        try {
            projectDir = !projectDir.isAbsolute() ? new File(cwd, location).getCanonicalFile() : projectDir.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new DVTCliException("Invalid project location.");
        }
        StringBuilderMap buildFiles = new StringBuilderMap();
        if (commandLine.hasOption("build_config") && (mapElements2 = commandLine.getOptionValues("build_config")).length % 2 == 0) {
            int i2 = 0;
            while (i2 < mapElements2.length) {
                buildFiles.get(mapElements2[i2]).append(mapElements2[i2 + 1]);
                i2 += 2;
            }
        }
        if (commandLine.hasOption("build")) {
            String[] buildConfigs = commandLine.getOptionValues("build");
            if (buildConfigs.length > 1) {
                throw new DVTCliException(ERROR_MULTIPLE_BUILD_OPTIONS);
            }
            BuildConfigXml xml = new BuildConfigXml();
            xml.setActiveBuildConfigName(commandLine.getOptionValue("build"));
            buildFiles.get("build.config.xml").append(xml.toXmlString());
        }
        String projectName = commandLine.hasOption("name") ? commandLine.getOptionValue("name") : projectDir.getName();
        LinkedHashSet<LanguageKind> selectedLangs = new LinkedHashSet<LanguageKind>();
        if (commandLine.hasOption("force")) {
            force = true;
        }
        if (commandLine.hasOption("close_others")) {
            closeOthers = true;
        }
        if (commandLine.hasOption("include")) {
            this.computeIncludeArguments(commandLine.getOptionValues("include"));
        }
        if (commandLine.hasOption("p4")) {
            HashSet<String> missingArguments = new HashSet<String>(MANDATORY_P4_ARGS);
            stringArray = commandLine.getOptionValue("p4").split(COMMA);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String token = stringArray[n];
                String[] auxTokens = token.split(EQUALS);
                if (auxTokens.length >= 2) {
                    missingArguments.remove(auxTokens[0]);
                }
                ++n;
            }
            if (!missingArguments.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", "You did not specify the following mandatory P4 arguments: " + DVTStringUtil.join(missingArguments, ", ")));
            }
        }
        this.checkBuildConfigFlags(commandLine);
        if (commandLine.hasOption("f")) {
            buildFiles.get("default.build").append("-f ").append(commandLine.getOptionValue("f")).append("\n");
        }
        if (commandLine.hasOption("F")) {
            buildFiles.get("default.build").append("-F ").append(commandLine.getOptionValue("F")).append("\n");
        }
        if (commandLine.hasOption("top")) {
            String[] stringArray2 = commandLine.getOptionValues("top");
            n = stringArray2.length;
            int token = 0;
            while (token < n) {
                String top = stringArray2[token];
                buildFiles.get("default.build").append(top).append("\n");
                ++token;
            }
        }
        if (commandLine.hasOption("test")) {
            String[] stringArray3 = commandLine.getOptionValues("test");
            n = stringArray3.length;
            int token = 0;
            while (token < n) {
                String test = stringArray3[token];
                buildFiles.get("default.build").append("+dvt_test+").append(test).append("\n");
                ++token;
            }
        }
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        if (commandLine.hasOption("map") && (mapElements = commandLine.getOptionValues("map")).length % 2 == 0) {
            i = 0;
            while (i < mapElements.length) {
                sourceMap.put(mapElements[i], mapElements[i + 1]);
                i += 2;
            }
        }
        if (commandLine.hasOption("lang")) {
            stringArray = commandLine.getOptionValues("lang");
            n2 = stringArray.length;
            i = 0;
            while (i < n2) {
                String lang = stringArray[i];
                try {
                    LanguageKind lk = LanguageKind.valueOf(lang.toUpperCase());
                    if (lk == null || lk.NATURE_ID == null) {
                        result.appendWarning("Ignoring -lang " + lang + ". Valid are: " + VALID_LANGS);
                    } else if ((LanguageKind.CPP.equals((Object)lk) || LanguageKind.CPP_EXT.equals((Object)lk)) && NatureContributors.getContributor(LanguageKind.CPP) == null) {
                        result.appendWarning("Ignoring -lang CPP, it is valid only if DVT CDT Integration feature is installed.");
                    } else {
                        selectedLangs.add(lk);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    result.appendWarning("Ignoring -lang " + lang + ". Valid are: " + VALID_LANGS);
                }
                ++i;
            }
        }
        if (selectedLangs.contains((Object)LanguageKind.CPP_EXT)) {
            selectedLangs.add(LanguageKind.CPP);
        }
        if (selectedLangs.contains((Object)LanguageKind.PF) && !selectedLangs.contains((Object)LanguageKind.VLOG) && !selectedLangs.contains((Object)LanguageKind.VHDL)) {
            result.appendWarning("Ignoring -lang PF is valid only in combination with at least one of VLOG or VHDL.");
            selectedLangs.remove((Object)LanguageKind.PF);
        }
        if (selectedLangs.isEmpty()) {
            throw new DVTCliException("No valid language kind specified, at least one expected. Valid are: " + VALID_LANGS);
        }
        ArrayList<ResourceFilters.CliFilter> filters = ResourceFilters.computeFiltersFor(commandLine, result);
        File dotProject = new File(projectDir, ".project");
        File dotDvt = new File(projectDir, ".dvt");
        if (workspace == null) {
            throw new DVTCliException("Internal error: workspace is null");
        }
        Path projectPath = new Path(projectDir.getAbsolutePath());
        IPath workspacePath = workspace.getRoot().getLocation();
        if (workspacePath.isPrefixOf((IPath)projectPath)) {
            throw new DVTCliException("Workspace location cannot be a parent the project");
        }
        if (projectPath.isPrefixOf(workspacePath)) {
            throw new DVTCliException("Project location cannot be a parent the workspace");
        }
        if (!projectDir.exists()) {
            result.appendInfo("Project directory " + projectDir.getAbsolutePath() + " does not exist, creating new one");
            projectDir.mkdirs();
        }
        if (!projectDir.canWrite()) {
            throw new DVTCliException("Project directory is not writable");
        }
        if (dotProject.exists()) {
            if (!force) {
                throw new DVTCliException("Project description file " + dotProject.getAbsolutePath() + " already exists. Specify -force flag to overwrite.");
            }
            if (!dotProject.canWrite()) {
                throw new DVTCliException("No permissions to write " + dotProject.getAbsolutePath());
            }
            result.appendWarning("Overwriting " + dotProject.getAbsolutePath() + " (-force specified)");
        }
        this.analyzeBuildFiles(result, force, buildFiles, dotDvt);
        final IProject project = workspace.getRoot().getProject(projectName);
        boolean bl = projectExists = project == workspace.getRoot().findMember(projectName);
        if (projectExists) {
            if (!force) {
                throw new DVTCliException("Project with name " + projectName + " already exists and is located here: " + project.getLocation().toOSString() + ". Use -force to overwrite.");
            }
            result.appendWarning("Overwriting Eclipse project " + projectName + " located here: " + project.getLocation().toOSString());
        }
        final HashMap<IWorkbenchPage, Map<IEditorInput, List<String>>> editorsToBeRestored = new HashMap<IWorkbenchPage, Map<IEditorInput, List<String>>>();
        IProject sameLocationProject = this.computeSameLocationProject(workspace, (IPath)projectPath);
        if (sameLocationProject != null) {
            if (!force) {
                throw new DVTCliException("The project located here: '" + projectPath + "' already exists in this workspace under a different name. Specify -force flag to overwrite.");
            }
            result.appendWarning("Overwriting Eclipse project " + sameLocationProject.getName() + " located here: " + projectPath);
            this.closeResources(sameLocationProject, editorsToBeRestored);
            sameLocationProject.delete(false, true, monitor);
        }
        for (String name : sourceMap.keySet()) {
            if (!new File(projectDir, name).exists()) continue;
            throw new DVTCliException("A file or directory with same name as " + name + "already exists in the project directory. Please review the mappings.");
        }
        DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Argument validation time = %d ms", StopWatch.stop("[DVT-CLI]  checkfiles").timeMillisGCInvariant()));
        StopWatch.reset("[DVT-CLI]  createbuildfiles").start();
        result.appendInfo("Writing DVT configuration files");
        if (!dotDvt.exists()) {
            dotDvt.mkdir();
        }
        for (String buildFileName : buildFiles.keySet()) {
            File buildFile = new File(dotDvt, buildFileName);
            if (buildFile.exists() && !force) continue;
            DVTFileUtils.getInstance().writeStringToFile(buildFile, buildFiles.get(buildFileName).toString(), false);
        }
        DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Create DVT build files time = %d ms", StopWatch.stop("[DVT-CLI]  createbuildfiles").timeMillisGCInvariant()));
        StopWatch.reset("[DVT-CLI]  deleteoldprojectfiles").start();
        if (projectExists) {
            result.appendInfo("Deleting old project");
            this.closeResources(project, editorsToBeRestored);
            project.delete(false, true, monitor);
        }
        if (dotProject.exists()) {
            dotProject.delete();
        }
        if (closeOthers) {
            this.closeOtherProjects(monitor, projectName, result);
        }
        DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Delete old project time = %d ms", StopWatch.stop("[DVT-CLI]  deleteoldprojectfiles").timeMillisGCInvariant()));
        StopWatch.reset("[DVT-CLI]  createdotproject").start();
        result.appendInfo("Creating project");
        ResourcesPlugin.getWorkspace().checkpoint(false);
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        projectDescription.setLocation((IPath)new Path(projectDir.getAbsolutePath()));
        ArrayList<String> natureIds = new ArrayList<String>();
        for (LanguageKind lk : selectedLangs) {
            natureIds.add(lk.NATURE_ID);
            if (lk != LanguageKind.PF) continue;
            natureIds.add("org.eclipse.dltk.tcl.core.nature");
        }
        if (natureIds.size() > 1) {
            natureIds.add(0, "ro.amiq.dvt.dvtnature");
        }
        projectDescription.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
        ICommand buildCommand = projectDescription.newCommand();
        buildCommand.setBuilderName("ro.amiq.dvt.MixedLangBuilder");
        projectDescription.setBuildSpec(new ICommand[]{buildCommand});
        project.create(projectDescription, monitor);
        DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Create new .project file time = %d ms", StopWatch.stop("[DVT-CLI]  createdotproject").timeMillisGCInvariant()));
        String buildConfigFileName = this.createBuildFileIfNotExists((IPath)projectPath, BuildConfigManager.computeActiveBuildConfig(project));
        boolean isBuildConfigAuto = false;
        if (!commandLine.hasOption("disable_fs_check")) {
            StopWatch.reset("[DVT-CLI]  fscheck").start();
            this.performFSCheck(project, result, filters);
            DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Filesystem check time = %d ms", StopWatch.stop("[DVT-CLI]  fscheck").timeMillisGCInvariant()));
        }
        StopWatch.reset("[DVT-CLI]  computeincludeautofilters").start();
        if (this.autoFilterResources) {
            JSONObject jSONObject = ResourceFilterUtils.runAutoFiltersHelperMain((IPath)projectPath, buildConfigFileName, natureIds, result);
            ArrayList<String> resourceFilters = new ArrayList<String>();
            try {
                isBuildConfigAuto = jSONObject.getBoolean("IS_BUILD_CONFIG_KIND_AUTO_KEY");
                JSONArray jsonArr = (JSONArray)jSONObject.get("RESOURCE_FILTERS_KEY");
                int i3 = 0;
                while (i3 < jsonArr.length()) {
                    resourceFilters.add((String)jsonArr.get(i3));
                    ++i3;
                }
            }
            catch (JSONException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            filters.addAll(ResourceFilters.getAutoIncludeFilters(this.autoFilterThreshold, (IPath)projectPath, resourceFilters, this.autoFiltersFirstLevel));
        }
        if (this.autoFiltersFirstLevel) {
            filters.addAll(ResourceFilters.computeFirstLevelFilters(project));
        }
        DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Compute -include auto filters time = %d ms.", StopWatch.stop("[DVT-CLI]  computeincludeautofilters").timeMillisGCInvariant()));
        if (commandLine.hasOption("openResourceFilterDialog")) {
            ResourceFilters.addProjectDirectoryFilters(projectPath.toOSString(), projectName, filters);
        }
        StopWatch.reset("[DVT-CLI]  applyfilters").start();
        ResourceFilters.applyFilters(project, filters, monitor);
        DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Apply filters time = %d ms", StopWatch.stop("[DVT-CLI]  applyfilters").timeMillisGCInvariant()));
        StopWatch.reset("[DVT-CLI]  openproject").start();
        try {
            project.open(monitor);
            DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Open project time = %d ms", StopWatch.stop("[DVT-CLI]  openproject").timeMillisGCInvariant()));
            StopWatch.reset("[DVT-CLI]  refreshproject").start();
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new DVTCliException(OPEN_PROJECT_CANCELED);
        }
        if (this.autoFilterResources && isBuildConfigAuto) {
            project.setSessionProperty(DVTStartupConstants.QN_DVT_DONT_RUN_AUTOCONFIG, (Object)true);
        }
        project.setSessionProperty(DVTStartupConstants.QN_DVT_DONT_RESTORE, (Object)true);
        try {
            project.refreshLocal(2, monitor);
            DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Project refresh time = %d ms", StopWatch.stop("[DVT-CLI]  refreshproject").timeMillisGCInvariant()));
            StopWatch.reset("[DVT-CLI]  createlinkresources").start();
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new DVTCliException(PROJECT_REFRESH_CANCELED);
        }
        if (DVTEclipseCDTUtils.INSTANCE.checkNoCPPProjectNature(project)) {
            DVTEclipseCDTUtils.INSTANCE.backupDotCProjectFile(project, monitor);
        }
        if (commandLine.hasOption("lint")) {
            project.setSessionProperty(DVTStartupConstants.QN_DVT_START_LINTING, (Object)commandLine.getOptionValue("lint"));
        }
        BuildConfigManager.updateActiveBuildConfig(project);
        result.appendInfo("Creating linked resources");
        for (Map.Entry entry : sourceMap.entrySet()) {
            String name = (String)entry.getKey();
            IFolder linkedFolder = project.getFolder((IPath)new Path(name));
            IPath path = Path.fromOSString((String)DVTEnvVariableResolver.toDvtEnvVariables((CharSequence)((CharSequence)entry.getValue())));
            DVTStringBuilder processed = new DVTStringBuilder();
            int nofUpdirs = 0;
            String[] stringArray2 = path.segments();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String segment = stringArray2[n4];
                if (!segment.equals("..")) {
                    processed.append(segment).append("/");
                } else {
                    ++nofUpdirs;
                }
                ++n4;
            }
            if (nofUpdirs != 0) {
                processed.prepend("${PARENT-" + nofUpdirs + "-PROJECT_LOC}/");
            }
            if (path.isAbsolute()) {
                processed.prepend("/");
            }
            linkedFolder.createLink((IPath)new Path(processed.toString()), 16, monitor);
        }
        DVTLogger.INSTANCE.logInfo(String.format("[DVT-CLI] Create link resources time = %d ms", StopWatch.stop("[DVT-CLI]  createlinkresources").timeMillisGCInvariant()));
        Object var29_40 = null;
        if (selectedLangs.size() == 1) {
            LanguageKind languageKind = (LanguageKind)((Object)selectedLangs.iterator().next());
        }
        CreateProject.handlePerspectiveSwitch(commandLine, var29_42 == null ? null : var29_42.PERSPECTIVE_ID);
        DVTMixedLangModelManager.getInstance().addBuildDoneListener(new IBuildDoneListener(){

            @Override
            public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
                if (!IBuildDoneListener.BuildFinishReason.isFullBuild(buildFinishReason) || IBuildDoneListener.BuildFinishReason.isCanceled(buildFinishReason)) {
                    return;
                }
                if (!projectName.equals(project.getName())) {
                    DVTMixedLangModelManager.getInstance().removeBuildDoneListener(this);
                    editorsToBeRestored.clear();
                    return;
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                    try {
                        for (Map.Entry entry : editorsToBeRestored.entrySet()) {
                            IWorkbenchPage workbenchPage = (IWorkbenchPage)entry.getKey();
                            Map editorsToBeRestoredEntryValue = (Map)entry.getValue();
                            for (Map.Entry entry2 : editorsToBeRestoredEntryValue.entrySet()) {
                                IEditorInput editorInput = (IEditorInput)entry2.getKey();
                                for (String editorId : (List)entry2.getValue()) {
                                    if (!editorInput.exists()) continue;
                                    workbenchPage.openEditor(editorInput, editorId, true, 3);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                });
                if (!DVT_SHARE_PROJECT_SYNCHRONIZED) {
                    CreateProject.this.shareProject(result, commandLine, project);
                }
                DVTMixedLangModelManager.getInstance().removeBuildDoneListener(this);
                editorsToBeRestored.clear();
            }
        });
        IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
        if (commandLine.hasOption("workingset")) {
            window = CreateProject.handleWorkingSetNewWindow(project, commandLine.hasOption("newwindow"), result);
        }
        CreateProject.handleSelection(window, project);
        if (DVT_SHARE_PROJECT_SYNCHRONIZED) {
            this.shareProject(result, commandLine, project);
        }
        if ((cppNatureContributor = NatureContributors.getContributor(LanguageKind.CPP)) != null && cppNatureContributor.hasNature(project)) {
            cppNatureContributor.activateNature(project);
            return;
        }
        try {
            project.build(9, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new DVTCliException("Project build was canceled");
        }
    }

    private IProject computeSameLocationProject(IWorkspace workspace, IPath projectPath) {
        IProject[] projects;
        IContainer container = workspace.getRoot().getContainerForLocation(projectPath);
        if (container != null && container instanceof IProject) {
            return (IProject)container;
        }
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects(8);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (projectPath.equals((Object)project.getLocation())) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private void shareProject(DVTCliHandlerV1.ResultBuilder result, CommandLine commandLine, IProject project) {
        try {
            if (commandLine.hasOption("clearcase")) {
                CreateProject.handleShareWithClearcase(project, result);
            }
            if (commandLine.hasOption("svn")) {
                CreateProject.handleShareWithSVN(project, commandLine.getOptionValue("svn"), result);
            }
            if (commandLine.hasOption("p4")) {
                CreateProject.handleShareWithPerforce(project, commandLine.getOptionValue("p4"), result);
            }
            if (commandLine.hasOption("git")) {
                CreateProject.handleGitRepos(project, commandLine.getOptionValue("git"), result);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void clearRestoreInhibited() {
        IPath workspaceIPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceIPath == null) {
            return;
        }
        File dontRestoreFile = workspaceIPath.append("dvt_dont_restore").toFile();
        if (dontRestoreFile.exists() && !dontRestoreFile.delete()) {
            DVTLogger.INSTANCE.logInfo("Failed to remove restore lock file '" + dontRestoreFile.getAbsolutePath() + "'");
        }
    }

    private void computeIncludeArguments(String[] optionValue) throws DVTCliException {
        String autoValue = null;
        int i = 0;
        while (i < optionValue.length) {
            if (optionValue[i].startsWith("auto")) {
                autoValue = optionValue[i];
            }
            if (optionValue[i].equals("first_level")) {
                this.autoFiltersFirstLevel = true;
            }
            if (autoValue != null && this.autoFiltersFirstLevel) break;
            ++i;
        }
        if (autoValue == null) {
            return;
        }
        if (autoValue.equals("auto")) {
            this.autoFilterResources = true;
            this.autoFilterThreshold = 500;
            return;
        }
        if (!autoValue.matches("auto:\\d+")) {
            throw new DVTCliException("Invalid -include " + autoValue + ", should be -include auto:<threshold>");
        }
        this.autoFilterThreshold = Integer.parseInt(autoValue.substring("auto".length() + 1));
        this.autoFilterResources = true;
    }

    private void analyzeBuildFiles(DVTCliHandlerV1.ResultBuilder result, boolean force, StringBuilderMap buildFiles, File dotDvt) throws DVTCliException {
        for (String buildFileName : buildFiles.keySet()) {
            File buildFile = new File(dotDvt, buildFileName);
            if (!buildFile.exists()) continue;
            if (!force) {
                throw new DVTCliException("Build config file '" + buildFile.getAbsolutePath() + "' already exists. Specify -force flag to overwrite.");
            }
            if (!buildFile.canWrite()) {
                throw new DVTCliException("No permissions to write " + buildFile.getAbsolutePath());
            }
            result.appendWarning("Overwriting " + buildFile.getAbsolutePath() + " (-force specified)");
        }
        File defaultBuildFile = new File(dotDvt, "default.build");
        if (!buildFiles.contains("default.build") && defaultBuildFile.exists()) {
            result.appendInfo("Reusing existing: " + defaultBuildFile.getAbsolutePath() + " because none of -f, -F, -top or -test was specified and no build configuration content specified.");
        }
    }

    private void checkBuildConfigFlags(CommandLine commandLine) throws DVTCliException {
        EnumSet<BCFlag> flags = EnumSet.noneOf(BCFlag.class);
        BCFlag[] bCFlagArray = BCFlag.values();
        int n = bCFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            BCFlag f = bCFlagArray[n2];
            if (commandLine.hasOption(f.toString())) {
                flags.add(f);
            }
            ++n2;
        }
        ArrayList<BCFlag> oldFlags = new ArrayList<BCFlag>(Arrays.asList(BCFlag.f, BCFlag.F, BCFlag.top, BCFlag.test));
        oldFlags.retainAll(flags);
        if (flags.contains((Object)BCFlag.build_config) && !oldFlags.isEmpty()) {
            throw new DVTCliException("It is not allowed to mix -" + oldFlags + " with -build or -<name>.build");
        }
        oldFlags.retainAll(Arrays.asList(BCFlag.F, BCFlag.f));
        if (oldFlags.size() == 2) {
            throw new DVTCliException("-f and -F are mutually exclusive");
        }
    }

    private void closeResources(IProject project, Map<IWorkbenchPage, Map<IEditorInput, List<String>>> editorsToBeRestored) {
        final HashMap<IWorkbenchPage, ArrayList<IEditorReference>> editorsToBeClosed = new HashMap<IWorkbenchPage, ArrayList<IEditorReference>>();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = workbenchPage.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    try {
                        IEditorInput editorInput = editorReference.getEditorInput();
                        if (editorInput != null && !(editorInput instanceof ILinterReportInput)) {
                            List<String> idList;
                            ArrayList<IEditorReference> pageEditors = (ArrayList<IEditorReference>)editorsToBeClosed.get(editorReference.getPage());
                            if (pageEditors == null) {
                                pageEditors = new ArrayList<IEditorReference>();
                                editorsToBeClosed.put(editorReference.getPage(), pageEditors);
                            }
                            pageEditors.add(editorReference);
                            Map<IEditorInput, List<String>> map = editorsToBeRestored.get(editorReference.getPage());
                            if (map == null) {
                                map = new HashMap<IEditorInput, List<String>>();
                                editorsToBeRestored.put(editorReference.getPage(), map);
                            }
                            if ((idList = map.get(editorInput)) == null) {
                                idList = new ArrayList<String>();
                                map.put(editorInput, idList);
                            }
                            idList.add(editorReference.getId());
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                for (IWorkbenchPage page : editorsToBeClosed.keySet()) {
                    List editors = (List)editorsToBeClosed.get(page);
                    IEditorReference[] editorRefs = editors.toArray(new IEditorReference[editors.size()]);
                    page.closeEditors(editorRefs, false);
                }
            }
        });
    }

    public boolean matches(String command) {
        return Objects.equals(command, "createProject") || Objects.equals(command, "createEProject") || Objects.equals(command, "createSVProject");
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"perspective"));
        options.addOption(OptionBuilder.create((String)"workingset"));
        options.addOption(OptionBuilder.create((String)"newwindow"));
        options.addOption(OptionBuilder.create((String)"force"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.hasArgs((int)2);
        options.addOption(OptionBuilder.create((String)"map"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"name"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"exclude"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"include"));
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"lang"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"top"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"test"));
        options.addOption(OptionBuilder.create((String)"clearcase"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"svn"));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)"p4"));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)"git"));
        OptionBuilder.hasArgs((int)2);
        options.addOption(OptionBuilder.create((String)"build_config"));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)"build"));
        options.addOption(OptionBuilder.create((String)"close_others"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"lint"));
        options.addOption(OptionBuilder.create((String)"openResourceFilterDialog"));
        options.addOption(OptionBuilder.create((String)"disable_fs_check"));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }

    private void performFSCheck(IProject project, DVTCliHandlerV1.ResultBuilder result, ArrayList<ResourceFilters.CliFilter> filters) {
        if (this.autoFilterResources || this.autoFiltersFirstLevel) {
            return;
        }
        IPath location = project.getLocation();
        if (location == null) {
            return;
        }
        File projectDir = location.toFile();
        LinkedHashMap<IContainer, List<Filter>> computedFilters = new LinkedHashMap<IContainer, List<Filter>>();
        LinkedHashSet<Pattern> excludedProjectRelativePath = new LinkedHashSet<Pattern>();
        LinkedHashSet<Pattern> includedProjectRelativePath = new LinkedHashSet<Pattern>();
        ResourceFilters.computeFiltersFromCLI(project, filters, computedFilters, includedProjectRelativePath, excludedProjectRelativePath);
        long startTimeMillis = System.currentTimeMillis();
        StringBuilder info = new StringBuilder();
        int nrOfFiles = ResourceFilterUtils.countChildrenRecursively(projectDir, 50000, 10000L, false, computedFilters, excludedProjectRelativePath, includedProjectRelativePath);
        if (System.currentTimeMillis() - startTimeMillis >= 10000L) {
            this.autoFilterThreshold = 500;
            this.autoFilterResources = true;
            this.autoFiltersFirstLevel = true;
            info.append(SLOW_FS_INFO);
            info.append("(It takes more than 10000 ms to list all files). ");
        } else if (nrOfFiles >= 50000) {
            this.autoFilterThreshold = 500;
            this.autoFilterResources = true;
            this.autoFiltersFirstLevel = true;
            info.append(TOO_MANY_RESOURCES_INFO);
            info.append("(more than 50000 children). ");
        }
        if (!info.toString().isEmpty()) {
            info.append(AUTOMATICALLY_ADD_INCLUDE_AUTO_INFO);
            result.appendInfo(info.toString());
            result.appendWarning(LAUNCHER_WARNING);
        }
    }

    static enum BCFlag {
        F,
        f,
        top,
        test,
        build_config;

    }
}

