/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.DVTEclipseCDTUtils;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.cli.CreateImportProjectBase;
import ro.amiq.dvt.startup.DVTPerspectiveSwitcher;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.ui.Utils;

public class ImportProject
extends CreateImportProjectBase {
    public String getCommandName() {
        return "importProject";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        IProjectDescription projectDescription;
        boolean inWorkingSet = false;
        boolean inNewWindow = false;
        boolean shareWithClearcase = false;
        boolean closeOthers = false;
        String svnRepo = null;
        String shareWithPerforce = null;
        String gitRepos = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (commandLine.getArgs().length < 2) {
            throw new DVTCliException("You did not specify the project location. It has to be the first parameter.");
        }
        String location = commandLine.getArgs()[1];
        File projectDir = new File(location);
        if (!projectDir.isAbsolute()) {
            try {
                projectDir = new File(cwd, location).getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new DVTCliException("Invalid project location.");
            }
        }
        if (commandLine.hasOption("workingset")) {
            inWorkingSet = true;
        }
        if (commandLine.hasOption("newwindow")) {
            inNewWindow = true;
        }
        if (commandLine.hasOption("clearcase")) {
            shareWithClearcase = true;
        }
        if (commandLine.hasOption("svn")) {
            svnRepo = commandLine.getOptionValue("svn");
        }
        if (commandLine.hasOption("p4")) {
            shareWithPerforce = commandLine.getOptionValue("p4");
        }
        if (commandLine.hasOption("git")) {
            gitRepos = commandLine.getOptionValue("git");
        }
        if (commandLine.hasOption("close_others")) {
            closeOthers = true;
        }
        if (!projectDir.exists()) {
            throw new DVTCliException("Project directory " + projectDir.getAbsolutePath() + " does not exist");
        }
        File dotProject = new File(projectDir, ".project");
        if (!dotProject.exists()) {
            throw new DVTCliException("No project found @ " + projectDir.getAbsolutePath());
        }
        IPath projectDescriptionFile = Path.fromOSString((String)dotProject.getAbsolutePath());
        try {
            projectDescription = workspace.loadProjectDescription(projectDescriptionFile);
        }
        catch (Exception exception) {
            throw new DVTCliException("Invalid project description!");
        }
        String projectName = projectDescription.getName();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            if (project.getLocation().toFile().equals(projectDir)) {
                result.appendInfo("Project already exists");
                IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
                if (inWorkingSet) {
                    window = ImportProject.handleWorkingSetNewWindow(project, inNewWindow, result);
                }
                ImportProject.handleSelection(window, project);
                if (shareWithClearcase) {
                    ImportProject.handleShareWithClearcase(project, result);
                }
                if (svnRepo != null) {
                    ImportProject.handleShareWithSVN(project, svnRepo, result);
                }
                if (shareWithPerforce != null) {
                    ImportProject.handleShareWithPerforce(project, shareWithPerforce, result);
                }
                if (gitRepos != null) {
                    ImportProject.handleGitRepos(project, gitRepos, result);
                }
                if (closeOthers) {
                    this.closeOtherProjects(monitor, projectName, result);
                }
                return;
            }
            if (commandLine.hasOption("force")) {
                result.appendWarning("Will replace already existing project with same name located @ " + project.getLocation().toOSString() + " (-" + "force" + " specified)");
                project.delete(false, true, monitor);
            } else {
                throw new DVTCliException("Project with same name already exists but is located @ " + project.getLocation().toOSString());
            }
        }
        project.create(projectDescription, monitor);
        project.open(monitor);
        if (DVTEclipseCDTUtils.INSTANCE.checkNoCPPProjectNature(project)) {
            DVTEclipseCDTUtils.INSTANCE.backupDotCProjectFile(project, monitor);
        }
        project.setSessionProperty(DVTStartupConstants.QN_DVT_TRY_RESTORE, (Object)true);
        BuildConfigManager.updateActiveBuildConfig(project);
        IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
        if (inWorkingSet) {
            window = ImportProject.handleWorkingSetNewWindow(project, inNewWindow, result);
        }
        ImportProject.handlePerspectiveSwitch(commandLine, null);
        ImportProject.handleSelection(window, project);
        if (shareWithClearcase) {
            ImportProject.handleShareWithClearcase(project, result);
        }
        if (shareWithPerforce != null) {
            ImportProject.handleShareWithPerforce(project, shareWithPerforce, result);
        }
        if (svnRepo != null) {
            ImportProject.handleShareWithSVN(project, svnRepo, result);
        }
        DVTPerspectiveSwitcher.switchPerspective((String)ImportProject.getPerspectiveName(project));
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(OptionBuilder.create((String)"workingset"));
        options.addOption(OptionBuilder.create((String)"newwindow"));
        options.addOption(OptionBuilder.create((String)"force"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"perspective"));
        options.addOption(OptionBuilder.create((String)"clearcase"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"svn"));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)"p4"));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)"git"));
        options.addOption(OptionBuilder.create((String)"close_others"));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }
}

