/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;

public class LaunchRunConfig
extends AbstractCliHandlerDelegate {
    private static final String NAME = "name";
    private static final String BLOCKING = "blocking";
    private static final String DEBUG = "debug";

    public String getCommandName() {
        return "launchRunConfig";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        ILaunchConfiguration launchConfig;
        boolean blocking = commandLine.hasOption(BLOCKING);
        if (!commandLine.hasOption(NAME)) {
            throw new DVTCliException("Internal error: missing launch configuration name.");
        }
        String launchConfigName = commandLine.getOptionValue(NAME);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations();
        if (launchConfigurations.length == 0) {
            throw new DVTCliException("There are no launch configurations defined!");
        }
        String launchMode = commandLine.hasOption(DEBUG) ? DEBUG : "run";
        ArrayList<ILaunchConfiguration> candidates = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            launchConfig = iLaunchConfigurationArray[n2];
            if (launchConfig.getName().equals(launchConfigName)) {
                if (!launchConfig.supportsMode(launchMode)) {
                    result.appendInfo("Launch configuration '" + this.getDisplayName(launchConfig) + "' matches the required name but does not support '" + launchMode + "' mode.");
                } else {
                    candidates.add(launchConfig);
                }
            }
            ++n2;
        }
        if (candidates.isEmpty()) {
            throw new DVTCliException("Unable to find a launch configuration called '" + launchConfigName + "' that supports '" + launchMode + "' mode.");
        }
        launchConfig = (ILaunchConfiguration)candidates.get(0);
        if (candidates.size() > 1) {
            result.appendInfo("Several matching configurations found, launching '" + this.getDisplayName(launchConfig) + "'.");
        }
        if (blocking) {
            ILaunchConfigurationWorkingCopy launchConfigWC = launchConfig.getWorkingCopy();
            launchConfigWC.setAttribute("ro.amiq.dvt.launch.PREPEND_OUTPUT", false);
            launchConfigWC.launch(launchMode, monitor);
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)launchMode));
        }
    }

    private String getDisplayName(ILaunchConfiguration launchConfig) {
        IFile file = launchConfig.getFile();
        String result = file != null ? file.getFullPath().toOSString() : launchConfig.getName();
        try {
            ILaunchConfigurationType type = launchConfig.getType();
            result = String.valueOf(result) + " (" + type.getName() + ")";
        }
        catch (Exception exception) {}
        return result;
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(OptionBuilder.create((String)BLOCKING));
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)NAME));
        options.addOption(OptionBuilder.create((String)DEBUG));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().c();
    }
}

