/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.utils.CompiledFilesContributorsExtensionRegistry;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.ICompiledFilesContributor;

public class ListCompiledFilesHandler
extends AbstractCliHandlerDelegate {
    public String getCommandName() {
        return "listCompiledFiles";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        String projectName = commandLine.getOptionValue("project");
        if (projectName == null) {
            throw new DVTCliException("You must specify for which project you want to list the compiled files.");
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.exists()) {
            throw new DVTCliException("Project '" + projectName + "' does not exist in the workspace.");
        }
        if (!project.isOpen()) {
            throw new DVTCliException("Project '" + projectName + "' is not open.");
        }
        boolean unique = false;
        if (commandLine.hasOption("unique")) {
            unique = true;
        }
        AtomicBoolean dirs = new AtomicBoolean(false);
        if (commandLine.hasOption("dirs")) {
            dirs.set(true);
        }
        String separator = "\n";
        if (commandLine.hasOption("separator")) {
            separator = commandLine.getOptionValue("separator");
        }
        EnumSet<LanguageKind> availLangs = EnumSet.noneOf(LanguageKind.class);
        for (ICompiledFilesContributor delegate : CompiledFilesContributorsExtensionRegistry.getDelegates()) {
            LanguageKind kind = delegate.getKind();
            if (!project.hasNature(kind.NATURE_ID)) continue;
            availLangs.add(kind);
        }
        LinkedHashSet<LanguageKind> selectedLangs = new LinkedHashSet<LanguageKind>();
        if (commandLine.hasOption("lang")) {
            String[] stringArray = commandLine.getOptionValues("lang");
            int n = stringArray.length;
            int kind = 0;
            while (kind < n) {
                String lang = stringArray[kind];
                try {
                    LanguageKind selectedLang = LanguageKind.valueOf(lang.toUpperCase());
                    if (!availLangs.contains((Object)selectedLang)) {
                        throw new IllegalArgumentException();
                    }
                    selectedLangs.add(selectedLang);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new DVTCliException("Invalid language " + lang + ". Valid are: " + DVTStringUtil.join(availLangs, ", ") + ".");
                }
                ++kind;
            }
        }
        if (selectedLangs.isEmpty()) {
            selectedLangs.addAll(availLangs);
        }
        ArrayList<File> initialFiles = new ArrayList<File>();
        for (ICompiledFilesContributor delegate : CompiledFilesContributorsExtensionRegistry.getDelegates()) {
            if (!selectedLangs.contains((Object)delegate.getKind())) continue;
            initialFiles.addAll(delegate.getCompiledFiles(project));
        }
        if (initialFiles.isEmpty()) {
            throw new DVTCliException("There are no files compiled in project " + projectName + ".");
        }
        ArrayList tmpFiles = new ArrayList();
        initialFiles.stream().forEach(file -> {
            boolean bl = tmpFiles.add(dirs.get() ? file.getParent() : file.getPath());
        });
        AbstractCollection finalFiles = unique ? new LinkedHashSet(tmpFiles) : tmpFiles;
        Iterator iterator = finalFiles.iterator();
        while (iterator.hasNext()) {
            result.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            result.append(separator);
        }
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(OptionBuilder.create((String)"unique"));
        options.addOption(OptionBuilder.create((String)"dirs"));
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"project"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"separator"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"lang"));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().c();
    }
}

