/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import ro.amiq.dvt.cli.FakeResourceFileStoreEditorInput;
import ro.amiq.dvt.startup.core.DVTLogger;

public class LocalNonWorkspaceTypedElement
extends LocalResourceTypedElement {
    private final IPath path;
    private final boolean isSymlink;
    private final boolean isFile;
    private boolean exists;
    private boolean dirty;
    private long timestamp;
    private boolean useSharedDocument = true;
    private EditableSharedDocumentAdapter sharedDocumentAdapter;
    private EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener;
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private byte[] modifiedContent;
    private String symLink;

    public LocalNonWorkspaceTypedElement(IPath path) {
        super((IResource)ROOT.getFile(path));
        this.path = path;
        File file = path.toFile();
        this.isSymlink = Files.isSymbolicLink(file.toPath());
        this.isFile = file.isFile();
        boolean bl = this.exists = this.isFile || this.isSymlink || file.exists();
        if (this.exists) {
            this.timestamp = file.lastModified();
        }
    }

    public InputStream getContents() throws CoreException {
        if (this.modifiedContent != null) {
            return new ByteArrayInputStream(this.modifiedContent);
        }
        return this.createStream();
    }

    public void setContent(byte[] contents) {
        this.dirty = true;
        this.modifiedContent = contents;
        this.fireContentChanged();
    }

    public byte[] getContent() {
        block13: {
            if (this.modifiedContent == null) {
                InputStream is = null;
                try {
                    try {
                        is = this.createStream();
                        this.modifiedContent = this.readAllBytes(is);
                    }
                    catch (IOException | CoreException e) {
                        DVTLogger.INSTANCE.logError(e);
                        if (is == null) break block13;
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            DVTLogger.INSTANCE.logError((Throwable)e2);
                        }
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                }
            }
        }
        return this.modifiedContent;
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] temp = new byte[1024];
        while ((bytesRead = inputStream.read(temp)) != -1) {
            buffer.write(temp, 0, bytesRead);
        }
        return buffer.toByteArray();
    }

    public void discardBuffer() {
        super.discardBuffer();
        if (this.sharedDocumentAdapter != null) {
            this.sharedDocumentAdapter.releaseBuffer();
        }
        this.modifiedContent = null;
    }

    protected InputStream createStream() throws CoreException {
        if (this.exists) {
            try {
                File file = this.path.toFile();
                this.timestamp = file.lastModified();
                if (this.isSymlink) {
                    this.symLink = LocalNonWorkspaceTypedElement.readSymLink(file);
                    return Files.newInputStream(Paths.get(this.symLink, new String[0]), new OpenOption[0]);
                }
                return Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (IOException | UnsupportedOperationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return null;
    }

    public static byte[] encode(String str) {
        byte[] arr;
        ByteBuffer bb = StandardCharsets.UTF_8.encode(str);
        int len = bb.limit();
        if (bb.hasArray() && bb.arrayOffset() == 0 && (arr = bb.array()).length == len) {
            return arr;
        }
        arr = new byte[len];
        bb.get(arr);
        return arr;
    }

    public static String readSymLink(File path) throws IOException {
        Path nioPath = path.toPath();
        Path target = Files.readSymbolicLink(nioPath);
        String targetString = target.toString();
        return targetString;
    }

    public boolean isEditable() {
        return this.exists && (this.isFile || this.isSymlink);
    }

    public long getModificationDate() {
        return this.timestamp;
    }

    public boolean isSynchronized() {
        return this.path.toFile().lastModified() == this.timestamp;
    }

    public void update() {
        this.exists = this.path.toFile().exists();
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isSharedDocumentsEnable() {
        return this.useSharedDocument && !this.isSymlink && this.isEditable();
    }

    public void enableSharedDocument(boolean enablement) {
        this.useSharedDocument = enablement;
    }

    private void refreshTimestamp() {
        this.timestamp = this.path.toFile().lastModified();
    }

    public void commit(IProgressMonitor monitor) throws CoreException {
        if (this.isDirty()) {
            block19: {
                if (this.isConnected()) {
                    super.commit(monitor);
                } else {
                    File file = this.path.toFile();
                    try {
                        try {
                            byte[] contents = this.getContent();
                            if (this.isSymlink) {
                                file = new File(this.symLink);
                            }
                            Throwable throwable = null;
                            Object var5_7 = null;
                            try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                                out.write(contents);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            this.dirty = false;
                        }
                        catch (IOException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            this.fireContentChanged();
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        this.fireContentChanged();
                        throw throwable;
                    }
                    this.fireContentChanged();
                }
            }
            this.refreshTimestamp();
        }
    }

    public static IContainer getContainerForLocation(IPath location, boolean innerMost) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer dir = root.getContainerForLocation(location);
        if (dir == null) {
            return null;
        }
        if (!innerMost && dir.isAccessible() && !dir.isLinked(512)) {
            return dir;
        }
        URI uri = URIUtil.toURI((IPath)location);
        IContainer dir2 = LocalNonWorkspaceTypedElement.getContainerForLocationURI(root, uri);
        if (dir2 == null && dir.isAccessible() && !dir.isLinked(512)) {
            return dir;
        }
        return dir2;
    }

    private static IContainer getContainerForLocationURI(IWorkspaceRoot root, URI uri) {
        IContainer[] containers = root.findContainersForLocationURI(uri);
        return (IContainer)LocalNonWorkspaceTypedElement.getExistingMappedResourceWithShortestPath((IResource[])containers);
    }

    private static <T extends IResource> T getExistingMappedResourceWithShortestPath(T[] resources) {
        int shortestPathSegmentCount = Integer.MAX_VALUE;
        T shortestPath = null;
        T[] TArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IPath fullPath;
            int segmentCount;
            T resource = TArray[n2];
            if (resource.exists() && (segmentCount = (fullPath = resource.getFullPath()).segmentCount()) < shortestPathSegmentCount) {
                shortestPath = resource;
                shortestPathSegmentCount = segmentCount;
            }
            ++n2;
        }
        return shortestPath;
    }

    public synchronized boolean isDirty() {
        return this.dirty || this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.hasBufferedContents();
    }

    public boolean isConnected() {
        return this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.isConnected();
    }

    public boolean saveDocument(boolean overwrite, IProgressMonitor monitor) throws CoreException {
        if (this.isConnected()) {
            IEditorInput input = this.sharedDocumentAdapter.getDocumentKey((Object)this);
            this.sharedDocumentAdapter.saveDocument(input, overwrite, monitor);
            this.refreshTimestamp();
            return true;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISharedDocumentAdapter.class) {
            if (this.isSharedDocumentsEnable()) {
                return this.getSharedDocumentAdapter();
            }
            return null;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setSharedDocumentListener(EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener) {
        this.sharedDocumentListener = sharedDocumentListener;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LocalNonWorkspaceTypedElement other = (LocalNonWorkspaceTypedElement)((Object)obj);
        return this.path.equals((Object)other.path);
    }

    private synchronized ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                    LocalNonWorkspaceTypedElement.this.refreshTimestamp();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentConnected();
                    }
                }

                public void handleDocumentFlushed() {
                    LocalNonWorkspaceTypedElement.this.fireContentChanged();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentFlushed();
                    }
                }

                public void handleDocumentDeleted() {
                    LocalNonWorkspaceTypedElement.this.update();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentDeleted();
                    }
                }

                public void handleDocumentSaved() {
                    LocalNonWorkspaceTypedElement.this.refreshTimestamp();
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentSaved();
                    }
                }

                public void handleDocumentDisconnected() {
                    if (LocalNonWorkspaceTypedElement.this.sharedDocumentListener != null) {
                        LocalNonWorkspaceTypedElement.this.sharedDocumentListener.handleDocumentDisconnected();
                    }
                }
            }){

                public IEditorInput getDocumentKey(Object element) {
                    IFileStore store;
                    if (element == LocalNonWorkspaceTypedElement.this && (store = EFS.getLocalFileSystem().getStore(LocalNonWorkspaceTypedElement.this.path)) != null) {
                        return new FakeResourceFileStoreEditorInput(store, LocalNonWorkspaceTypedElement.this.getResource());
                    }
                    return super.getDocumentKey(element);
                }

                public void connect(IDocumentProvider provider, IEditorInput documentKey) throws CoreException {
                    if (documentKey instanceof FakeResourceFileStoreEditorInput) {
                        FakeResourceFileStoreEditorInput input = (FakeResourceFileStoreEditorInput)documentKey;
                        try {
                            input.setResource(null);
                            super.connect(provider, (IEditorInput)input);
                        }
                        finally {
                            input.setResource(LocalNonWorkspaceTypedElement.this.getResource());
                        }
                    } else {
                        super.connect(provider, documentKey);
                    }
                }
            };
        }
        return this.sharedDocumentAdapter;
    }
}

