/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.texteditor.IDocumentProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class OpenFileHandler
extends AbstractCliHandlerDelegate {
    public static final String LINE = "line";
    public static final String PROJECT = "project";
    public static final String SHOW_IN_NAVIGATOR = "showInNavigator";

    public String getCommandName() {
        return "openFile";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        boolean multipleFiles;
        IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (commandLine.getArgs().length < 2) {
            throw new DVTCliException("You did not specify the path to file. It has to be the first parameter.");
        }
        String projectName = commandLine.getOptionValue(PROJECT);
        IProject[] project = new IProject[1];
        if (projectName != null) {
            project[0] = wRoot.getProject(projectName);
            if (project[0] == null || !project[0].exists()) {
                throw new DVTCliException("Project '" + projectName + "' does not exist in the workspace.");
            }
        }
        Integer[] lineNo = new Integer[]{1};
        String lineNoString = commandLine.getOptionValue(LINE);
        boolean bl = multipleFiles = commandLine.getArgs().length > 2;
        if (multipleFiles) {
            if (lineNoString != null) {
                throw new DVTCliException("Unsuported argument '-line' when opening multiple files");
            }
            int startIndex = 1;
            int endIndex = commandLine.getArgs().length;
            String[] stringArray = Arrays.copyOfRange(commandLine.getArgs(), startIndex, endIndex);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                try {
                    lineNo[0] = -1;
                    this.openFile(wRoot, commandLine, cwd, path, project, lineNo);
                }
                catch (DVTCliException e) {
                    result.appendWarning(e.getMessage());
                }
                ++n2;
            }
        } else {
            String path = commandLine.getArgs()[1];
            if (lineNoString != null) {
                try {
                    lineNo[0] = Integer.parseInt(lineNoString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DVTCliException("Invalid line number: '" + lineNoString + "'.");
                }
            }
            this.openFile(wRoot, commandLine, cwd, path, project, lineNo);
        }
    }

    private void openFile(IWorkspaceRoot wRoot, CommandLine commandLine, String pwd, String path, IProject[] project, final Integer[] lineNo) throws DVTCliException, CoreException {
        if (pwd == null || path == null) {
            throw new DVTCliException("Could not determine path '" + path + "' from command.");
        }
        IPath iPath = Path.fromOSString((String)path);
        iPath = iPath.isAbsolute() ? iPath : Path.fromOSString((String)pwd).append(iPath);
        final File file = iPath.toFile();
        if (!file.exists()) {
            throw new DVTCliException("File '" + file.getAbsolutePath() + "' does not exist.");
        }
        final AtomicBoolean showInNavigator = new AtomicBoolean(false);
        if (commandLine.hasOption(SHOW_IN_NAVIGATOR)) {
            showInNavigator.set(true);
        }
        final Exception[] exc = new Exception[1];
        IFile iFile = null;
        if (project[0] != null) {
            iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project[0], file.getAbsolutePath());
        }
        if (iFile == null) {
            iFile = (IFile)this.findFileAndRefreshParentFolder(wRoot, file, project[0]);
        }
        final IFile finalIFile = iFile;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String fileName = file.getName();
                    if (fileName.endsWith(".vcd") || fileName.endsWith(".dst")) {
                        DVTFileUtils.getInstance().openEditor(file, 0, "ro.amiq.dvt.diagrams.wave");
                        return;
                    }
                    IEditorPart editor = null;
                    if (finalIFile != null) {
                        editor = IDE.openEditor((IWorkbenchPage)DVTUiUtils.getActiveWorkbenchWindow().getActivePage(), (IFile)finalIFile);
                    } else {
                        IFileStore fileStore;
                        try {
                            fileStore = EFS.getStore((URI)file.toURI());
                        }
                        catch (CoreException e) {
                            throw new PartInitException("CoreException opening the file store on the URI " + file.toURI().toString(), (Throwable)e);
                        }
                        String editorId = "org.eclipse.ui.DefaultTextEditor";
                        IEditorDescriptor defaultEditor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                        if (defaultEditor != null) {
                            editorId = defaultEditor.getId();
                        }
                        editor = IDE.openEditor((IWorkbenchPage)DVTUiUtils.getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new FileStoreEditorInput(fileStore), (String)editorId);
                    }
                    if (showInNavigator.get()) {
                        OpenFileHandler.showInNavigator(editor);
                    }
                    if (lineNo[0] != null && lineNo[0] != -1) {
                        OpenFileHandler.gotoLine(editor, lineNo[0]);
                    }
                }
                catch (Exception e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw new DVTCliException(exc[0].getMessage());
        }
    }

    private IResource inProject(IProject project, IResource[] resources) {
        if (project == null) {
            return null;
        }
        if (resources.length == 0) {
            return null;
        }
        List resourcesInProject = Arrays.asList(resources).stream().filter(x -> x.getProject() == project).collect(Collectors.toList());
        if (resourcesInProject.isEmpty()) {
            return null;
        }
        return (IResource)resourcesInProject.get(0);
    }

    private IResource findFileAndRefreshParentFolder(IWorkspaceRoot wRoot, File file, IProject project) throws CoreException {
        IFile[] files = wRoot.findFilesForLocationURI(file.toURI());
        IResource fileInProject = null;
        if (project != null) {
            fileInProject = this.inProject(project, (IResource[])files);
        }
        if (fileInProject == null && files.length != 0) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile currentFile = iFileArray[n2];
                if (currentFile.getProject().isOpen()) {
                    fileInProject = currentFile;
                    break;
                }
                ++n2;
            }
        }
        if (fileInProject == null) {
            return null;
        }
        fileInProject.getParent().refreshLocal(1, null);
        return fileInProject;
    }

    public static void gotoLine(IEditorPart editor, int lineNo) throws DVTCliException {
        IRegion lineInfo;
        if (!(editor instanceof TextEditor)) {
            return;
        }
        TextEditor textEditor = (TextEditor)editor;
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (document == null) {
            return;
        }
        try {
            lineInfo = document.getLineInformation(lineNo - 1);
        }
        catch (BadLocationException badLocationException) {
            throw new DVTCliException("Specified line number '" + lineNo + "' is out of the valid range 1 .. " + document.getNumberOfLines());
        }
        textEditor.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
    }

    public static void showInNavigator(IEditorPart editor) {
        if (!(editor.getEditorInput() instanceof FileEditorInput)) {
            return;
        }
        IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
        if (file == null) {
            return;
        }
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IViewPart projectExplorer = activeWorkbenchWindow.getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (!(projectExplorer instanceof ISetSelectionTarget)) {
            return;
        }
        ((ISetSelectionTarget)projectExplorer).selectReveal((ISelection)new StructuredSelection((Object)file));
        IViewPart navigatorView = activeWorkbenchWindow.getActivePage().findView("org.eclipse.ui.views.ResourceNavigator");
        if (!(navigatorView instanceof ISetSelectionTarget)) {
            return;
        }
        ((ISetSelectionTarget)navigatorView).selectReveal((ISelection)new StructuredSelection((Object)file));
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)LINE));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)PROJECT));
        options.addOption(OptionBuilder.create((String)SHOW_IN_NAVIGATOR));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }
}

