/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;

public class OpenUrlHandler
extends AbstractCliHandlerDelegate {
    public String getCommandName() {
        return "openUrl";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        if (commandLine.getArgs().length < 2) {
            throw new DVTCliException("You did not specify the URL. It has to be the first parameter.");
        }
        String urlString = commandLine.getArgs()[1];
        if (urlString == null) {
            throw new DVTCliException("Could not determine URL from command.");
        }
        try {
            URL url = new URL(urlString);
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
            browser.openURL(url);
        }
        catch (Exception e) {
            String message = e.getMessage();
            throw new DVTCliException(message == null ? "An internal error has occured while trying to open the browser." : message);
        }
    }

    @Override
    public Options getOptions() {
        return new Options();
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }
}

