/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.cli.TemplateFromCliWizardDialog;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.wizards.templates.TemplateProjectWizard;

public class ProjectFromTemplate
extends AbstractCliHandlerDelegate {
    public String getCommandName() {
        return "createProjectFromTemplate";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(commandLine.getArgs()));
        args.remove(0);
        if (args.isEmpty()) {
            throw new DVTCliException("You did not specify the project location. It has to be the first parameter.");
        }
        String targetPath = (String)args.get(0);
        if (targetPath == null || targetPath.isEmpty()) {
            throw new DVTCliException("Invalid target location.");
        }
        File targetFile = new File(targetPath);
        if (!targetFile.canWrite()) {
            throw new DVTCliException("You don't have permision to write target directory: " + targetFile.getAbsolutePath());
        }
        String templatePath = commandLine.getOptionValue("template");
        if (templatePath == null) {
            throw new DVTCliException("Could not determine path to template.");
        }
        File templateFile = new File(templatePath);
        if (!templateFile.isDirectory()) {
            throw new DVTCliException("Path to template '" + templateFile.getAbsolutePath() + "' does not exist or is not a directory.");
        }
        TemplateProjectWizard wizard = new TemplateProjectWizard();
        IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
        wizard.initForCli(window.getWorkbench(), templatePath, targetPath);
        final TemplateFromCliWizardDialog dialog = new TemplateFromCliWizardDialog(window.getShell(), wizard);
        dialog.addPageChangedListener(wizard);
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"template"));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }
}

