/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.cli.RebuildProjectBase;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.utils.DVTStringUtil;

public class RebuildAllProjects
extends RebuildProjectBase<List<IProject>> {
    public String getCommandName() {
        return "rebuildAllProjects";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        List<String> args = this.getCommandArgs(commandLine);
        Object projects = this.getProjectsToRebuild((List)args);
        if (projects.isEmpty()) {
            return;
        }
        boolean isBlocking = commandLine.hasOption("blocking");
        Iterator iterator = projects.iterator();
        while (iterator.hasNext()) {
            IProject project = (IProject)iterator.next();
            this.rebuildProject(project, isBlocking);
        }
    }

    @Override
    protected List<IProject> getProjectsToRebuild(List<String> args) throws DVTCliException {
        if (!args.isEmpty()) {
            throw new DVTCliException("Unexpected arguments: " + DVTStringUtil.join(args, ","));
        }
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        return new ArrayList<IProject>(Arrays.asList(allProjects)).stream().filter(project -> project != null && project.exists() && project.isAccessible() && !"DVT-Settings".equals(project.getName())).collect(Collectors.toList());
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(OptionBuilder.create((String)"blocking"));
        return options;
    }
}

