/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.cli.RebuildProjectBase;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.ui.actions.DynamicBuildButtonsContribution;
import ro.amiq.dvt.utils.DVTStringUtil;

public class RebuildProject
extends RebuildProjectBase<IProject> {
    public static final String NONEXISTENT_BUILD_CONFIG = "The project ''{0}'' does not have the ''{1}'' build configuration";
    public static final String ERROR_MULTIPLE_BUILD_OPTIONS = "Only one -build option is allowed";
    public static final String NONEXISTENT_PROJECT = "The project to be rebuilt does not exist: {0}";
    private static final String MISSING_PROJECT_ERROR = "A project name must be specified";

    public String getCommandName() {
        return "rebuildProject";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        List<String> args = this.getCommandArgs(commandLine);
        IProject project = this.getProjectsToRebuild(args);
        if (commandLine.hasOption("build")) {
            String[] buildConfigs = commandLine.getOptionValues("build");
            this.handleBuildConfigArgument(project, buildConfigs);
        }
        this.rebuildProject(project, commandLine.hasOption("blocking"));
    }

    @Override
    protected IProject getProjectsToRebuild(List<String> args) throws DVTCliException {
        if (args.isEmpty()) {
            throw new DVTCliException(MISSING_PROJECT_ERROR);
        }
        String projectName = args.remove(0);
        if (!args.isEmpty()) {
            throw new DVTCliException("Unexpected arguments: " + DVTStringUtil.join(args, ","));
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists() || !project.isAccessible()) {
            throw new DVTCliException(MessageFormat.format(NONEXISTENT_PROJECT, projectName));
        }
        return project;
    }

    private void handleBuildConfigArgument(IProject project, String[] buildConfigs) throws DVTCliException, CoreException {
        if (buildConfigs.length > 1) {
            throw new DVTCliException(ERROR_MULTIPLE_BUILD_OPTIONS);
        }
        String firstBuildConfigName = buildConfigs[0];
        if (!this.validateBuildConfig(project, firstBuildConfigName)) {
            throw new DVTCliException(MessageFormat.format(NONEXISTENT_BUILD_CONFIG, project.getName(), firstBuildConfigName));
        }
        project.setSessionProperty(DVTStartupConstants.QN_DVT_DONT_RESTORE, (Object)true);
        DynamicBuildButtonsContribution.INSTANCE.setActiveBuildConfig(project, firstBuildConfigName, BuildConfigParseMode.FORCE_PARSE);
    }

    private boolean validateBuildConfig(IProject project, String buildConfigName) {
        List<String> availableBuildConfigs = BuildConfigManager.getAvailableBuildConfigs(project);
        return availableBuildConfigs.contains(buildConfigName);
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(OptionBuilder.create((String)"blocking"));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)"build"));
        return options;
    }
}

