/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class RebuildProjectBase<T>
extends AbstractCliHandlerDelegate {
    protected static final String UNEXPECTED_ARGUMENTS = "Unexpected arguments: ";
    protected static final String BLOCKING_OPTION = "blocking";

    protected List<String> getCommandArgs(CommandLine commandLine) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(commandLine.getArgs()));
        args.remove(0);
        return args;
    }

    protected void rebuildProject(IProject project, boolean isBlocking) throws DVTCliException {
        RebuildJob rebuildJob = new RebuildJob(project);
        rebuildJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        rebuildJob.schedule();
        if (isBlocking) {
            try {
                rebuildJob.join();
            }
            catch (InterruptedException e) {
                throw new DVTCliException(e.getMessage());
            }
        }
    }

    protected abstract T getProjectsToRebuild(List<String> var1) throws DVTCliException;

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }

    protected static class RebuildJob
    extends Job {
        private static final String REBUILDING_JOB_NAME = "Rebuilding_";
        private IProject project;

        protected RebuildJob(IProject project) {
            super(REBUILDING_JOB_NAME + project.getName());
            this.project = project;
        }

        public IStatus run(IProgressMonitor monitor) {
            DVTBuildConsoleRegistry.removeConsole(this.project);
            try {
                this.project.build(15, monitor);
                this.project.build(6, monitor);
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return e.getStatus();
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

