/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.utils.DVTStringUtil;

public class RefreshProject
extends AbstractCliHandlerDelegate {
    public String getCommandName() {
        return "refreshProject";
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(commandLine.getArgs()));
        args.remove(0);
        String projectName = (String)args.remove(0);
        if (!args.isEmpty()) {
            throw new DVTCliException("Unexpected arguments: " + DVTStringUtil.join(args, ","));
        }
        String subpath = "";
        if (commandLine.hasOption("subpath")) {
            subpath = commandLine.getOptionValue("subpath");
        }
        boolean blocking = commandLine.hasOption("blocking");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists() || !project.isAccessible()) {
            throw new DVTCliException("The project to be refreshed does not exist: " + projectName);
        }
        IProject resource = project;
        if (!subpath.isEmpty() && (resource = project.findMember(subpath)) == null) {
            throw new DVTCliException("The resource to be refreshed does not exist in the project: " + subpath);
        }
        int depth = 2;
        if (commandLine.hasOption("depth")) {
            try {
                depth = Integer.parseInt(commandLine.getOptionValue("depth"));
                if (!Arrays.asList(2, 1, 0).contains(depth)) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DVTCliException("Invalid depth '" + commandLine.getOptionValue("depth") + "' specified. Valid are: " + 2 + "(the resource and its direct and indirect members at any depth), " + 1 + "(the resource and its direct members), " + 0 + "(the resource, but not any of its members)");
            }
        }
        RefreshJob refreshJob = new RefreshJob((IResource)resource, depth, monitor);
        if (blocking) {
            IStatus status = refreshJob.run();
            if (!status.isOK()) {
                throw new DVTCliException("A problem occured during refresh:\n" + status.getMessage());
            }
        } else {
            refreshJob.schedule();
        }
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption(OptionBuilder.create((String)"blocking"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"subpath"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"depth"));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }

    private static class RefreshJob
    extends Job {
        IResource resource;
        int depth;
        IProgressMonitor monitor;

        public RefreshJob(IResource resource, int depth, IProgressMonitor monitor) {
            super("Refreshing " + resource.getFullPath().toOSString());
            this.resource = resource;
            this.depth = depth;
            this.monitor = monitor;
            this.setUser(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                this.resource.refreshLocal(this.depth, monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }

        public IStatus run() {
            return this.run(this.monitor);
        }
    }
}

