/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.exploratory.BaseExplorationCommand;
import ro.amiq.dvt.exploratory.LaunchExplorationTrigger;
import ro.amiq.dvt.exploratory.XPLConfig;
import ro.amiq.dvt.exploratory.contentassist.BaseContentAssistCommand;
import ro.amiq.dvt.exploratory.hyperlink.BaseHyperlinkCommand;
import ro.amiq.dvt.exploratory.incremental.BaseIncrementalCommand;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class RunPerformanceExploration
extends AbstractCliHandlerDelegate {
    private static final String PROJECT = "project";
    private static final String FEATURES = "features";
    private static final String PART = "part";
    private static final String FILTERS = "filters";
    private static final String GENERATE_AUTOMATIC_WAIVERS = "generate_automatic_waivers";
    private static final String RUNTIME = "runtime";
    private static final String OCCURRENCES = "occurrences";
    private static final String SKIP_RECOMPILED_FILES = "skip_recompiled_files";
    private static final Set<String> VALID_FEATURES = new HashSet<String>();
    private static final Set<String> VALID_PART;

    static {
        VALID_FEATURES.add("hyperlink");
        VALID_FEATURES.add("incremental");
        VALID_FEATURES.add("content-assist");
        VALID_PART = new HashSet<String>();
        VALID_PART.add("1/5");
        VALID_PART.add("2/5");
        VALID_PART.add("3/5");
        VALID_PART.add("4/5");
        VALID_PART.add("5/5");
        VALID_PART.add("FULL");
    }

    public String getCommandName() {
        return "runXpl";
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().c();
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        if (!commandLine.hasOption(PROJECT)) {
            throw new DVTCliException("You must specify for which project you want to run XPL.");
        }
        String projectName = commandLine.getOptionValue(PROJECT);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.exists()) {
            throw new DVTCliException("Project '" + projectName + "' does not exist in the workspace.");
        }
        if (!project.isOpen()) {
            throw new DVTCliException("Project '" + projectName + "' is not open.");
        }
        String features = null;
        if (commandLine.hasOption(FEATURES)) {
            features = commandLine.getOptionValue(FEATURES);
        }
        if (features == null) {
            throw new DVTCliException("You must specify the features you want to run the XPL.");
        }
        ArrayList<BaseExplorationCommand> commandList = new ArrayList<BaseExplorationCommand>();
        if (features.endsWith(":") || features.startsWith(":")) {
            throw new DVTCliException("The features format is not valid.");
        }
        HashSet<String> featureItems = new HashSet<String>(Arrays.asList(features.split(":")));
        for (String feature : featureItems) {
            BaseExplorationCommand command = this.getBaseExplorationCommandFromString(feature);
            if (command == null) {
                result.appendWarning("Ignoring feature " + feature + ". Valid are: " + DVTStringUtil.join(VALID_FEATURES, ", "));
                continue;
            }
            commandList.add(command);
        }
        XPLConfig xplConfig = new XPLConfig();
        xplConfig.setCommandsList(commandList);
        xplConfig.setTarget("Project");
        xplConfig.setPart("FULL");
        if (commandLine.hasOption(PART)) {
            String part = commandLine.getOptionValue(PART);
            if (!VALID_PART.contains(part)) {
                result.appendWarning("Ignoring part " + part + ". Valid are: " + DVTStringUtil.join(VALID_PART, ", "));
            } else {
                xplConfig.setPart(part);
            }
        }
        if (commandLine.hasOption(FILTERS)) {
            String filters = commandLine.getOptionValue(FILTERS);
            if (filters == null) {
                throw new DVTCliException("The filters you entered are not valid");
            }
            if (filters.endsWith(":") || filters.startsWith(":")) {
                throw new DVTCliException("The filters format is not valid.");
            }
            filters = filters.replace(':', '\n');
            xplConfig.setFilters(filters);
        }
        if (commandLine.hasOption(SKIP_RECOMPILED_FILES)) {
            xplConfig.setSkipRecompiledFiles(true);
        }
        if (!commandLine.hasOption(GENERATE_AUTOMATIC_WAIVERS) && (commandLine.hasOption(RUNTIME) || commandLine.hasOption(OCCURRENCES))) {
            throw new DVTCliException("The 'runtime' and 'occurences' option are available only if 'generate_automatic_waivers' option is specified.");
        }
        if (commandLine.hasOption(GENERATE_AUTOMATIC_WAIVERS)) {
            if (!commandLine.hasOption(RUNTIME) || !commandLine.hasOption(OCCURRENCES)) {
                throw new DVTCliException("The 'runtime' and 'occurences' options are mandatory when 'generate_automatic_waivers' option is specified.");
            }
            int runtimeValue = this.isValidNumber(commandLine.getOptionValue(RUNTIME));
            if (runtimeValue == -1) {
                throw new DVTCliException("The 'runtime' value is not valid. Valid are unsigned integer values.");
            }
            int occurencesValue = this.isValidNumber(commandLine.getOptionValue(OCCURRENCES));
            if (occurencesValue == -1) {
                throw new DVTCliException("The 'occurences' value is not valid. Valid are unsigned integer values bigger than 0.");
            }
            if (occurencesValue == 0) {
                throw new DVTCliException("The 'occurences' value is not valid. Valid are unsigned integer values bigger than 0.");
            }
            xplConfig.setGeneratedWaiversSpecifications(runtimeValue, occurencesValue);
        }
        Utils.syncExec(() -> LaunchExplorationTrigger.buildNowThenStartExploration(project, xplConfig));
    }

    private BaseExplorationCommand getBaseExplorationCommandFromString(String feature) {
        if (feature == null) {
            return null;
        }
        if ((feature = feature.replace('_', '-')).equals("hyperlink")) {
            return new BaseHyperlinkCommand(false);
        }
        if (feature.equals("incremental")) {
            return new BaseIncrementalCommand(false);
        }
        if (feature.equals("content-assist")) {
            return new BaseContentAssistCommand(false);
        }
        return null;
    }

    private int isValidNumber(String valueAsString) {
        if (valueAsString.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseUnsignedInt(valueAsString);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)PROJECT));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)FEATURES));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)PART));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)FILTERS));
        options.addOption(OptionBuilder.create((String)GENERATE_AUTOMATIC_WAIVERS));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)RUNTIME));
        OptionBuilder.hasArgs((int)1);
        options.addOption(OptionBuilder.create((String)OCCURRENCES));
        options.addOption(OptionBuilder.create((String)SKIP_RECOMPILED_FILES));
        return options;
    }
}

