/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.interpreter.DVTXUtils;
import ro.amiq.dvt.interpreter.RunProjectContributorsProxy;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTLogger;

public class RunProjectHandler
extends AbstractCliHandlerDelegate {
    private static final String COMMAND_NAME = "runProject";
    private static final String PROJECT_OPTION = "project";
    private static final String ARGS_FILE_OPTION = "run_cmd";
    private static final String SEED_OPTION = "seed";
    private static final String UVM_TEST_OPTION = "uvm_test";
    private static final String OVM_TEST_OPTION = "ovm_test";
    private static final String UVM_VERBOSITY_OPTION = "uvm_verbosity";
    private static final String OVM_VERBOSITY_OPTION = "ovm_verbosity";
    private static final String USE_BUILT_IN_DPIC_OPTION = "use_built_in_dpic";
    private static final String DEBUG_MODE_OPTION = "debug";
    private static final String GENERATE_VCD_OPTION = "generate_vcd";
    private static final String OPEN_WAVE_VIEWER_OPTION = "open_wave_viewer";

    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws DVTCliException, CoreException {
        boolean isRunMode;
        String ovmVerbosity;
        String uvmVerbosity;
        String ovmTestName;
        String uvmTestName;
        String seed;
        String projectName = commandLine.getOptionValue(PROJECT_OPTION);
        if (projectName == null || projectName.isEmpty()) {
            throw new DVTCliException("A project name must be specified.");
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        if (project == null || !project.exists()) {
            throw new DVTCliException("Project '" + projectName + "' does not exist in the workspace.");
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            throw new DVTCliException("Project location could not be determined.");
        }
        ArrayList<String> runArgs = new ArrayList<String>();
        String runArgsFilePath = commandLine.getOptionValue(ARGS_FILE_OPTION);
        if (runArgsFilePath != null && !runArgsFilePath.isEmpty()) {
            runArgs.addAll(this.getRunArgsFromFile(runArgsFilePath, projectLocation));
        }
        if ((seed = commandLine.getOptionValue(SEED_OPTION)) != null) {
            runArgs.add("+SEED=" + seed);
        }
        if ((uvmTestName = commandLine.getOptionValue(UVM_TEST_OPTION)) != null) {
            runArgs.add("+UVM_TESTNAME=" + uvmTestName);
        }
        if ((ovmTestName = commandLine.getOptionValue(OVM_TEST_OPTION)) != null) {
            runArgs.add("+OVM_TESTNAME=" + ovmTestName);
        }
        if ((uvmVerbosity = commandLine.getOptionValue(UVM_VERBOSITY_OPTION)) != null) {
            runArgs.add("+UVM_VERBOSITY=" + uvmVerbosity);
        }
        if ((ovmVerbosity = commandLine.getOptionValue(OVM_VERBOSITY_OPTION)) != null) {
            runArgs.add("+OVM_VERBOSITY=" + ovmVerbosity);
        }
        if (commandLine.hasOption(USE_BUILT_IN_DPIC_OPTION)) {
            runArgs.add("+dvtx_native_jimpl_uvm");
        }
        boolean bl = isRunMode = !commandLine.hasOption(DEBUG_MODE_OPTION);
        if (commandLine.hasOption(GENERATE_VCD_OPTION)) {
            runArgs.add("+dvt_sim_create_vcd");
        }
        if (commandLine.hasOption(OPEN_WAVE_VIEWER_OPTION)) {
            runArgs.add("+open_wave_viewer");
        }
        RunProjectContributorsProxy.INSTNACE.startXSim(project, runArgs.toArray(new String[0]), isRunMode);
    }

    private List<String> getRunArgsFromFile(String filePath, IPath projectLocation) throws DVTCliException {
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            file = new File(projectLocation.append(filePath).toOSString());
        }
        try {
            String fileCanonicalPath = file.getCanonicalPath();
            if (!file.exists() || !file.isFile()) {
                throw new DVTCliException("Run args file does not exist: " + fileCanonicalPath);
            }
            Set<String> runArgsFromFile = DVTXUtils.getRunArgsFromFile(fileCanonicalPath);
            if (runArgsFromFile == null || runArgsFromFile.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> runArgsList = new ArrayList<String>();
            runArgsList.add("+ARGS=");
            runArgsList.addAll(runArgsFromFile);
            return runArgsList;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            throw new DVTCliException("Run args file does not exist. Check the logs for more information.");
        }
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)PROJECT_OPTION));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)ARGS_FILE_OPTION));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)SEED_OPTION));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)UVM_TEST_OPTION));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)OVM_TEST_OPTION));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)UVM_VERBOSITY_OPTION));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)OVM_VERBOSITY_OPTION));
        options.addOption(OptionBuilder.create((String)USE_BUILT_IN_DPIC_OPTION));
        options.addOption(OptionBuilder.create((String)DEBUG_MODE_OPTION));
        options.addOption(OptionBuilder.create((String)GENERATE_VCD_OPTION));
        options.addOption(OptionBuilder.create((String)OPEN_WAVE_VIEWER_OPTION));
        return options;
    }
}

