/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cli;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.DVTPerspectiveSwitcher;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.cli.ICliHandlerDelegate;

public class SwitchPerspectiveHandler
implements ICliHandlerDelegate {
    public String getCommandName() {
        return "openPerspective";
    }

    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, List<String> command) throws DVTCliException, CoreException {
        if (command.size() < 2) {
            throw new DVTCliException("No perspective name specified.");
        }
        String perspectiveName = command.get(1);
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        List<IPerspectiveDescriptor> allPerspectiveDescriptors = Arrays.asList(registry.getPerspectives());
        List candidates = allPerspectiveDescriptors.stream().filter(pd -> perspectiveName.equals(pd.getLabel())).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            throw new DVTCliException("Perspective '" + perspectiveName + "' does not exist, available are:\n" + allPerspectiveDescriptors.stream().map(pd -> pd.getLabel()).collect(Collectors.joining(", ")));
        }
        DVTPerspectiveSwitcher.switchPerspective((String)((IPerspectiveDescriptor)candidates.get(0)).getId());
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }
}

