/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.comment.formatter;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.comment.formatter.CommentLinkResolverContributor;
import ro.amiq.dvt.comment.formatter.CommentWrapper;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum CommentFormatter {
    INSTANCE;

    private static final Pattern WAVEDROM_FORMAT_PATTERN;
    private static final String FAILED_IMAGE_HTML = "<img src='file://failed_to_generate_custom_diagram'/>";
    private static final Pattern MULTI_LINE_COMMENT_STARS;

    static {
        WAVEDROM_FORMAT_PATTERN = Pattern.compile("(?m)^\\s*([/]{2,}|[-]{2,}|[*]*)");
        MULTI_LINE_COMMENT_STARS = Pattern.compile("(^([ \\t]*\\*)\\**)( +|$)");
    }

    public DVTPair<String, String> format(String comment, IRfNamedElement element, ITextEditor activeEditor) {
        ICommentLinkResolver linkResolver = CommentLinkResolverContributor.get(element.getLanguageKind());
        DVTComment.CommentFormat format = CommentUtils.getInstance().getCommentFormat(this.cleanComment(comment, CommentUtils.useHtml()));
        int tooltipMaxSizePreference = CommentUtils.getTooltipMaxSizePreference();
        String limitSizeFooter = "";
        if (tooltipMaxSizePreference > 0 && comment.length() > tooltipMaxSizePreference) {
            comment = comment.substring(0, tooltipMaxSizePreference);
            limitSizeFooter = CommentUtils.getLimitSizeFooterText(tooltipMaxSizePreference);
        }
        List<CommentWrapper> segments = this.format(comment, element, activeEditor, linkResolver, format, CommentUtils.useHtml(), false, Collections.emptyList());
        StringBuilder result = new StringBuilder();
        for (CommentWrapper segment : segments) {
            result.append(segment.getContent());
        }
        return DVTPair.of(CommentUtils.getInstance().trimComment(result.append(limitSizeFooter).toString()), format.getPreferenceName());
    }

    public DVTPair<String, String> format(String comment, DVTComment.CommentFormat format, IRfNamedElement element, ITextEditor activeEditor) {
        ICommentLinkResolver linkResolver = CommentLinkResolverContributor.get(element.getLanguageKind());
        List<CommentWrapper> segments = this.format(comment, element, activeEditor, linkResolver, format, true, true, Collections.emptyList());
        StringBuilder result = new StringBuilder();
        for (CommentWrapper segment : segments) {
            result.append(segment.getContent());
        }
        return DVTPair.of(CommentUtils.getInstance().trimComment(result.toString()), format.getPreferenceName());
    }

    public List<CommentWrapper> format(String comment, IRfNamedElement element, ICommentLinkResolver linkResolver, DVTComment.CommentFormat format, boolean useHTML, List<String> functionArguments) {
        return this.format(comment, element, null, linkResolver, format, useHTML, true, functionArguments);
    }

    private List<CommentWrapper> format(String comment, IRfNamedElement element, ITextEditor editor, ICommentLinkResolver linkResolver, DVTComment.CommentFormat format, boolean useHTML, boolean embedDiagrams, List<String> functionArguments) {
        IProject project = this.getProject(element);
        List<CommentWrapper> commentSegments = this.splitComment(comment, element, embedDiagrams);
        for (CommentWrapper segment : commentSegments) {
            if (!CommentWrapper.CommentElement.TEXT.equals((Object)segment.getType())) continue;
            String content = this.cleanComment(segment.getContent(), useHTML);
            segment.setRawContent(content);
            content = CommentUtils.enhanceComment(element, content);
            content = useHTML ? DVTComment.toHTML(content, format, project, linkResolver, element, editor, embedDiagrams, functionArguments) : DVTComment.toMarkdown(content, format, project, linkResolver, element, editor, embedDiagrams, functionArguments);
            segment.setContent(content);
        }
        return commentSegments;
    }

    private List<CommentWrapper> splitComment(String comment, IRfNamedElement element, boolean specialDiagram) {
        LinkedList<CommentWrapper> result = new LinkedList<CommentWrapper>();
        int index = 0;
        int start = 0;
        comment = WaveDromManager.getInstance().getCommentWithExtractedWaveformFile(comment);
        try {
            while (index != -1) {
                index = comment.indexOf("@WAVEDROM_START", start);
                if (index != -1) {
                    result.add(this.computeTextComment(comment.substring(start, index)));
                    start = index;
                    index = comment.indexOf("@WAVEDROM_END", index + 1);
                    if (index != -1) {
                        result.add(this.computeWavedromComment(comment, specialDiagram, index, start));
                        start = index + "@WAVEDROM_END".length();
                        continue;
                    }
                    result.add(this.computeTextComment(comment.substring(start, comment.length())));
                    continue;
                }
                index = comment.indexOf("@DVT_DIAGRAM_START", start);
                if (index != -1) {
                    result.add(this.computeTextComment(comment.substring(start, index)));
                    start = index;
                    index = comment.indexOf("@DVT_DIAGRAM_END", index + 1);
                    if (index != -1) {
                        result.add(this.computeCustomDiagramComment(comment, element, !specialDiagram, index, start));
                        start = index + "@DVT_DIAGRAM_END".length();
                        continue;
                    }
                    result.add(this.computeTextComment(comment.substring(start, comment.length())));
                    continue;
                }
                result.add(this.computeTextComment(comment.substring(start, comment.length())));
            }
        }
        catch (NoSuchMethodException | ScriptException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private CommentWrapper computeTextComment(String comment) {
        return new CommentWrapper(CommentWrapper.CommentElement.TEXT, comment);
    }

    private CommentWrapper computeWavedromComment(String comment, boolean specialDiagram, int index, int start) throws NoSuchMethodException, ScriptException {
        String wavedromRaw = comment.substring(start + "@WAVEDROM_START".length(), index);
        String wavedrom = DVTStringUtil.replaceAll(WAVEDROM_FORMAT_PATTERN, wavedromRaw, "");
        String svg = CommentUtils.getInstance().getWavedromDiv(wavedrom, specialDiagram);
        return new CommentWrapper(CommentWrapper.CommentElement.WAVEDROM, svg);
    }

    private CommentWrapper computeCustomDiagramComment(String comment, IRfNamedElement element, boolean wrapIntoImg, int index, int start) {
        String customDiagramDesription = comment.substring(start + "@DVT_DIAGRAM_START".length(), index);
        String diagramPath = CommentUtils.getCustomDiagramOutputPath(element, customDiagramDesription, wrapIntoImg);
        StringBuilder result = new StringBuilder();
        if (diagramPath.startsWith("[FAILURE]")) {
            result.append(FAILED_IMAGE_HTML).append(" ");
        }
        result.append(diagramPath);
        return new CommentWrapper(CommentWrapper.CommentElement.CUSTOM_DIAGRAM, result.toString());
    }

    private String cleanComment(String comment, boolean toHTML) {
        String[] commentParts = new String[]{};
        if (comment.contains("\n") || comment.contains("\r")) {
            commentParts = DVTStringUtil.split(DVTStringUtil.NEW_LINE, comment);
            StringBuilder newComment = new StringBuilder();
            int i = 0;
            while (i < commentParts.length) {
                commentParts[i] = DVTStringUtil.replaceAll(MULTI_LINE_COMMENT_STARS, commentParts[i], "$3");
                newComment.append(commentParts[i].trim().isEmpty() ? "" : commentParts[i]);
                newComment.append(i < commentParts.length - 1 ? "\n" : "");
                ++i;
            }
            comment = newComment.toString();
        }
        comment = CommentUtils.getInstance().cleanUpSpecialCharacters(comment, toHTML);
        return comment;
    }

    private IProject getProject(IRfNamedElement element) {
        if (element == null) {
            return null;
        }
        IRfSingleLangProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return null;
        }
        return rfProject.getProject();
    }
}

