/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.comment.formatter;

import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.comment.formatter.CommentFormatter;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class CommentLinkResolver
implements ICommentLinkResolver {
    @Override
    public String createLinkToElement(IRfNamedElement element, String elementName) {
        return CommentUtils.getInstance().wrapIntoA("@START_LINK@" + RfElementPath.path(element).toString() + "@END_LINK@", elementName, true);
    }

    @Override
    public DVTTooltipContent getCommentFromLink(String linkPath) {
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project == null) {
            return null;
        }
        IRfNamedElement elementFromLink = this.getNamedElementFromPath(linkPath, project);
        if (elementFromLink == null) {
            return null;
        }
        DVTPair<String, String> tooltip = CommentFormatter.INSTANCE.format(elementFromLink.getRawUntrimmedComment("\n\n"), elementFromLink, this.getEditor());
        if (tooltip == null) {
            return null;
        }
        DVTTooltipContent tooltipContent = new DVTTooltipContent();
        tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, CommentUtils.getInstance().wrapIntoBold(DVTStringUtil.partiallyEscapeHTML(elementFromLink.getSignature()), true));
        tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, tooltip.getKey());
        tooltipContent.set(DVTTooltipContent.TooltipContent.PREFERENCE, tooltip.getValue());
        return tooltipContent;
    }

    @Override
    public void goToDeclarationOfElementFromLink(String path) {
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project == null) {
            return;
        }
        IRfNamedElement elementFromLink = this.getNamedElementFromPath(path, project);
        if (elementFromLink == null) {
            return;
        }
        DVTFileUtils.getInstance().openEditor(this.getFile(elementFromLink, project), elementFromLink.getLine(), elementFromLink.getName());
    }

    private ITextEditor getEditor() {
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (!(activeEditor instanceof ITextEditor)) {
            return null;
        }
        return (ITextEditor)activeEditor;
    }
}

